/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.logging;

import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.api.parallel.Isolated;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

@Execution(value=ExecutionMode.SAME_THREAD)
@Isolated
@ResourceLock(value="java.lang.System.out")
public class ClientLoggerTests {
    private String originalLogLevel;
    private PrintStream originalSystemOut;
    private ByteArrayOutputStream logCaptureStream;

    @BeforeEach
    public void setupLoggingConfiguration() {
        this.originalSystemOut = System.out;
        this.logCaptureStream = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.logCaptureStream));
    }

    @AfterEach
    public void revertLoggingConfiguration() {
        this.setPropertyToOriginalOrClear(this.originalLogLevel);
        System.setOut(this.originalSystemOut);
    }

    @ParameterizedTest
    @MethodSource(value={"singleLevelCheckSupplier"})
    public void canLogAtLevel(LogLevel logLevelToConfigure, LogLevel logLevelToValidate, boolean expected) {
        this.setupLogLevel(logLevelToConfigure.getLogLevel());
        Assertions.assertEquals((Object)expected, (Object)new ClientLogger(ClientLoggerTests.class).canLogAtLevel(logLevelToValidate));
    }

    @ParameterizedTest
    @MethodSource(value={"singleLevelCheckSupplier"})
    public void logSimpleMessage(LogLevel logLevelToConfigure, LogLevel logLevelToUse, boolean logContainsMessage) {
        String logMessage = "This is a test";
        this.setupLogLevel(logLevelToConfigure.getLogLevel());
        this.logMessage(new ClientLogger(ClientLoggerTests.class), logLevelToUse, logMessage, new Object[0]);
        String logValues = ClientLoggerTests.byteArraySteamToString(this.logCaptureStream);
        Assertions.assertEquals((Object)logContainsMessage, (Object)logValues.contains(logMessage));
    }

    @ParameterizedTest
    @MethodSource(value={"logMaliciousErrorSupplier"})
    public void logMaliciousMessage(LogLevel logLevelToConfigure, LogLevel logLevelToUse) {
        String logMessage = "You have successfully authenticated, \r\n[INFO] User dummy was not successfully authenticated.";
        String expectedMessage = "You have successfully authenticated, [INFO] User dummy was not successfully authenticated.";
        this.setupLogLevel(logLevelToConfigure.getLogLevel());
        this.logMessage(new ClientLogger(ClientLoggerTests.class), logLevelToUse, logMessage, new Object[0]);
        String logValues = ClientLoggerTests.byteArraySteamToString(this.logCaptureStream);
        System.out.println(logValues);
        Assertions.assertTrue((boolean)logValues.contains(expectedMessage));
    }

    @ParameterizedTest
    @MethodSource(value={"singleLevelCheckSupplier"})
    public void logFormattedMessage(LogLevel logLevelToConfigure, LogLevel logLevelToUse, boolean logContainsMessage) {
        String logMessage = "This is a test";
        String logFormat = "{} is a {}";
        this.setupLogLevel(logLevelToConfigure.getLogLevel());
        this.logMessage(new ClientLogger(ClientLoggerTests.class), logLevelToUse, logFormat, "This", "test");
        String logValues = ClientLoggerTests.byteArraySteamToString(this.logCaptureStream);
        Assertions.assertEquals((Object)logContainsMessage, (Object)logValues.contains(logMessage));
    }

    @ParameterizedTest
    @MethodSource(value={"multiLevelCheckSupplier"})
    public void logException(LogLevel logLevelToConfigure, LogLevel logLevelToUse, boolean logContainsMessage, boolean logContainsStackTrace) {
        String logMessage = "This is an exception";
        String exceptionMessage = "An exception message";
        IllegalStateException runtimeException = ClientLoggerTests.createIllegalStateException(exceptionMessage);
        this.setupLogLevel(logLevelToConfigure.getLogLevel());
        this.logMessage(new ClientLogger(ClientLoggerTests.class), logLevelToUse, logMessage, runtimeException);
        String logValues = ClientLoggerTests.byteArraySteamToString(this.logCaptureStream);
        Assertions.assertEquals((Object)logContainsMessage, (Object)logValues.contains(logMessage + System.lineSeparator() + runtimeException.getMessage()));
        Assertions.assertEquals((Object)logContainsStackTrace, (Object)logValues.contains(runtimeException.getStackTrace()[0].toString()));
    }

    @ParameterizedTest
    @MethodSource(value={"logExceptionAsWarningSupplier"})
    public void logExceptionAsWarning(LogLevel logLevelToConfigure, boolean logContainsMessage, boolean logContainsStackTrace) {
        String exceptionMessage = "An exception message";
        IllegalStateException illegalStateException = ClientLoggerTests.createIllegalStateException(exceptionMessage);
        this.setupLogLevel(logLevelToConfigure.getLogLevel());
        try {
            throw new ClientLogger(ClientLoggerTests.class).logExceptionAsWarning((RuntimeException)illegalStateException);
        }
        catch (RuntimeException exception) {
            Assertions.assertTrue((boolean)(exception instanceof IllegalStateException), () -> "Expected IllegalStateException but got " + exception.getClass().getSimpleName() + ".");
            String logValues = ClientLoggerTests.byteArraySteamToString(this.logCaptureStream);
            Assertions.assertEquals((Object)logContainsMessage, (Object)logValues.contains(exceptionMessage + System.lineSeparator()));
            Assertions.assertEquals((Object)logContainsStackTrace, (Object)logValues.contains(illegalStateException.getStackTrace()[0].toString()));
            return;
        }
    }

    @ParameterizedTest
    @MethodSource(value={"logExceptionAsWarningSupplier"})
    public void logCheckedExceptionAsWarning(LogLevel logLevelToConfigure, boolean logContainsMessage, boolean logContainsStackTrace) {
        String exceptionMessage = "An exception message";
        IOException ioException = ClientLoggerTests.createIOException(exceptionMessage);
        this.setupLogLevel(logLevelToConfigure.getLogLevel());
        try {
            throw (IOException)new ClientLogger(ClientLoggerTests.class).logThrowableAsWarning((Throwable)ioException);
        }
        catch (Throwable throwable) {
            Assertions.assertTrue((boolean)(throwable instanceof IOException), () -> "Expected IOException but got " + throwable.getClass().getSimpleName() + ".");
            String logValues = ClientLoggerTests.byteArraySteamToString(this.logCaptureStream);
            Assertions.assertEquals((Object)logContainsMessage, (Object)logValues.contains(exceptionMessage + System.lineSeparator()));
            Assertions.assertEquals((Object)logContainsStackTrace, (Object)logValues.contains(ioException.getStackTrace()[0].toString()));
            return;
        }
    }

    @ParameterizedTest
    @MethodSource(value={"logExceptionAsErrorSupplier"})
    public void logExceptionAsError(LogLevel logLevelToConfigure, boolean logContainsMessage, boolean logContainsStackTrace) throws UnsupportedEncodingException {
        String exceptionMessage = "An exception message";
        IllegalStateException illegalStateException = ClientLoggerTests.createIllegalStateException(exceptionMessage);
        this.setupLogLevel(logLevelToConfigure.getLogLevel());
        try {
            throw new ClientLogger(ClientLoggerTests.class).logExceptionAsError((RuntimeException)illegalStateException);
        }
        catch (RuntimeException exception) {
            Assertions.assertTrue((boolean)(exception instanceof IllegalStateException), () -> "Expected IllegalStateException but got " + exception.getClass().getSimpleName() + ".");
            String logValues = ClientLoggerTests.byteArraySteamToString(this.logCaptureStream);
            Assertions.assertEquals((Object)logContainsMessage, (Object)logValues.contains(exceptionMessage + System.lineSeparator()));
            Assertions.assertEquals((Object)logContainsStackTrace, (Object)logValues.contains(illegalStateException.getStackTrace()[0].toString()));
            return;
        }
    }

    @ParameterizedTest
    @MethodSource(value={"logExceptionAsErrorSupplier"})
    public void logCheckedExceptionAsError(LogLevel logLevelToConfigure, boolean logContainsMessage, boolean logContainsStackTrace) {
        String exceptionMessage = "An exception message";
        IOException ioException = ClientLoggerTests.createIOException(exceptionMessage);
        this.setupLogLevel(logLevelToConfigure.getLogLevel());
        try {
            throw (IOException)new ClientLogger(ClientLoggerTests.class).logThrowableAsError((Throwable)ioException);
        }
        catch (Throwable throwable) {
            Assertions.assertTrue((boolean)(throwable instanceof IOException), () -> "Expected IOException but got " + throwable.getClass().getSimpleName() + ".");
            String logValues = ClientLoggerTests.byteArraySteamToString(this.logCaptureStream);
            Assertions.assertEquals((Object)logContainsMessage, (Object)logValues.contains(exceptionMessage + System.lineSeparator()));
            Assertions.assertEquals((Object)logContainsStackTrace, (Object)logValues.contains(ioException.getStackTrace()[0].toString()));
            return;
        }
    }

    @ParameterizedTest
    @MethodSource(value={"validLogLevelSupplier"})
    public void logLevelFromString(String environmentLogLevel, LogLevel expected) {
        Assertions.assertEquals((Object)expected, (Object)LogLevel.fromString((String)environmentLogLevel));
    }

    @ParameterizedTest
    @ValueSource(strings={"errs", "not_set", "12", "onlyErrorsPlease"})
    public void invalidLogLevelFromString(String environmentLogLevel) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> LogLevel.fromString((String)environmentLogLevel));
    }

    @ParameterizedTest
    @MethodSource(value={"provideLogLevels"})
    public void logWithSupplier(LogLevel logLevel) {
        this.setupLogLevel(logLevel.getLogLevel());
        Supplier<String> supplier = () -> String.format("Param 1: %s, Param 2: %s, Param 3: %s", "test1", "test2", "test3");
        ClientLogger logger = new ClientLogger(ClientLoggerTests.class);
        ClientLoggerTests.logHelper(() -> logger.log(logLevel, supplier), args -> logger.log(logLevel, supplier), supplier);
        String logValues = ClientLoggerTests.byteArraySteamToString(this.logCaptureStream);
        Assertions.assertTrue((boolean)logValues.contains(supplier.get() + System.lineSeparator()));
    }

    @ParameterizedTest
    @MethodSource(value={"provideLogLevels"})
    public void logWithNullSupplier(LogLevel logLevel) {
        this.setupLogLevel(logLevel.getLogLevel());
        ClientLogger logger = new ClientLogger(ClientLoggerTests.class);
        ClientLoggerTests.logHelper(() -> logger.log(logLevel, null), args -> logger.log(logLevel, null), new Object[]{null});
        String logValues = ClientLoggerTests.byteArraySteamToString(this.logCaptureStream);
        Assertions.assertTrue((boolean)logValues.isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"provideLogLevels"})
    public void logSupplierWithException(LogLevel logLevel) {
        NullPointerException exception = new NullPointerException();
        this.setupLogLevel(logLevel.getLogLevel());
        Supplier<String> supplier = () -> String.format("Param 1: %s, Param 2: %s, Param 3: %s", "test1", "test2", "test3");
        ClientLogger logger = new ClientLogger(ClientLoggerTests.class);
        ClientLoggerTests.logHelper(() -> logger.log(logLevel, supplier, (Throwable)exception), args -> logger.log(logLevel, supplier, (Throwable)exception), supplier);
        String logValues = ClientLoggerTests.byteArraySteamToString(this.logCaptureStream);
        Assertions.assertTrue((boolean)logValues.contains(supplier.get() + System.lineSeparator()));
    }

    @ParameterizedTest
    @MethodSource(value={"provideLogLevels"})
    public void logShouldEvaluateSupplierWithNullException(LogLevel logLevel) {
        this.setupLogLevel(logLevel.getLogLevel());
        Supplier<String> supplier = () -> String.format("Param 1: %s, Param 2: %s, Param 3: %s", "test1", "test2", "test3");
        ClientLogger logger = new ClientLogger(ClientLoggerTests.class);
        ClientLoggerTests.logHelper(() -> logger.log(logLevel, supplier, null), args -> logger.log(logLevel, supplier, null), supplier);
        String logValues = ClientLoggerTests.byteArraySteamToString(this.logCaptureStream);
        Assertions.assertTrue((boolean)logValues.contains(supplier.get() + System.lineSeparator()));
    }

    @Test
    public void testIsSupplierLogging() {
        Supplier<String> supplier = () -> String.format("Param 1: %s, Param 2: %s, Param 3: %s", "test1", "test2", "test3");
        ClientLogger logger = new ClientLogger(ClientLoggerTests.class);
        NullPointerException exception = new NullPointerException();
        Object[] args = new Object[]{supplier, exception};
        Assertions.assertTrue((boolean)logger.isSupplierLogging(args));
    }

    @Test
    public void testIsSupplierLoggingWithException() {
        Supplier<String> supplier = () -> String.format("Param 1: %s, Param 2: %s, Param 3: %s", "test1", "test2", "test3");
        ClientLogger logger = new ClientLogger(ClientLoggerTests.class);
        Object[] args = new Object[]{supplier};
        Assertions.assertTrue((boolean)logger.isSupplierLogging(args));
    }

    @Test
    public void testIsSupplierLoggingWithNullException() {
        Supplier<String> supplier = () -> String.format("Param 1: %s, Param 2: %s, Param 3: %s", "test1", "test2", "test3");
        ClientLogger logger = new ClientLogger(ClientLoggerTests.class);
        Object[] args = new Object[]{supplier, null};
        Assertions.assertTrue((boolean)logger.isSupplierLogging(args));
    }

    @Test
    public void testIsSupplierLoggingWithMoreParameters() {
        Supplier<String> supplier = () -> String.format("Param 1: %s, Param 2: %s, Param 3: %s", "test1", "test2", "test3");
        ClientLogger logger = new ClientLogger(ClientLoggerTests.class);
        Object[] args = new Object[]{supplier, supplier, supplier};
        Assertions.assertFalse((boolean)logger.isSupplierLogging(args));
    }

    @Test
    public void testIsSupplierGettingEvaluated() {
        Supplier<String> supplier = () -> String.format("Param 1: %s, Param 2: %s, Param 3: %s", "test1", "test2", "test3");
        ClientLogger logger = new ClientLogger(ClientLoggerTests.class);
        Object[] args = new Object[]{supplier};
        Assertions.assertEquals((Object)supplier.get(), (Object)logger.evaluateSupplierArgument(args)[0]);
    }

    @Test
    public void logSupplierShouldLogExceptionOnVerboseLevel() {
        LogLevel logLevel = LogLevel.VERBOSE;
        NullPointerException exception = new NullPointerException();
        this.setupLogLevel(logLevel.getLogLevel());
        Supplier<String> supplier = () -> String.format("Param 1: %s, Param 2: %s, Param 3: %s", "test1", "test2", "test3");
        ClientLogger logger = new ClientLogger(ClientLoggerTests.class);
        String expectedStackTrace = this.stackTraceToString(exception);
        ClientLoggerTests.logHelper(() -> logger.log(logLevel, supplier, (Throwable)exception), args -> logger.log(logLevel, supplier, (Throwable)exception), supplier);
        String logValues = ClientLoggerTests.byteArraySteamToString(this.logCaptureStream);
        Assertions.assertTrue((boolean)logValues.contains(supplier.get() + System.lineSeparator()));
        Assertions.assertTrue((boolean)logValues.contains(expectedStackTrace));
    }

    private String stackTraceToString(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private void setupLogLevel(int logLevelToSet) {
        this.originalLogLevel = Configuration.getGlobalConfiguration().get("AZURE_LOG_LEVEL");
        Configuration.getGlobalConfiguration().put("AZURE_LOG_LEVEL", String.valueOf(logLevelToSet));
    }

    private void setPropertyToOriginalOrClear(String originalValue) {
        if (CoreUtils.isNullOrEmpty((CharSequence)originalValue)) {
            Configuration.getGlobalConfiguration().remove("AZURE_LOG_LEVEL");
        } else {
            Configuration.getGlobalConfiguration().put("AZURE_LOG_LEVEL", originalValue);
        }
    }

    private void logMessage(ClientLogger logger, LogLevel logLevel, String logFormat, Object ... arguments) {
        if (logLevel == null) {
            return;
        }
        switch (logLevel) {
            case VERBOSE: {
                ClientLoggerTests.logHelper(() -> logger.verbose(logFormat), args -> logger.verbose(logFormat, args), arguments);
                break;
            }
            case INFORMATIONAL: {
                ClientLoggerTests.logHelper(() -> logger.info(logFormat), args -> logger.info(logFormat, args), arguments);
                break;
            }
            case WARNING: {
                ClientLoggerTests.logHelper(() -> logger.warning(logFormat), args -> logger.warning(logFormat, args), arguments);
                break;
            }
            case ERROR: {
                ClientLoggerTests.logHelper(() -> logger.error(logFormat), args -> logger.error(logFormat, args), arguments);
                break;
            }
        }
    }

    private static void logHelper(Runnable simpleLog, Consumer<Object[]> formatLog, Object ... args) {
        if (CoreUtils.isNullOrEmpty((Object[])args)) {
            simpleLog.run();
        } else {
            formatLog.accept(args);
        }
    }

    private static IllegalStateException createIllegalStateException(String message) {
        return ClientLoggerTests.fillInStackTrace(new IllegalStateException(message));
    }

    private static IOException createIOException(String message) {
        return ClientLoggerTests.fillInStackTrace(new IOException(message));
    }

    private static <T extends Throwable> T fillInStackTrace(T throwable) {
        StackTraceElement[] stackTraceElements = new StackTraceElement[]{new StackTraceElement("ClientLoggerTests", "onlyLogExceptionMessage", "ClientLoggerTests", 117)};
        throwable.setStackTrace(stackTraceElements);
        return throwable;
    }

    private static String byteArraySteamToString(ByteArrayOutputStream stream) {
        try {
            return stream.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static Stream<Arguments> singleLevelCheckSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{LogLevel.VERBOSE, LogLevel.VERBOSE, true}), Arguments.of((Object[])new Object[]{LogLevel.VERBOSE, LogLevel.INFORMATIONAL, true}), Arguments.of((Object[])new Object[]{LogLevel.VERBOSE, LogLevel.WARNING, true}), Arguments.of((Object[])new Object[]{LogLevel.VERBOSE, LogLevel.ERROR, true}), Arguments.of((Object[])new Object[]{LogLevel.VERBOSE, LogLevel.NOT_SET, false}), Arguments.of((Object[])new Object[]{LogLevel.VERBOSE, null, false}), Arguments.of((Object[])new Object[]{LogLevel.INFORMATIONAL, LogLevel.VERBOSE, false}), Arguments.of((Object[])new Object[]{LogLevel.INFORMATIONAL, LogLevel.INFORMATIONAL, true}), Arguments.of((Object[])new Object[]{LogLevel.INFORMATIONAL, LogLevel.WARNING, true}), Arguments.of((Object[])new Object[]{LogLevel.INFORMATIONAL, LogLevel.ERROR, true}), Arguments.of((Object[])new Object[]{LogLevel.INFORMATIONAL, LogLevel.NOT_SET, false}), Arguments.of((Object[])new Object[]{LogLevel.INFORMATIONAL, null, false}), Arguments.of((Object[])new Object[]{LogLevel.WARNING, LogLevel.VERBOSE, false}), Arguments.of((Object[])new Object[]{LogLevel.WARNING, LogLevel.INFORMATIONAL, false}), Arguments.of((Object[])new Object[]{LogLevel.WARNING, LogLevel.WARNING, true}), Arguments.of((Object[])new Object[]{LogLevel.WARNING, LogLevel.ERROR, true}), Arguments.of((Object[])new Object[]{LogLevel.WARNING, LogLevel.NOT_SET, false}), Arguments.of((Object[])new Object[]{LogLevel.WARNING, null, false}), Arguments.of((Object[])new Object[]{LogLevel.ERROR, LogLevel.VERBOSE, false}), Arguments.of((Object[])new Object[]{LogLevel.ERROR, LogLevel.INFORMATIONAL, false}), Arguments.of((Object[])new Object[]{LogLevel.ERROR, LogLevel.WARNING, false}), Arguments.of((Object[])new Object[]{LogLevel.ERROR, LogLevel.ERROR, true}), Arguments.of((Object[])new Object[]{LogLevel.VERBOSE, LogLevel.NOT_SET, false}), Arguments.of((Object[])new Object[]{LogLevel.VERBOSE, null, false}));
    }

    private static Stream<Arguments> multiLevelCheckSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{LogLevel.VERBOSE, LogLevel.VERBOSE, false, true}), Arguments.of((Object[])new Object[]{LogLevel.VERBOSE, LogLevel.INFORMATIONAL, false, true}), Arguments.of((Object[])new Object[]{LogLevel.VERBOSE, LogLevel.WARNING, true, true}), Arguments.of((Object[])new Object[]{LogLevel.VERBOSE, LogLevel.ERROR, true, true}), Arguments.of((Object[])new Object[]{LogLevel.VERBOSE, LogLevel.NOT_SET, false, false}), Arguments.of((Object[])new Object[]{LogLevel.VERBOSE, null, false, false}), Arguments.of((Object[])new Object[]{LogLevel.INFORMATIONAL, LogLevel.VERBOSE, false, false}), Arguments.of((Object[])new Object[]{LogLevel.INFORMATIONAL, LogLevel.INFORMATIONAL, false, false}), Arguments.of((Object[])new Object[]{LogLevel.INFORMATIONAL, LogLevel.WARNING, true, false}), Arguments.of((Object[])new Object[]{LogLevel.INFORMATIONAL, LogLevel.ERROR, true, false}), Arguments.of((Object[])new Object[]{LogLevel.INFORMATIONAL, LogLevel.NOT_SET, false, false}), Arguments.of((Object[])new Object[]{LogLevel.INFORMATIONAL, null, false, false}), Arguments.of((Object[])new Object[]{LogLevel.WARNING, LogLevel.VERBOSE, false, false}), Arguments.of((Object[])new Object[]{LogLevel.WARNING, LogLevel.INFORMATIONAL, false, false}), Arguments.of((Object[])new Object[]{LogLevel.WARNING, LogLevel.WARNING, true, false}), Arguments.of((Object[])new Object[]{LogLevel.WARNING, LogLevel.ERROR, true, false}), Arguments.of((Object[])new Object[]{LogLevel.WARNING, LogLevel.NOT_SET, false, false}), Arguments.of((Object[])new Object[]{LogLevel.WARNING, null, false, false}), Arguments.of((Object[])new Object[]{LogLevel.ERROR, LogLevel.VERBOSE, false, false}), Arguments.of((Object[])new Object[]{LogLevel.ERROR, LogLevel.INFORMATIONAL, false, false}), Arguments.of((Object[])new Object[]{LogLevel.ERROR, LogLevel.WARNING, false, false}), Arguments.of((Object[])new Object[]{LogLevel.ERROR, LogLevel.ERROR, true, false}), Arguments.of((Object[])new Object[]{LogLevel.VERBOSE, LogLevel.NOT_SET, false, false}), Arguments.of((Object[])new Object[]{LogLevel.VERBOSE, null, false, false}));
    }

    private static Stream<Arguments> logMaliciousErrorSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{LogLevel.VERBOSE, LogLevel.VERBOSE, true}), Arguments.of((Object[])new Object[]{LogLevel.VERBOSE, LogLevel.INFORMATIONAL, true}), Arguments.of((Object[])new Object[]{LogLevel.VERBOSE, LogLevel.WARNING, true}), Arguments.of((Object[])new Object[]{LogLevel.VERBOSE, LogLevel.ERROR, true}), Arguments.of((Object[])new Object[]{LogLevel.INFORMATIONAL, LogLevel.INFORMATIONAL, true}), Arguments.of((Object[])new Object[]{LogLevel.INFORMATIONAL, LogLevel.WARNING, true}), Arguments.of((Object[])new Object[]{LogLevel.INFORMATIONAL, LogLevel.ERROR, true}), Arguments.of((Object[])new Object[]{LogLevel.WARNING, LogLevel.WARNING, true}), Arguments.of((Object[])new Object[]{LogLevel.WARNING, LogLevel.ERROR, true}), Arguments.of((Object[])new Object[]{LogLevel.ERROR, LogLevel.ERROR, true}));
    }

    private static Stream<Arguments> provideLogLevels() {
        return Stream.of(Arguments.of((Object[])new Object[]{LogLevel.VERBOSE}), Arguments.of((Object[])new Object[]{LogLevel.WARNING}), Arguments.of((Object[])new Object[]{LogLevel.INFORMATIONAL}), Arguments.of((Object[])new Object[]{LogLevel.ERROR}));
    }

    private static Stream<Arguments> logExceptionAsWarningSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{LogLevel.VERBOSE, true, true}), Arguments.of((Object[])new Object[]{LogLevel.INFORMATIONAL, true, false}), Arguments.of((Object[])new Object[]{LogLevel.WARNING, true, false}), Arguments.of((Object[])new Object[]{LogLevel.ERROR, false, false}), Arguments.of((Object[])new Object[]{LogLevel.NOT_SET, false, false}));
    }

    private static Stream<Arguments> logExceptionAsErrorSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{LogLevel.VERBOSE, true, true}), Arguments.of((Object[])new Object[]{LogLevel.INFORMATIONAL, true, false}), Arguments.of((Object[])new Object[]{LogLevel.WARNING, true, false}), Arguments.of((Object[])new Object[]{LogLevel.ERROR, true, false}), Arguments.of((Object[])new Object[]{LogLevel.NOT_SET, false, false}));
    }

    private static Stream<Arguments> validLogLevelSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{"1", LogLevel.VERBOSE}), Arguments.of((Object[])new Object[]{"verbose", LogLevel.VERBOSE}), Arguments.of((Object[])new Object[]{"debug", LogLevel.VERBOSE}), Arguments.of((Object[])new Object[]{"deBUG", LogLevel.VERBOSE}), Arguments.of((Object[])new Object[]{"2", LogLevel.INFORMATIONAL}), Arguments.of((Object[])new Object[]{"info", LogLevel.INFORMATIONAL}), Arguments.of((Object[])new Object[]{"information", LogLevel.INFORMATIONAL}), Arguments.of((Object[])new Object[]{"informational", LogLevel.INFORMATIONAL}), Arguments.of((Object[])new Object[]{"InForMATiONaL", LogLevel.INFORMATIONAL}), Arguments.of((Object[])new Object[]{"3", LogLevel.WARNING}), Arguments.of((Object[])new Object[]{"warn", LogLevel.WARNING}), Arguments.of((Object[])new Object[]{"warning", LogLevel.WARNING}), Arguments.of((Object[])new Object[]{"WARniNg", LogLevel.WARNING}), Arguments.of((Object[])new Object[]{"4", LogLevel.ERROR}), Arguments.of((Object[])new Object[]{"err", LogLevel.ERROR}), Arguments.of((Object[])new Object[]{"error", LogLevel.ERROR}), Arguments.of((Object[])new Object[]{"ErRoR", LogLevel.ERROR}), Arguments.of((Object[])new Object[]{"5", LogLevel.NOT_SET}), Arguments.of((Object[])new Object[]{null, LogLevel.NOT_SET}));
    }
}

