/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.paging;

import com.azure.core.util.IterableStream;
import com.azure.core.util.paging.ContinuablePage;
import com.azure.core.util.paging.ContinuablePagedFluxCore;
import com.azure.core.util.paging.PageRetriever;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import reactor.core.publisher.Flux;

public class PagedFluxCoreJavaDocCodeSnippets {
    public void customContinuationTokenSnippet() {
        class FileShareServiceClient {
            FileShareServiceClient() {
            }

            Flux<1FilePage> getFilePages(FileContinuationToken token) {
                class FilePage
                implements ContinuablePage<FileContinuationToken, File> {
                    private final IterableStream<File> elements;
                    private final FileContinuationToken fileContinuationToken;

                    FilePage(List<File> elements, FileContinuationToken fileContinuationToken) {
                        class File {
                            private final String guid;

                            File(String guid) {
                                this.guid = guid;
                            }

                            public String getGuid() {
                                return this.guid;
                            }
                        }
                        this.elements = IterableStream.of(elements);
                        class FileContinuationToken {
                            private final int nextLinkId;

                            FileContinuationToken(int nextLinkId) {
                                this.nextLinkId = nextLinkId;
                            }

                            public int getNextLinkId() {
                                return this.nextLinkId;
                            }
                        }
                        this.fileContinuationToken = fileContinuationToken;
                    }

                    public IterableStream<File> getElements() {
                        return this.elements;
                    }

                    public FileContinuationToken getContinuationToken() {
                        return this.fileContinuationToken;
                    }
                }
                List<File> files = Collections.singletonList(new File(UUID.randomUUID().toString()));
                if (token.getNextLinkId() < 10) {
                    return Flux.just((Object)new FilePage(files, null));
                }
                return Flux.just((Object)new FilePage(files, new FileContinuationToken((int)Math.floor(Math.random() * 20.0))));
            }
        }
        FileShareServiceClient client = new FileShareServiceClient();
        Supplier<PageRetriever<FileContinuationToken, 1FilePage>> pageRetrieverProvider = () -> (continuationToken, pageSize) -> {
            return client.getFilePages((FileContinuationToken)continuationToken);
        };
        class FilePagedFlux
        extends ContinuablePagedFluxCore<FileContinuationToken, 1File, 1FilePage> {
            FilePagedFlux(Supplier<PageRetriever<FileContinuationToken, 1FilePage>> pageRetrieverProvider) {
                super(pageRetrieverProvider);
            }
        }
        FilePagedFlux filePagedFlux = new FilePagedFlux(pageRetrieverProvider);
    }
}

