/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.util.serializer.Foo;
import com.azure.core.util.serializer.FooChild;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AdditionalPropertiesSerializerTests {
    @Test
    public void canSerializeAdditionalProperties() throws Exception {
        Foo foo = new Foo();
        foo.bar("hello.world");
        foo.baz(new ArrayList<String>());
        foo.baz().add("hello");
        foo.baz().add("hello.world");
        foo.qux(new HashMap<String, String>());
        foo.qux().put("hello", "world");
        foo.qux().put("a.b", "c.d");
        foo.qux().put("bar.a", "ttyy");
        foo.qux().put("bar.b", "uuzz");
        foo.additionalProperties(new HashMap<String, Object>());
        foo.additionalProperties().put("bar", "baz");
        foo.additionalProperties().put("a.b", "c.d");
        foo.additionalProperties().put("properties.bar", "barbar");
        String serialized = new JacksonAdapter().serialize((Object)foo, SerializerEncoding.JSON);
        Assertions.assertEquals((Object)"{\"$type\":\"foo\",\"properties\":{\"bar\":\"hello.world\",\"props\":{\"baz\":[\"hello\",\"hello.world\"],\"q\":{\"qux\":{\"hello\":\"world\",\"a.b\":\"c.d\",\"bar.b\":\"uuzz\",\"bar.a\":\"ttyy\"}}}},\"bar\":\"baz\",\"a.b\":\"c.d\",\"properties.bar\":\"barbar\"}", (Object)serialized);
    }

    @Test
    public void canDeserializeAdditionalProperties() throws Exception {
        String wireValue = "{\"$type\":\"foo\",\"properties\":{\"bar\":\"hello.world\",\"props\":{\"baz\":[\"hello\",\"hello.world\"],\"q\":{\"qux\":{\"hello\":\"world\",\"a.b\":\"c.d\",\"bar.b\":\"uuzz\",\"bar.a\":\"ttyy\"}}}},\"bar\":\"baz\",\"a.b\":\"c.d\",\"properties.bar\":\"barbar\"}";
        Foo deserialized = (Foo)new JacksonAdapter().deserialize(wireValue, Foo.class, SerializerEncoding.JSON);
        Assertions.assertNotNull(deserialized.additionalProperties());
        Assertions.assertEquals((Object)"baz", (Object)deserialized.additionalProperties().get("bar"));
        Assertions.assertEquals((Object)"c.d", (Object)deserialized.additionalProperties().get("a.b"));
        Assertions.assertEquals((Object)"barbar", (Object)deserialized.additionalProperties().get("properties.bar"));
    }

    @Test
    public void canSerializeAdditionalPropertiesThroughInheritance() throws Exception {
        FooChild foo = new FooChild();
        foo.bar("hello.world");
        foo.baz(new ArrayList<String>());
        foo.baz().add("hello");
        foo.baz().add("hello.world");
        foo.qux(new HashMap<String, String>());
        foo.qux().put("hello", "world");
        foo.qux().put("a.b", "c.d");
        foo.qux().put("bar.a", "ttyy");
        foo.qux().put("bar.b", "uuzz");
        foo.additionalProperties(new HashMap<String, Object>());
        foo.additionalProperties().put("bar", "baz");
        foo.additionalProperties().put("a.b", "c.d");
        foo.additionalProperties().put("properties.bar", "barbar");
        String serialized = new JacksonAdapter().serialize((Object)foo, SerializerEncoding.JSON);
        Assertions.assertEquals((Object)"{\"$type\":\"foochild\",\"properties\":{\"bar\":\"hello.world\",\"props\":{\"baz\":[\"hello\",\"hello.world\"],\"q\":{\"qux\":{\"hello\":\"world\",\"a.b\":\"c.d\",\"bar.b\":\"uuzz\",\"bar.a\":\"ttyy\"}}}},\"bar\":\"baz\",\"a.b\":\"c.d\",\"properties.bar\":\"barbar\"}", (Object)serialized);
    }

    @Test
    public void canDeserializeAdditionalPropertiesThroughInheritance() throws Exception {
        String wireValue = "{\"$type\":\"foochild\",\"properties\":{\"bar\":\"hello.world\",\"props\":{\"baz\":[\"hello\",\"hello.world\"],\"q\":{\"qux\":{\"hello\":\"world\",\"a.b\":\"c.d\",\"bar.b\":\"uuzz\",\"bar.a\":\"ttyy\"}}}},\"bar\":\"baz\",\"a.b\":\"c.d\",\"properties.bar\":\"barbar\"}";
        Foo deserialized = (Foo)new JacksonAdapter().deserialize(wireValue, Foo.class, SerializerEncoding.JSON);
        Assertions.assertNotNull(deserialized.additionalProperties());
        Assertions.assertEquals((Object)"baz", (Object)deserialized.additionalProperties().get("bar"));
        Assertions.assertEquals((Object)"c.d", (Object)deserialized.additionalProperties().get("a.b"));
        Assertions.assertEquals((Object)"barbar", (Object)deserialized.additionalProperties().get("properties.bar"));
        Assertions.assertTrue((boolean)(deserialized instanceof FooChild));
        Assertions.assertEquals((Object)"hello.world", (Object)deserialized.bar());
        Assertions.assertNotNull(deserialized.baz());
        Assertions.assertEquals((int)2, (int)deserialized.baz().size());
        Assertions.assertTrue((boolean)deserialized.baz().contains("hello"));
        Assertions.assertTrue((boolean)deserialized.baz().contains("hello.world"));
        Assertions.assertNotNull(deserialized.qux());
        Assertions.assertEquals((int)4, (int)deserialized.qux().size());
        Assertions.assertTrue((boolean)deserialized.qux().containsKey("hello"));
        Assertions.assertTrue((boolean)deserialized.qux().containsKey("a.b"));
        Assertions.assertTrue((boolean)deserialized.qux().containsKey("bar.a"));
        Assertions.assertTrue((boolean)deserialized.qux().containsKey("bar.b"));
        Assertions.assertEquals((Object)"world", (Object)deserialized.qux().get("hello"));
        Assertions.assertEquals((Object)"c.d", (Object)deserialized.qux().get("a.b"));
        Assertions.assertEquals((Object)"ttyy", (Object)deserialized.qux().get("bar.a"));
        Assertions.assertEquals((Object)"uuzz", (Object)deserialized.qux().get("bar.b"));
    }

    @Test
    public void canSerializeAdditionalPropertiesWithNestedAdditionalProperties() throws Exception {
        Foo foo = new Foo();
        foo.bar("hello.world");
        foo.baz(new ArrayList<String>());
        foo.baz().add("hello");
        foo.baz().add("hello.world");
        foo.qux(new HashMap<String, String>());
        foo.qux().put("hello", "world");
        foo.qux().put("a.b", "c.d");
        foo.qux().put("bar.a", "ttyy");
        foo.qux().put("bar.b", "uuzz");
        foo.additionalProperties(new HashMap<String, Object>());
        foo.additionalProperties().put("bar", "baz");
        foo.additionalProperties().put("a.b", "c.d");
        foo.additionalProperties().put("properties.bar", "barbar");
        Foo nestedFoo = new Foo();
        nestedFoo.bar("bye.world");
        nestedFoo.additionalProperties(new HashMap<String, Object>());
        nestedFoo.additionalProperties().put("name", "Sushi");
        foo.additionalProperties().put("foo", nestedFoo);
        String serialized = new JacksonAdapter().serialize((Object)foo, SerializerEncoding.JSON);
        Assertions.assertEquals((Object)"{\"$type\":\"foo\",\"properties\":{\"bar\":\"hello.world\",\"props\":{\"baz\":[\"hello\",\"hello.world\"],\"q\":{\"qux\":{\"hello\":\"world\",\"a.b\":\"c.d\",\"bar.b\":\"uuzz\",\"bar.a\":\"ttyy\"}}}},\"bar\":\"baz\",\"foo\":{\"properties\":{\"bar\":\"bye.world\"},\"name\":\"Sushi\"},\"a.b\":\"c.d\",\"properties.bar\":\"barbar\"}", (Object)serialized);
    }
}

