/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.util.serializer.JacksonAdapter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class DateTimeDeserializerTests {
    private static final ObjectMapper MAPPER = new JacksonAdapter().serializer();

    @ParameterizedTest
    @MethodSource(value={"deserializeOffsetDateTimeSupplier"})
    public void deserializeJson(String dateTimeJson, OffsetDateTime expected) throws IOException {
        Assertions.assertEquals((Object)expected, (Object)MAPPER.readValue(dateTimeJson, OffsetDateTime.class));
    }

    private static Stream<Arguments> deserializeOffsetDateTimeSupplier() {
        OffsetDateTime minValue = OffsetDateTime.of(1, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        OffsetDateTime unixEpoch = OffsetDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        OffsetDateTime nonUtcTimeZone = OffsetDateTime.of(2020, 1, 1, 0, 0, 0, 0, ZoneOffset.ofHours(-7));
        return Stream.of(Arguments.of((Object[])new Object[]{"\"0001-01-01T00:00:00\"", minValue}), Arguments.of((Object[])new Object[]{String.valueOf(minValue.toEpochSecond()), minValue}), Arguments.of((Object[])new Object[]{"\"0001-01-01T00:00:00Z\"", minValue}), Arguments.of((Object[])new Object[]{"\"1970-01-01T00:00:00\"", unixEpoch}), Arguments.of((Object[])new Object[]{"\"1970-01-01T00:00:00Z\"", unixEpoch}), Arguments.of((Object[])new Object[]{"\"2020-01-01T00:00:00-07:00\"", nonUtcTimeZone}));
    }
}

