/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.util.serializer.DurationSerializer;
import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DurationSerializerTests {
    @Test
    public void toStringWithNull() {
        Assertions.assertNull((Object)DurationSerializer.toString(null));
    }

    @Test
    public void toStringWith0Milliseconds() {
        Assertions.assertEquals((Object)"PT0S", (Object)DurationSerializer.toString((Duration)Duration.ofMillis(0L)));
    }

    @Test
    public void toStringWith1Milliseconds() {
        Assertions.assertEquals((Object)"PT0.001S", (Object)DurationSerializer.toString((Duration)Duration.ofMillis(1L)));
    }

    @Test
    public void toStringWith9Milliseconds() {
        Assertions.assertEquals((Object)"PT0.009S", (Object)DurationSerializer.toString((Duration)Duration.ofMillis(9L)));
    }

    @Test
    public void toStringWith10Milliseconds() {
        Assertions.assertEquals((Object)"PT0.01S", (Object)DurationSerializer.toString((Duration)Duration.ofMillis(10L)));
    }

    @Test
    public void toStringWith11Milliseconds() {
        Assertions.assertEquals((Object)"PT0.011S", (Object)DurationSerializer.toString((Duration)Duration.ofMillis(11L)));
    }

    @Test
    public void toStringWith99Milliseconds() {
        Assertions.assertEquals((Object)"PT0.099S", (Object)DurationSerializer.toString((Duration)Duration.ofMillis(99L)));
    }

    @Test
    public void toStringWith100Milliseconds() {
        Assertions.assertEquals((Object)"PT0.1S", (Object)DurationSerializer.toString((Duration)Duration.ofMillis(100L)));
    }

    @Test
    public void toStringWith101Milliseconds() {
        Assertions.assertEquals((Object)"PT0.101S", (Object)DurationSerializer.toString((Duration)Duration.ofMillis(101L)));
    }

    @Test
    public void toStringWith999Milliseconds() {
        Assertions.assertEquals((Object)"PT0.999S", (Object)DurationSerializer.toString((Duration)Duration.ofMillis(999L)));
    }

    @Test
    public void toStringWith10illiseconds() {
        Assertions.assertEquals((Object)"PT1S", (Object)DurationSerializer.toString((Duration)Duration.ofMillis(1000L)));
    }

    @Test
    public void toStringWith1Second() {
        Assertions.assertEquals((Object)"PT1S", (Object)DurationSerializer.toString((Duration)Duration.ofSeconds(1L)));
    }

    @Test
    public void toStringWith9Seconds() {
        Assertions.assertEquals((Object)"PT9S", (Object)DurationSerializer.toString((Duration)Duration.ofSeconds(9L)));
    }

    @Test
    public void toStringWith10Seconds() {
        Assertions.assertEquals((Object)"PT10S", (Object)DurationSerializer.toString((Duration)Duration.ofSeconds(10L)));
    }

    @Test
    public void toStringWith11Seconds() {
        Assertions.assertEquals((Object)"PT11S", (Object)DurationSerializer.toString((Duration)Duration.ofSeconds(11L)));
    }

    @Test
    public void toStringWith59Seconds() {
        Assertions.assertEquals((Object)"PT59S", (Object)DurationSerializer.toString((Duration)Duration.ofSeconds(59L)));
    }

    @Test
    public void toStringWith60Seconds() {
        Assertions.assertEquals((Object)"PT1M", (Object)DurationSerializer.toString((Duration)Duration.ofSeconds(60L)));
    }

    @Test
    public void toStringWith61Seconds() {
        Assertions.assertEquals((Object)"PT1M1S", (Object)DurationSerializer.toString((Duration)Duration.ofSeconds(61L)));
    }

    @Test
    public void toStringWith1Minute() {
        Assertions.assertEquals((Object)"PT1M", (Object)DurationSerializer.toString((Duration)Duration.ofMinutes(1L)));
    }

    @Test
    public void toStringWith9Minutes() {
        Assertions.assertEquals((Object)"PT9M", (Object)DurationSerializer.toString((Duration)Duration.ofMinutes(9L)));
    }

    @Test
    public void toStringWith10Minutes() {
        Assertions.assertEquals((Object)"PT10M", (Object)DurationSerializer.toString((Duration)Duration.ofMinutes(10L)));
    }

    @Test
    public void toStringWith11Minutes() {
        Assertions.assertEquals((Object)"PT11M", (Object)DurationSerializer.toString((Duration)Duration.ofMinutes(11L)));
    }

    @Test
    public void toStringWith59Minutes() {
        Assertions.assertEquals((Object)"PT59M", (Object)DurationSerializer.toString((Duration)Duration.ofMinutes(59L)));
    }

    @Test
    public void toStringWith60Minutes() {
        Assertions.assertEquals((Object)"PT1H", (Object)DurationSerializer.toString((Duration)Duration.ofMinutes(60L)));
    }

    @Test
    public void toStringWith61Minutes() {
        Assertions.assertEquals((Object)"PT1H1M", (Object)DurationSerializer.toString((Duration)Duration.ofMinutes(61L)));
    }

    @Test
    public void toStringWith1Hour() {
        Assertions.assertEquals((Object)"PT1H", (Object)DurationSerializer.toString((Duration)Duration.ofHours(1L)));
    }

    @Test
    public void toStringWith9Hours() {
        Assertions.assertEquals((Object)"PT9H", (Object)DurationSerializer.toString((Duration)Duration.ofHours(9L)));
    }

    @Test
    public void toStringWith10Hours() {
        Assertions.assertEquals((Object)"PT10H", (Object)DurationSerializer.toString((Duration)Duration.ofHours(10L)));
    }

    @Test
    public void toStringWith11Hours() {
        Assertions.assertEquals((Object)"PT11H", (Object)DurationSerializer.toString((Duration)Duration.ofHours(11L)));
    }

    @Test
    public void toStringWith23Hours() {
        Assertions.assertEquals((Object)"PT23H", (Object)DurationSerializer.toString((Duration)Duration.ofHours(23L)));
    }

    @Test
    public void toStringWith24Hours() {
        Assertions.assertEquals((Object)"P1D", (Object)DurationSerializer.toString((Duration)Duration.ofHours(24L)));
    }

    @Test
    public void toStringWith25Hours() {
        Assertions.assertEquals((Object)"P1DT1H", (Object)DurationSerializer.toString((Duration)Duration.ofHours(25L)));
    }

    @Test
    public void toStringWith1Day() {
        Assertions.assertEquals((Object)"P1D", (Object)DurationSerializer.toString((Duration)Duration.ofDays(1L)));
    }

    @Test
    public void toStringWith9Days() {
        Assertions.assertEquals((Object)"P9D", (Object)DurationSerializer.toString((Duration)Duration.ofDays(9L)));
    }

    @Test
    public void toStringWith10Days() {
        Assertions.assertEquals((Object)"P10D", (Object)DurationSerializer.toString((Duration)Duration.ofDays(10L)));
    }

    @Test
    public void toStringWith11Days() {
        Assertions.assertEquals((Object)"P11D", (Object)DurationSerializer.toString((Duration)Duration.ofDays(11L)));
    }

    @Test
    public void toStringWith99Days() {
        Assertions.assertEquals((Object)"P99D", (Object)DurationSerializer.toString((Duration)Duration.ofDays(99L)));
    }

    @Test
    public void toStringWith100Days() {
        Assertions.assertEquals((Object)"P100D", (Object)DurationSerializer.toString((Duration)Duration.ofDays(100L)));
    }

    @Test
    public void toStringWith101Days() {
        Assertions.assertEquals((Object)"P101D", (Object)DurationSerializer.toString((Duration)Duration.ofDays(101L)));
    }
}

