/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.implementation.TypeUtil;
import com.azure.core.implementation.models.jsonflatten.ClassWithFlattenedProperties;
import com.azure.core.implementation.models.jsonflatten.FlattenedProduct;
import com.azure.core.implementation.models.jsonflatten.FlattenedPropertiesAndJsonAnyGetter;
import com.azure.core.implementation.models.jsonflatten.JsonFlattenNestedInner;
import com.azure.core.implementation.models.jsonflatten.JsonFlattenOnArrayType;
import com.azure.core.implementation.models.jsonflatten.JsonFlattenOnCollectionType;
import com.azure.core.implementation.models.jsonflatten.JsonFlattenOnJsonIgnoredProperty;
import com.azure.core.implementation.models.jsonflatten.JsonFlattenOnPrimitiveType;
import com.azure.core.implementation.models.jsonflatten.JsonFlattenWithJsonInfoDiscriminator;
import com.azure.core.implementation.models.jsonflatten.School;
import com.azure.core.implementation.models.jsonflatten.Student;
import com.azure.core.implementation.models.jsonflatten.Teacher;
import com.azure.core.implementation.models.jsonflatten.VirtualMachineIdentity;
import com.azure.core.implementation.models.jsonflatten.VirtualMachineScaleSet;
import com.azure.core.implementation.models.jsonflatten.VirtualMachineScaleSetNetworkConfiguration;
import com.azure.core.implementation.models.jsonflatten.VirtualMachineScaleSetNetworkProfile;
import com.azure.core.implementation.models.jsonflatten.VirtualMachineScaleSetVMProfile;
import com.azure.core.util.serializer.AnimalShelter;
import com.azure.core.util.serializer.AnimalWithTypeIdContainingDot;
import com.azure.core.util.serializer.ComposeTurtles;
import com.azure.core.util.serializer.DogWithTypeIdContainingDot;
import com.azure.core.util.serializer.FlattenableAnimalInfo;
import com.azure.core.util.serializer.Foo;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.RabbitWithTypeIdContainingDot;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.core.util.serializer.TurtleWithTypeIdContainingDot;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import wiremock.com.google.common.collect.ImmutableList;

public class FlatteningSerializerTests {
    private static final JacksonAdapter ADAPTER = new JacksonAdapter();

    @Test
    public void canFlatten() {
        Foo foo = new Foo();
        foo.bar("hello.world");
        List<String> baz = Arrays.asList("hello", "hello.world");
        foo.baz(baz);
        HashMap<String, String> qux = new HashMap<String, String>();
        qux.put("hello", "world");
        qux.put("a.b", "c.d");
        qux.put("bar.a", "ttyy");
        qux.put("bar.b", "uuzz");
        foo.qux(qux);
        String serialized = FlatteningSerializerTests.serialize(foo);
        Assertions.assertEquals((Object)"{\"$type\":\"foo\",\"properties\":{\"bar\":\"hello.world\",\"props\":{\"baz\":[\"hello\",\"hello.world\"],\"q\":{\"qux\":{\"hello\":\"world\",\"a.b\":\"c.d\",\"bar.b\":\"uuzz\",\"bar.a\":\"ttyy\"}}}}}", (Object)serialized);
        Foo deserialized = (Foo)FlatteningSerializerTests.deserialize(serialized, Foo.class);
        Assertions.assertEquals((Object)"hello.world", (Object)deserialized.bar());
        Assertions.assertArrayEquals((Object[])new String[]{"hello", "hello.world"}, (Object[])deserialized.baz().toArray());
        Assertions.assertNotNull(deserialized.qux());
        Assertions.assertEquals((Object)"world", (Object)deserialized.qux().get("hello"));
        Assertions.assertEquals((Object)"c.d", (Object)deserialized.qux().get("a.b"));
        Assertions.assertEquals((Object)"ttyy", (Object)deserialized.qux().get("bar.a"));
        Assertions.assertEquals((Object)"uuzz", (Object)deserialized.qux().get("bar.b"));
    }

    @Test
    public void canSerializeMapKeysWithDotAndSlash() {
        String serialized = FlatteningSerializerTests.serialize(this.prepareSchoolModel());
        Assertions.assertEquals((Object)"{\"teacher\":{\"students\":{\"af.B/D\":{},\"af.B/C\":{}}},\"tags\":{\"foo.aa\":\"bar\",\"x.y\":\"zz\"},\"properties\":{\"name\":\"school1\"}}", (Object)serialized);
    }

    @Test
    public void canHandleTypeWithTypeIdContainingDotAndNoProperties() {
        String rabbitSerialized = "{\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\"}";
        String shelterSerialized = "{\"properties\":{\"animalsInfo\":[{\"animal\":{\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\"}},{\"animal\":{\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\"}}]}}";
        AnimalWithTypeIdContainingDot rabbitDeserialized = (AnimalWithTypeIdContainingDot)FlatteningSerializerTests.deserialize(rabbitSerialized, AnimalWithTypeIdContainingDot.class);
        Assertions.assertTrue((boolean)(rabbitDeserialized instanceof RabbitWithTypeIdContainingDot));
        Assertions.assertNotNull((Object)rabbitDeserialized);
        AnimalShelter shelterDeserialized = (AnimalShelter)FlatteningSerializerTests.deserialize(shelterSerialized, AnimalShelter.class);
        Assertions.assertNotNull((Object)shelterDeserialized);
        Assertions.assertEquals((int)2, (int)shelterDeserialized.animalsInfo().size());
        for (FlattenableAnimalInfo animalInfo : shelterDeserialized.animalsInfo()) {
            Assertions.assertTrue((boolean)(animalInfo.animal() instanceof RabbitWithTypeIdContainingDot));
            Assertions.assertNotNull((Object)animalInfo.animal());
        }
    }

    @Test
    public void canHandleTypeWithTypeIdContainingDot0() {
        List<String> meals = Arrays.asList("carrot", "apple");
        RabbitWithTypeIdContainingDot animalToSerialize = new RabbitWithTypeIdContainingDot().withMeals(meals);
        String serialized = FlatteningSerializerTests.serialize(animalToSerialize);
        String[] results = new String[]{"{\"meals\":[\"carrot\",\"apple\"],\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\"}", "{\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\",\"meals\":[\"carrot\",\"apple\"]}"};
        Assertions.assertTrue((boolean)Arrays.asList(results).contains(serialized));
        AnimalWithTypeIdContainingDot animalDeserialized = (AnimalWithTypeIdContainingDot)FlatteningSerializerTests.deserialize(serialized, AnimalWithTypeIdContainingDot.class);
        Assertions.assertTrue((boolean)(animalDeserialized instanceof RabbitWithTypeIdContainingDot));
        RabbitWithTypeIdContainingDot rabbit = (RabbitWithTypeIdContainingDot)animalDeserialized;
        Assertions.assertNotNull(rabbit.meals());
        Assertions.assertEquals((int)rabbit.meals().size(), (int)2);
    }

    @Test
    public void canHandleTypeWithTypeIdContainingDot1() {
        List<String> meals = Arrays.asList("carrot", "apple");
        RabbitWithTypeIdContainingDot rabbitToSerialize = new RabbitWithTypeIdContainingDot().withMeals(meals);
        String serialized = FlatteningSerializerTests.serialize(rabbitToSerialize);
        String[] results = new String[]{"{\"meals\":[\"carrot\",\"apple\"],\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\"}", "{\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\",\"meals\":[\"carrot\",\"apple\"]}"};
        Assertions.assertTrue((boolean)Arrays.asList(results).contains(serialized));
        RabbitWithTypeIdContainingDot rabbitDeserialized = (RabbitWithTypeIdContainingDot)FlatteningSerializerTests.deserialize(serialized, RabbitWithTypeIdContainingDot.class);
        Assertions.assertNotNull((Object)rabbitDeserialized);
        Assertions.assertNotNull(rabbitDeserialized.meals());
        Assertions.assertEquals((int)rabbitDeserialized.meals().size(), (int)2);
    }

    @Test
    public void canHandleTypeWithFlattenablePropertyAndTypeIdContainingDot0() {
        DogWithTypeIdContainingDot animalToSerialize = new DogWithTypeIdContainingDot().withBreed("AKITA").withCuteLevel(10);
        String serialized = FlatteningSerializerTests.serialize(animalToSerialize);
        String[] results = new String[]{"{\"breed\":\"AKITA\",\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\",\"properties\":{\"cuteLevel\":10}}", "{\"breed\":\"AKITA\",\"properties\":{\"cuteLevel\":10},\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\"}", "{\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\",\"breed\":\"AKITA\",\"properties\":{\"cuteLevel\":10}}", "{\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\",\"properties\":{\"cuteLevel\":10},\"breed\":\"AKITA\"}", "{\"properties\":{\"cuteLevel\":10},\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\",\"breed\":\"AKITA\"}", "{\"properties\":{\"cuteLevel\":10},\"breed\":\"AKITA\",\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\"}"};
        Assertions.assertTrue((boolean)Arrays.asList(results).contains(serialized));
        AnimalWithTypeIdContainingDot animalDeserialized = (AnimalWithTypeIdContainingDot)FlatteningSerializerTests.deserialize(serialized, AnimalWithTypeIdContainingDot.class);
        Assertions.assertTrue((boolean)(animalDeserialized instanceof DogWithTypeIdContainingDot));
        DogWithTypeIdContainingDot dogDeserialized = (DogWithTypeIdContainingDot)animalDeserialized;
        Assertions.assertNotNull((Object)dogDeserialized);
        Assertions.assertEquals((Object)dogDeserialized.breed(), (Object)"AKITA");
        Assertions.assertEquals((Integer)dogDeserialized.cuteLevel(), (Integer)10);
    }

    @Test
    public void canHandleTypeWithFlattenablePropertyAndTypeIdContainingDot1() {
        DogWithTypeIdContainingDot dogToSerialize = new DogWithTypeIdContainingDot().withBreed("AKITA").withCuteLevel(10);
        String serialized = FlatteningSerializerTests.serialize(dogToSerialize);
        String[] results = new String[]{"{\"breed\":\"AKITA\",\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\",\"properties\":{\"cuteLevel\":10}}", "{\"breed\":\"AKITA\",\"properties\":{\"cuteLevel\":10},\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\"}", "{\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\",\"breed\":\"AKITA\",\"properties\":{\"cuteLevel\":10}}", "{\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\",\"properties\":{\"cuteLevel\":10},\"breed\":\"AKITA\"}", "{\"properties\":{\"cuteLevel\":10},\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\",\"breed\":\"AKITA\"}", "{\"properties\":{\"cuteLevel\":10},\"breed\":\"AKITA\",\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\"}"};
        Assertions.assertTrue((boolean)Arrays.asList(results).contains(serialized));
        DogWithTypeIdContainingDot dogDeserialized = (DogWithTypeIdContainingDot)FlatteningSerializerTests.deserialize(serialized, DogWithTypeIdContainingDot.class);
        Assertions.assertNotNull((Object)dogDeserialized);
        Assertions.assertEquals((Object)dogDeserialized.breed(), (Object)"AKITA");
        Assertions.assertEquals((Integer)dogDeserialized.cuteLevel(), (Integer)10);
    }

    @Test
    public void canHandleArrayOfTypeWithTypeIdContainingDot0() {
        List<String> meals = Arrays.asList("carrot", "apple");
        RabbitWithTypeIdContainingDot animalToSerialize = new RabbitWithTypeIdContainingDot().withMeals(meals);
        ArrayList<RabbitWithTypeIdContainingDot> animalsToSerialize = new ArrayList<RabbitWithTypeIdContainingDot>();
        animalsToSerialize.add(animalToSerialize);
        String serialized = FlatteningSerializerTests.serialize(animalsToSerialize);
        String[] results = new String[]{"[{\"meals\":[\"carrot\",\"apple\"],\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\"}]", "[{\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\",\"meals\":[\"carrot\",\"apple\"]}]"};
        Assertions.assertTrue((boolean)Arrays.asList(results).contains(serialized));
        List animalsDeserialized = (List)FlatteningSerializerTests.deserialize(serialized, TypeUtil.createParameterizedType(List.class, (Type[])new Type[]{AnimalWithTypeIdContainingDot.class}));
        Assertions.assertNotNull((Object)animalsDeserialized);
        Assertions.assertEquals((int)1, (int)animalsDeserialized.size());
        AnimalWithTypeIdContainingDot animalDeserialized = (AnimalWithTypeIdContainingDot)animalsDeserialized.get(0);
        Assertions.assertTrue((boolean)(animalDeserialized instanceof RabbitWithTypeIdContainingDot));
        RabbitWithTypeIdContainingDot rabbitDeserialized = (RabbitWithTypeIdContainingDot)animalDeserialized;
        Assertions.assertNotNull(rabbitDeserialized.meals());
        Assertions.assertEquals((int)rabbitDeserialized.meals().size(), (int)2);
    }

    @Test
    public void canHandleArrayOfTypeWithTypeIdContainingDot1() {
        List<String> meals = Arrays.asList("carrot", "apple");
        RabbitWithTypeIdContainingDot rabbitToSerialize = new RabbitWithTypeIdContainingDot().withMeals(meals);
        ArrayList<RabbitWithTypeIdContainingDot> rabbitsToSerialize = new ArrayList<RabbitWithTypeIdContainingDot>();
        rabbitsToSerialize.add(rabbitToSerialize);
        String serialized = FlatteningSerializerTests.serialize(rabbitsToSerialize);
        String[] results = new String[]{"[{\"meals\":[\"carrot\",\"apple\"],\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\"}]", "[{\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\",\"meals\":[\"carrot\",\"apple\"]}]"};
        Assertions.assertTrue((boolean)Arrays.asList(results).contains(serialized));
        List rabbitsDeserialized = (List)FlatteningSerializerTests.deserialize(serialized, TypeUtil.createParameterizedType(List.class, (Type[])new Type[]{RabbitWithTypeIdContainingDot.class}));
        Assertions.assertNotNull((Object)rabbitsDeserialized);
        Assertions.assertEquals((int)1, (int)rabbitsDeserialized.size());
        RabbitWithTypeIdContainingDot rabbitDeserialized = (RabbitWithTypeIdContainingDot)rabbitsDeserialized.get(0);
        Assertions.assertNotNull(rabbitDeserialized.meals());
        Assertions.assertEquals((int)rabbitDeserialized.meals().size(), (int)2);
    }

    @Test
    public void canHandleComposedTypeWithTypeIdContainingDot0() {
        List<String> meals = Arrays.asList("carrot", "apple");
        RabbitWithTypeIdContainingDot animalToSerialize = new RabbitWithTypeIdContainingDot().withMeals(meals);
        FlattenableAnimalInfo animalInfoToSerialize = new FlattenableAnimalInfo().withAnimal(animalToSerialize);
        ImmutableList animalsInfoSerialized = ImmutableList.of((Object)animalInfoToSerialize);
        AnimalShelter animalShelterToSerialize = new AnimalShelter().withAnimalsInfo((List<FlattenableAnimalInfo>)animalsInfoSerialized);
        String serialized = FlatteningSerializerTests.serialize(animalShelterToSerialize);
        String[] results = new String[]{"{\"properties\":{\"animalsInfo\":[{\"animal\":{\"meals\":[\"carrot\",\"apple\"],\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\"}}]}}", "{\"properties\":{\"animalsInfo\":[{\"animal\":{\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\",\"meals\":[\"carrot\",\"apple\"]}}]}}"};
        Assertions.assertTrue((boolean)Arrays.asList(results).contains(serialized));
        AnimalShelter shelterDeserialized = (AnimalShelter)FlatteningSerializerTests.deserialize(serialized, AnimalShelter.class);
        Assertions.assertNotNull(shelterDeserialized.animalsInfo());
        Assertions.assertEquals((int)shelterDeserialized.animalsInfo().size(), (int)1);
        FlattenableAnimalInfo animalsInfoDeserialized = shelterDeserialized.animalsInfo().get(0);
        Assertions.assertTrue((boolean)(animalsInfoDeserialized.animal() instanceof RabbitWithTypeIdContainingDot));
        AnimalWithTypeIdContainingDot animalDeserialized = animalsInfoDeserialized.animal();
        Assertions.assertTrue((boolean)(animalDeserialized instanceof RabbitWithTypeIdContainingDot));
        RabbitWithTypeIdContainingDot rabbitDeserialized = (RabbitWithTypeIdContainingDot)animalDeserialized;
        Assertions.assertNotNull((Object)rabbitDeserialized);
        Assertions.assertNotNull(rabbitDeserialized.meals());
        Assertions.assertEquals((int)rabbitDeserialized.meals().size(), (int)2);
    }

    @Test
    public void canHandleComposedSpecificPolymorphicTypeWithTypeId() {
        String serializedCollectionWithTypeId = "{\"turtlesSet1\":[{\"age\":100,\"size\":10,\"@odata.type\":\"#Favourite.Pet.TurtleWithTypeIdContainingDot\"},{\"age\":200,\"size\":20,\"@odata.type\":\"#Favourite.Pet.TurtleWithTypeIdContainingDot\"}]}";
        ComposeTurtles composedTurtleDeserialized = (ComposeTurtles)FlatteningSerializerTests.deserialize(serializedCollectionWithTypeId, ComposeTurtles.class);
        Assertions.assertNotNull((Object)composedTurtleDeserialized);
        Assertions.assertNotNull(composedTurtleDeserialized.turtlesSet1());
        Assertions.assertEquals((int)2, (int)composedTurtleDeserialized.turtlesSet1().size());
        FlatteningSerializerTests.serialize(composedTurtleDeserialized);
        String serializedScalarWithTypeId = "{\"turtlesSet1Lead\":{\"age\":100,\"size\":10,\"@odata.type\":\"#Favourite.Pet.TurtleWithTypeIdContainingDot\"}}";
        composedTurtleDeserialized = (ComposeTurtles)FlatteningSerializerTests.deserialize(serializedScalarWithTypeId, ComposeTurtles.class);
        Assertions.assertNotNull((Object)composedTurtleDeserialized);
        Assertions.assertNotNull((Object)composedTurtleDeserialized.turtlesSet1Lead());
        Assertions.assertEquals((long)10L, (long)composedTurtleDeserialized.turtlesSet1Lead().size().intValue());
        Assertions.assertEquals((long)100L, (long)composedTurtleDeserialized.turtlesSet1Lead().age().intValue());
        FlatteningSerializerTests.serialize(composedTurtleDeserialized);
    }

    @Test
    public void canHandleComposedSpecificPolymorphicTypeWithoutTypeId() {
        String serializedCollectionWithTypeId = "{\"turtlesSet1\":[{\"age\":100,\"size\":10 },{\"age\":200,\"size\":20 }]}";
        ComposeTurtles composedTurtleDeserialized = (ComposeTurtles)FlatteningSerializerTests.deserialize(serializedCollectionWithTypeId, ComposeTurtles.class);
        Assertions.assertNotNull((Object)composedTurtleDeserialized);
        Assertions.assertNotNull(composedTurtleDeserialized.turtlesSet1());
        Assertions.assertEquals((int)2, (int)composedTurtleDeserialized.turtlesSet1().size());
        FlatteningSerializerTests.serialize(composedTurtleDeserialized);
        String serializedScalarWithTypeId = "{\"turtlesSet1Lead\":{\"age\":100,\"size\":10 }}";
        composedTurtleDeserialized = (ComposeTurtles)FlatteningSerializerTests.deserialize(serializedScalarWithTypeId, ComposeTurtles.class);
        Assertions.assertNotNull((Object)composedTurtleDeserialized);
        Assertions.assertNotNull((Object)composedTurtleDeserialized.turtlesSet1Lead());
        Assertions.assertEquals((long)100L, (long)composedTurtleDeserialized.turtlesSet1Lead().age().intValue());
        FlatteningSerializerTests.serialize(composedTurtleDeserialized);
    }

    @Test
    public void canHandleComposedSpecificPolymorphicTypeWithAndWithoutTypeId() {
        String serializedCollectionWithTypeId = "{\"turtlesSet1\":[{\"age\":100,\"size\":10,\"@odata.type\":\"#Favourite.Pet.TurtleWithTypeIdContainingDot\"},{\"age\":200,\"size\":20 }]}";
        ComposeTurtles composedTurtleDeserialized = (ComposeTurtles)FlatteningSerializerTests.deserialize(serializedCollectionWithTypeId, ComposeTurtles.class);
        Assertions.assertNotNull((Object)composedTurtleDeserialized);
        Assertions.assertNotNull(composedTurtleDeserialized.turtlesSet1());
        Assertions.assertEquals((int)2, (int)composedTurtleDeserialized.turtlesSet1().size());
        FlatteningSerializerTests.serialize(composedTurtleDeserialized);
    }

    @Test
    public void canHandleComposedGenericPolymorphicTypeWithTypeId() {
        String serializedCollectionWithTypeId = "{\"turtlesSet2\":[{\"age\":100,\"size\":10,\"@odata.type\":\"#Favourite.Pet.TurtleWithTypeIdContainingDot\"},{\"age\":200,\"size\":20,\"@odata.type\":\"#Favourite.Pet.TurtleWithTypeIdContainingDot\"}]}";
        ComposeTurtles composedTurtleDeserialized = (ComposeTurtles)FlatteningSerializerTests.deserialize(serializedCollectionWithTypeId, ComposeTurtles.class);
        Assertions.assertNotNull((Object)composedTurtleDeserialized);
        Assertions.assertNotNull(composedTurtleDeserialized.turtlesSet2());
        Assertions.assertEquals((int)2, (int)composedTurtleDeserialized.turtlesSet2().size());
        Assertions.assertTrue((boolean)(composedTurtleDeserialized.turtlesSet2().get(0) instanceof TurtleWithTypeIdContainingDot));
        Assertions.assertTrue((boolean)(composedTurtleDeserialized.turtlesSet2().get(1) instanceof TurtleWithTypeIdContainingDot));
        FlatteningSerializerTests.serialize(composedTurtleDeserialized);
        String serializedScalarWithTypeId = "{\"turtlesSet2Lead\":{\"age\":100,\"size\":10,\"@odata.type\":\"#Favourite.Pet.TurtleWithTypeIdContainingDot\"}}";
        composedTurtleDeserialized = (ComposeTurtles)FlatteningSerializerTests.deserialize(serializedScalarWithTypeId, ComposeTurtles.class);
        Assertions.assertNotNull((Object)composedTurtleDeserialized);
        Assertions.assertNotNull((Object)composedTurtleDeserialized.turtlesSet2Lead());
        Assertions.assertTrue((boolean)(composedTurtleDeserialized.turtlesSet2Lead() instanceof TurtleWithTypeIdContainingDot));
        Assertions.assertEquals((long)10L, (long)((TurtleWithTypeIdContainingDot)composedTurtleDeserialized.turtlesSet2Lead()).size().intValue());
        Assertions.assertEquals((long)100L, (long)composedTurtleDeserialized.turtlesSet2Lead().age().intValue());
        FlatteningSerializerTests.serialize(composedTurtleDeserialized);
    }

    @Test
    public void canHandleComposedGenericPolymorphicTypeWithoutTypeId() {
        String serializedCollectionWithTypeId = "{\"turtlesSet2\":[{\"age\":100,\"size\":10 },{\"age\":200,\"size\":20 }]}";
        ComposeTurtles composedTurtleDeserialized = (ComposeTurtles)FlatteningSerializerTests.deserialize(serializedCollectionWithTypeId, ComposeTurtles.class);
        Assertions.assertNotNull((Object)composedTurtleDeserialized);
        Assertions.assertNotNull(composedTurtleDeserialized.turtlesSet2());
        Assertions.assertEquals((int)2, (int)composedTurtleDeserialized.turtlesSet2().size());
        Assertions.assertFalse((boolean)(composedTurtleDeserialized.turtlesSet2().get(0) instanceof TurtleWithTypeIdContainingDot));
        Assertions.assertFalse((boolean)(composedTurtleDeserialized.turtlesSet2().get(1) instanceof TurtleWithTypeIdContainingDot));
        FlatteningSerializerTests.serialize(composedTurtleDeserialized);
        String serializedScalarWithTypeId = "{\"turtlesSet2Lead\":{\"age\":100,\"size\":10 }}";
        composedTurtleDeserialized = (ComposeTurtles)FlatteningSerializerTests.deserialize(serializedScalarWithTypeId, ComposeTurtles.class);
        Assertions.assertNotNull((Object)composedTurtleDeserialized);
        Assertions.assertNotNull((Object)composedTurtleDeserialized.turtlesSet2Lead());
        FlatteningSerializerTests.serialize(composedTurtleDeserialized);
    }

    @Test
    public void canHandleComposedGenericPolymorphicTypeWithAndWithoutTypeId() {
        String serializedCollectionWithTypeId = "{\"turtlesSet2\":[{\"age\":100,\"size\":10,\"@odata.type\":\"#Favourite.Pet.TurtleWithTypeIdContainingDot\"},{\"age\":200,\"size\":20 }]}";
        ComposeTurtles composedTurtleDeserialized = (ComposeTurtles)FlatteningSerializerTests.deserialize(serializedCollectionWithTypeId, ComposeTurtles.class);
        Assertions.assertNotNull((Object)composedTurtleDeserialized);
        Assertions.assertNotNull(composedTurtleDeserialized.turtlesSet2());
        Assertions.assertEquals((int)2, (int)composedTurtleDeserialized.turtlesSet2().size());
        Assertions.assertTrue((boolean)(composedTurtleDeserialized.turtlesSet2().get(0) instanceof TurtleWithTypeIdContainingDot));
        Assertions.assertNotNull((Object)composedTurtleDeserialized.turtlesSet2().get(1));
        FlatteningSerializerTests.serialize(composedTurtleDeserialized);
    }

    @Test
    public void canHandleEscapedProperties() {
        FlattenedProduct productToSerialize = new FlattenedProduct().setProductName("drink").setProductType("chai");
        String serialized = FlatteningSerializerTests.serialize(productToSerialize);
        String[] results = new String[]{"{\"properties\":{\"p.name\":\"drink\",\"type\":\"chai\"}}", "{\"properties\":{\"type\":\"chai\",\"p.name\":\"drink\"}}"};
        Assertions.assertTrue((boolean)Arrays.asList(results).contains(serialized));
        FlattenedProduct productDeserialized = (FlattenedProduct)FlatteningSerializerTests.deserialize(serialized, FlattenedProduct.class);
        Assertions.assertNotNull((Object)productDeserialized);
        Assertions.assertEquals((Object)productDeserialized.getProductName(), (Object)"drink");
        Assertions.assertEquals((Object)productDeserialized.getProductType(), (Object)"chai");
    }

    @Test
    public void canHandleSinglePropertyBeingFlattened() {
        ClassWithFlattenedProperties classWithFlattenedProperties = new ClassWithFlattenedProperties("random", "E24JJxztP");
        String serialized = FlatteningSerializerTests.serialize(classWithFlattenedProperties);
        String[] results = new String[]{"{\"@odata\":{\"type\":\"random\"},\"@odata.etag\":\"E24JJxztP\"}", "{\"@odata.etag\":\"E24JJxztP\",\"@odata\":{\"type\":\"random\"}}"};
        Assertions.assertTrue((boolean)Arrays.asList(results).contains(serialized));
        ClassWithFlattenedProperties deserialized = (ClassWithFlattenedProperties)FlatteningSerializerTests.deserialize(serialized, ClassWithFlattenedProperties.class);
        Assertions.assertNotNull((Object)deserialized);
        Assertions.assertEquals((Object)classWithFlattenedProperties.getOdataType(), (Object)deserialized.getOdataType());
        Assertions.assertEquals((Object)classWithFlattenedProperties.getOdataETag(), (Object)deserialized.getOdataETag());
    }

    @Test
    public void canHandleMultiLevelPropertyFlattening() {
        VirtualMachineScaleSet virtualMachineScaleSet = new VirtualMachineScaleSet().setVirtualMachineProfile(new VirtualMachineScaleSetVMProfile().setNetworkProfile(new VirtualMachineScaleSetNetworkProfile().setNetworkInterfaceConfigurations(Collections.singletonList(new VirtualMachineScaleSetNetworkConfiguration().setName("name").setPrimary(true)))));
        String serialized = FlatteningSerializerTests.serialize(virtualMachineScaleSet);
        String expected = "{\"properties\":{\"virtualMachineProfile\":{\"networkProfile\":{\"networkInterfaceConfigurations\":[{\"name\":\"name\",\"properties\":{\"primary\":true}}]}}}}";
        Assertions.assertEquals((Object)expected, (Object)serialized);
        VirtualMachineScaleSet deserialized = (VirtualMachineScaleSet)FlatteningSerializerTests.deserialize(serialized, VirtualMachineScaleSet.class);
        Assertions.assertNotNull((Object)deserialized);
        VirtualMachineScaleSetNetworkConfiguration expectedConfig = virtualMachineScaleSet.getVirtualMachineProfile().getNetworkProfile().getNetworkInterfaceConfigurations().get(0);
        VirtualMachineScaleSetNetworkConfiguration actualConfig = deserialized.getVirtualMachineProfile().getNetworkProfile().getNetworkInterfaceConfigurations().get(0);
        Assertions.assertEquals((Object)expectedConfig.getName(), (Object)actualConfig.getName());
        Assertions.assertEquals((Object)expectedConfig.getPrimary(), (Object)actualConfig.getPrimary());
    }

    @Test
    public void jsonFlattenOnArrayType() {
        JsonFlattenOnArrayType expected = new JsonFlattenOnArrayType().setJsonFlattenArray(new String[]{"hello", "goodbye", null});
        String expectedSerialization = "{\"jsonflatten\":{\"array\":[\"hello\",\"goodbye\",null]}}";
        String actualSerialization = FlatteningSerializerTests.serialize(expected);
        Assertions.assertEquals((Object)expectedSerialization, (Object)actualSerialization);
        JsonFlattenOnArrayType deserialized = (JsonFlattenOnArrayType)FlatteningSerializerTests.deserialize(actualSerialization, JsonFlattenOnArrayType.class);
        Assertions.assertArrayEquals((Object[])expected.getJsonFlattenArray(), (Object[])deserialized.getJsonFlattenArray());
    }

    @Test
    public void jsonFlattenOnCollectionTypeList() {
        List<String> listCollection = Arrays.asList("hello", "goodbye", null);
        JsonFlattenOnCollectionType expected = new JsonFlattenOnCollectionType().setJsonFlattenCollection(Collections.unmodifiableList(listCollection));
        String expectedSerialization = "{\"jsonflatten\":{\"collection\":[\"hello\",\"goodbye\",null]}}";
        String actualSerialization = FlatteningSerializerTests.serialize(expected);
        Assertions.assertEquals((Object)expectedSerialization, (Object)actualSerialization);
        JsonFlattenOnCollectionType deserialized = (JsonFlattenOnCollectionType)FlatteningSerializerTests.deserialize(actualSerialization, JsonFlattenOnCollectionType.class);
        Assertions.assertEquals((int)expected.getJsonFlattenCollection().size(), (int)deserialized.getJsonFlattenCollection().size());
        for (int i = 0; i < expected.getJsonFlattenCollection().size(); ++i) {
            Assertions.assertEquals((Object)expected.getJsonFlattenCollection().get(i), (Object)deserialized.getJsonFlattenCollection().get(i));
        }
    }

    @Test
    public void jsonFlattenOnJsonIgnoredProperty() {
        JsonFlattenOnJsonIgnoredProperty expected = new JsonFlattenOnJsonIgnoredProperty().setName("name").setIgnored("ignored");
        String expectedSerialization = "{\"name\":\"name\"}";
        String actualSerialization = FlatteningSerializerTests.serialize(expected);
        Assertions.assertEquals((Object)expectedSerialization, (Object)actualSerialization);
        JsonFlattenOnJsonIgnoredProperty deserialized = (JsonFlattenOnJsonIgnoredProperty)FlatteningSerializerTests.deserialize(actualSerialization, JsonFlattenOnJsonIgnoredProperty.class);
        Assertions.assertEquals((Object)expected.getName(), (Object)deserialized.getName());
        Assertions.assertNull((Object)deserialized.getIgnored());
    }

    @Test
    public void jsonFlattenOnPrimitiveType() {
        JsonFlattenOnPrimitiveType expected = new JsonFlattenOnPrimitiveType().setJsonFlattenBoolean(true).setJsonFlattenDecimal(1.25).setJsonFlattenNumber(2).setJsonFlattenString("string");
        String expectedSerialization = "{\"jsonflatten\":{\"boolean\":true,\"decimal\":1.25,\"number\":2,\"string\":\"string\"}}";
        String actualSerialization = FlatteningSerializerTests.serialize(expected);
        Assertions.assertEquals((Object)expectedSerialization, (Object)actualSerialization);
        JsonFlattenOnPrimitiveType deserialized = (JsonFlattenOnPrimitiveType)FlatteningSerializerTests.deserialize(actualSerialization, JsonFlattenOnPrimitiveType.class);
        Assertions.assertEquals((Object)expected.isJsonFlattenBoolean(), (Object)deserialized.isJsonFlattenBoolean());
        Assertions.assertEquals((double)expected.getJsonFlattenDecimal(), (double)deserialized.getJsonFlattenDecimal());
        Assertions.assertEquals((int)expected.getJsonFlattenNumber(), (int)deserialized.getJsonFlattenNumber());
        Assertions.assertEquals((Object)expected.getJsonFlattenString(), (Object)deserialized.getJsonFlattenString());
    }

    @Test
    public void jsonFlattenWithJsonInfoDiscriminator() {
        JsonFlattenWithJsonInfoDiscriminator expected = new JsonFlattenWithJsonInfoDiscriminator().setJsonFlattenDiscriminator("discriminator");
        String expectedSerialization = "{\"type\":\"JsonFlattenWithJsonInfoDiscriminator\",\"jsonflatten\":{\"discriminator\":\"discriminator\"}}";
        String actualSerialization = FlatteningSerializerTests.serialize(expected);
        Assertions.assertEquals((Object)expectedSerialization, (Object)actualSerialization);
        JsonFlattenWithJsonInfoDiscriminator deserialized = (JsonFlattenWithJsonInfoDiscriminator)FlatteningSerializerTests.deserialize(actualSerialization, JsonFlattenWithJsonInfoDiscriminator.class);
        Assertions.assertEquals((Object)expected.getJsonFlattenDiscriminator(), (Object)deserialized.getJsonFlattenDiscriminator());
    }

    @Test
    public void flattenedPropertiesAndJsonAnyGetter() {
        FlattenedPropertiesAndJsonAnyGetter expected = new FlattenedPropertiesAndJsonAnyGetter().setString("string").addAdditionalProperty("key1", "value1").addAdditionalProperty("key2", "value2");
        String expectedSerialization = "{\"flattened\":{\"string\":\"string\"},\"key1\":\"value1\",\"key2\":\"value2\"}";
        String actualSerialization = FlatteningSerializerTests.serialize(expected);
        Assertions.assertEquals((Object)expectedSerialization, (Object)actualSerialization);
        FlattenedPropertiesAndJsonAnyGetter deserialized = (FlattenedPropertiesAndJsonAnyGetter)FlatteningSerializerTests.deserialize(actualSerialization, FlattenedPropertiesAndJsonAnyGetter.class);
        Assertions.assertEquals((Object)expected.getString(), (Object)deserialized.getString());
        Assertions.assertEquals((int)expected.additionalProperties().size(), (int)deserialized.additionalProperties().size());
        for (String key : expected.additionalProperties().keySet()) {
            Assertions.assertEquals((Object)expected.additionalProperties().get(key), (Object)deserialized.additionalProperties().get(key));
        }
    }

    @Test
    public void jsonFlattenFinalMap() {
        HashMap<String, String> mapProperties = new HashMap<String, String>(){
            {
                this.put("/subscriptions/0-0-0-0-0/resourcegroups/0/providers/Microsoft.ManagedIdentity/0", "value");
            }
        };
        School school = new School().setTags((Map<String, String>)mapProperties);
        String actualSerialization = FlatteningSerializerTests.serialize(school);
        String expectedSerialization = "{\"tags\":{\"/subscriptions/0-0-0-0-0/resourcegroups/0/providers/Microsoft.ManagedIdentity/0\":\"value\"}}";
        Assertions.assertEquals((Object)expectedSerialization, (Object)actualSerialization);
    }

    @Test
    public void jsonFlattenNestedInner() {
        JsonFlattenNestedInner expected = new JsonFlattenNestedInner();
        VirtualMachineIdentity identity = new VirtualMachineIdentity();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("/subscriptions/0-0-0-0-0/resourcegroups/0/providers/Microsoft.ManagedIdentity/userAssignedIdentities/0", new Object());
        identity.setType(Arrays.asList("SystemAssigned, UserAssigned"));
        identity.setUserAssignedIdentities(map);
        expected.setIdentity(identity);
        String expectedSerialization = "{\"identity\":{\"type\":[\"SystemAssigned, UserAssigned\"],\"userAssignedIdentities\":{\"/subscriptions/0-0-0-0-0/resourcegroups/0/providers/Microsoft.ManagedIdentity/userAssignedIdentities/0\":{}}}}";
        String actualSerialization = FlatteningSerializerTests.serialize(expected);
        Assertions.assertEquals((Object)expectedSerialization, (Object)actualSerialization);
    }

    private static String serialize(Object object) {
        try {
            return ADAPTER.serialize(object, SerializerEncoding.JSON);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static <T> T deserialize(String json, Type type) {
        try {
            return (T)ADAPTER.deserialize(json, type, SerializerEncoding.JSON);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private School prepareSchoolModel() {
        Teacher teacher = new Teacher();
        HashMap<String, Student> students = new HashMap<String, Student>();
        students.put("af.B/C", new Student());
        students.put("af.B/D", new Student());
        teacher.setStudents(students);
        School school = new School().setName("school1");
        school.setTeacher(teacher);
        HashMap<String, String> schoolTags = new HashMap<String, String>();
        schoolTags.put("foo.aa", "bar");
        schoolTags.put("x.y", "zz");
        school.setTags(schoolTags);
        return school;
    }
}

