/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.models.GeoBoundingBox;
import com.azure.core.models.GeoCollection;
import com.azure.core.models.GeoLineString;
import com.azure.core.models.GeoLineStringCollection;
import com.azure.core.models.GeoLinearRing;
import com.azure.core.models.GeoObject;
import com.azure.core.models.GeoObjectType;
import com.azure.core.models.GeoPoint;
import com.azure.core.models.GeoPointCollection;
import com.azure.core.models.GeoPolygon;
import com.azure.core.models.GeoPolygonCollection;
import com.azure.core.models.GeoPosition;
import com.azure.core.util.serializer.GeoSerializationTestHelpers;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class GeoJsonSerializerTests {
    private static final JacksonAdapter ADAPTER = new JacksonAdapter();

    @Test
    public void unknownGeoTypeThrows() {
        Assertions.assertThrows(IOException.class, () -> ADAPTER.serialize((Object)new CustomGeoObject(null, null), SerializerEncoding.JSON));
    }

    @ParameterizedTest
    @MethodSource(value={"serializeSupplier"})
    public <T extends GeoObject> void serialize(T geo, String expectedJson) throws IOException {
        String actualJson = ADAPTER.serialize(geo, SerializerEncoding.JSON);
        Assertions.assertEquals((Object)expectedJson, (Object)actualJson);
    }

    private static Stream<Arguments> serializeSupplier() {
        GeoBoundingBox boundingBox = new GeoBoundingBox(0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        Map<String, Object> simpleProperties = Collections.singletonMap("key", "value");
        Map<String, Object> arrayProperties = Collections.singletonMap("text", Arrays.asList("hello", "world"));
        HashMap<String, Object> crs = new HashMap<String, Object>();
        crs.put("type", "name");
        crs.put("properties", Collections.singletonMap("name", "EPSG:432"));
        Map<String, Object> objectProperties = Collections.singletonMap("crs", crs);
        BiFunction<GeoBoundingBox, Map, GeoPoint> pointSupplier = (box, properties) -> new GeoPoint(new GeoPosition(0.0, 0.0, Double.valueOf(0.0)), box, properties);
        List<GeoPosition> positions = Arrays.asList(new GeoPosition(0.0, 0.0, Double.valueOf(1.0)), new GeoPosition(1.0, 1.0, Double.valueOf(1.0)));
        BiFunction<GeoBoundingBox, Map, GeoLineString> lineSupplier = (box, properties) -> new GeoLineString(positions, box, properties);
        List<GeoLinearRing> rings = Collections.singletonList(new GeoLinearRing(Arrays.asList(new GeoPosition(0.0, 0.0, Double.valueOf(1.0)), new GeoPosition(0.0, 1.0, Double.valueOf(1.0)), new GeoPosition(1.0, 1.0, Double.valueOf(1.0)), new GeoPosition(0.0, 0.0, Double.valueOf(1.0)))));
        BiFunction<GeoBoundingBox, Map, GeoPolygon> polygonSupplier = (box, properties) -> new GeoPolygon(rings, box, properties);
        BiFunction<GeoBoundingBox, Map, GeoPointCollection> multiPointSupplier = (box, properties) -> new GeoPointCollection(Arrays.asList((GeoPoint)pointSupplier.apply(null, null), (GeoPoint)pointSupplier.apply((GeoBoundingBox)box, (Map)properties)), box, properties);
        BiFunction<GeoBoundingBox, Map, GeoLineStringCollection> multiLineSupplier = (box, properties) -> new GeoLineStringCollection(Arrays.asList((GeoLineString)lineSupplier.apply(null, null), (GeoLineString)lineSupplier.apply((GeoBoundingBox)box, (Map)properties)), box, properties);
        BiFunction<GeoBoundingBox, Map, GeoPolygonCollection> multiPolygonSuppluer = (box, properties) -> new GeoPolygonCollection(Arrays.asList((GeoPolygon)polygonSupplier.apply(null, null), (GeoPolygon)polygonSupplier.apply((GeoBoundingBox)box, (Map)properties)), box, properties);
        BiFunction<GeoBoundingBox, Map, GeoCollection> collectionSupplier = (box, properties) -> new GeoCollection(Arrays.asList((GeoObject)pointSupplier.apply(null, null), (GeoObject)multiPointSupplier.apply((GeoBoundingBox)box, (Map)properties)), box, properties);
        return Stream.of(Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(null, null, pointSupplier)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(boundingBox, simpleProperties, pointSupplier)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(boundingBox, arrayProperties, pointSupplier)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(boundingBox, objectProperties, pointSupplier)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(null, null, lineSupplier)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(boundingBox, simpleProperties, lineSupplier)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(boundingBox, arrayProperties, lineSupplier)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(boundingBox, objectProperties, lineSupplier)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(null, null, polygonSupplier)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(boundingBox, simpleProperties, polygonSupplier)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(boundingBox, arrayProperties, polygonSupplier)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(boundingBox, objectProperties, polygonSupplier)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(null, null, multiPointSupplier)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(boundingBox, simpleProperties, multiPointSupplier)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(boundingBox, arrayProperties, multiPointSupplier)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(boundingBox, objectProperties, multiPointSupplier)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(null, null, multiLineSupplier)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(boundingBox, simpleProperties, multiLineSupplier)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(boundingBox, arrayProperties, multiLineSupplier)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(boundingBox, objectProperties, multiLineSupplier)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(null, null, multiPolygonSuppluer)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(boundingBox, simpleProperties, multiPolygonSuppluer)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(boundingBox, arrayProperties, multiPolygonSuppluer)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(boundingBox, objectProperties, multiPolygonSuppluer)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(null, null, collectionSupplier)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(boundingBox, simpleProperties, collectionSupplier)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(boundingBox, arrayProperties, collectionSupplier)), Arguments.of((Object[])GeoJsonSerializerTests.serializerArgumentSupplier(boundingBox, objectProperties, collectionSupplier)));
    }

    private static Object[] serializerArgumentSupplier(GeoBoundingBox boundingBox, Map<String, Object> properties, BiFunction<GeoBoundingBox, Map<String, Object>, ? extends GeoObject> geoSupplier) {
        GeoObject geoObject = geoSupplier.apply(boundingBox, properties);
        return new Object[]{geoObject, GeoSerializationTestHelpers.geoToJson(geoObject)};
    }

    private static final class CustomGeoObject
    extends GeoObject {
        protected CustomGeoObject(GeoBoundingBox boundingBox, Map<String, Object> properties) {
            super(boundingBox, properties);
        }

        public GeoObjectType getType() {
            return null;
        }
    }
}

