/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.Main;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.RunnerException;

@Fork(value=3)
@Warmup(iterations=5, time=2)
@Measurement(iterations=5, time=10)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Thread)
public class SerializationBenchmark {
    private JacksonAdapter serializer;
    private ObjectMapper mapper;
    private OuterModel simpleModel;
    private OuterModel additionalPropertiesModel;
    private OuterModel jsonAnyModel;
    private OuterModelFlatten flattenModel;

    @Setup
    public void setup() {
        this.serializer = new JacksonAdapter();
        this.mapper = new ObjectMapper();
        this.simpleModel = new OuterModel("foo", "bar", "baz", Test.PLAIN);
        this.additionalPropertiesModel = new OuterModel("foo", "bar", "baz", Test.ADDITIONAL_PROPERTIES);
        this.jsonAnyModel = new OuterModel("foo", "bar", "baz", Test.JSON_ANY);
        this.flattenModel = new OuterModelFlatten("foo", "bar", "baz");
    }

    @Benchmark
    public void simpleModelObjectMapperSerializeJson(Blackhole blackhole) throws IOException {
        blackhole.consume((Object)this.mapper.writeValueAsString((Object)this.simpleModel));
    }

    @Benchmark
    public void simpleModelJacksonAdapterSerializeJson(Blackhole blackhole) throws IOException {
        blackhole.consume((Object)this.serializer.serialize((Object)this.simpleModel, SerializerEncoding.JSON));
    }

    @Benchmark
    public void additionalPropertiesJacksonAdapterSerializeJson(Blackhole blackhole) throws IOException {
        blackhole.consume((Object)this.serializer.serialize((Object)this.additionalPropertiesModel, SerializerEncoding.JSON));
    }

    @Benchmark
    public void flattenJacksonAdapterSerializeJson(Blackhole blackhole) throws IOException {
        blackhole.consume((Object)this.serializer.serialize((Object)this.flattenModel, SerializerEncoding.JSON));
    }

    @Benchmark
    public void jsonAnyJacksonAdapterSerializeJson(Blackhole blackhole) throws IOException {
        blackhole.consume((Object)this.serializer.serialize((Object)this.jsonAnyModel, SerializerEncoding.JSON));
    }

    @Benchmark
    public void simpleModelJacksonAdapterSerializeXml(Blackhole blackhole) throws IOException {
        blackhole.consume((Object)this.serializer.serialize((Object)this.simpleModel, SerializerEncoding.XML));
    }

    public static void main(String ... args) throws IOException, RunnerException {
        Main.main((String[])args);
    }

    @JsonFlatten
    class OuterModelFlatten {
        @JsonProperty(value="middle.inner.foo")
        private String foo;
        @JsonProperty(value="middle.inner.bar")
        private String bar;
        @JsonProperty(value="middle.inner.baz")
        private String baz;

        OuterModelFlatten(String foo, String bar, String baz) {
            this.foo = foo;
            this.bar = bar;
            this.baz = baz;
        }
    }

    class OuterModel {
        @JsonProperty
        private MiddleModel middle;

        OuterModel(String foo, String bar, String baz, Test test) {
            this.middle = new MiddleModel(foo, bar, baz, test);
        }
    }

    class MiddleModel {
        @JsonProperty
        private Object inner;

        MiddleModel(String foo, String bar, String baz, Test test) {
            if (test == Test.PLAIN) {
                this.inner = new InnerModel(foo, bar, baz);
            } else if (test == Test.ADDITIONAL_PROPERTIES) {
                this.inner = new InnerModelAdditionalProperties(foo, bar, baz);
            } else if (test == Test.JSON_ANY) {
                this.inner = new InnerModelJsonAny(foo, bar, baz);
            }
        }
    }

    class InnerModelJsonAny {
        @JsonAnyGetter
        @JsonAnySetter
        private Map<String, String> any = new HashMap<String, String>();

        InnerModelJsonAny(String foo, String bar, String baz) {
            this.any.put("foo", foo);
            this.any.put("bar", bar);
            this.any.put("baz", baz);
        }
    }

    class InnerModelAdditionalProperties {
        @JsonProperty
        private Map<String, String> additionalProperties = new HashMap<String, String>();

        InnerModelAdditionalProperties(String foo, String bar, String baz) {
            this.additionalProperties.put("foo", foo);
            this.additionalProperties.put("bar", bar);
            this.additionalProperties.put("baz", baz);
        }
    }

    class InnerModel {
        @JsonProperty
        private String foo;
        @JsonProperty
        private String bar;
        @JsonProperty
        private String baz;

        InnerModel(String foo, String bar, String baz) {
            this.foo = foo;
            this.bar = bar;
            this.baz = baz;
        }
    }

    static enum Test {
        PLAIN,
        ADDITIONAL_PROPERTIES,
        JSON_ANY;

    }
}

