/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.util.logging.ClientLogger;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public final class ReflectionUtils {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final String MODULE_CLASS = "java.lang.Module";
    private static final Object CORE_MODULE;
    private static final MethodHandle GET_MODULE;
    private static final MethodHandle IS_MODULE_EXPORTED;
    private static final MethodHandle CAN_READ_MODULE;
    private static final MethodHandle ADD_MODULE_READ;

    public static MethodHandles.Lookup getLookupToUse(Class<?> targetClass) throws Throwable {
        if (GET_MODULE == null) {
            return MethodHandles.publicLookup();
        }
        Object responseModule = GET_MODULE.invoke(targetClass);
        if (IS_MODULE_EXPORTED.invoke(responseModule, "")) {
            return MethodHandles.publicLookup();
        }
        if (!CAN_READ_MODULE.invoke(CORE_MODULE, responseModule)) {
            ADD_MODULE_READ.invoke(CORE_MODULE, responseModule);
        }
        return LOOKUP;
    }

    private ReflectionUtils() {
    }

    static {
        MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
        Object coreModule = null;
        MethodHandle getModule = null;
        MethodHandle isModuleExported = null;
        MethodHandle canReadModule = null;
        MethodHandle addReadModule = null;
        try {
            Class<?> moduleClass = Class.forName(MODULE_CLASS);
            Class<Class> classClass = Class.class;
            getModule = publicLookup.findVirtual(classClass, "getModule", MethodType.methodType(moduleClass));
            coreModule = getModule.invoke(ReflectionUtils.class);
            isModuleExported = publicLookup.findVirtual(moduleClass, "isExported", MethodType.methodType(Boolean.TYPE, String.class));
            canReadModule = publicLookup.findVirtual(moduleClass, "canRead", MethodType.methodType(Boolean.TYPE, moduleClass));
            addReadModule = MethodHandles.lookup().findVirtual(moduleClass, "addReads", MethodType.methodType(moduleClass, moduleClass));
        }
        catch (Throwable ex) {
            new ClientLogger(ReflectionUtils.class).verbose("Failed to retrieve MethodHandles used to check module information. If the application is not using Java 9+ runtime behavior will work as expected.", ex);
        }
        CORE_MODULE = coreModule;
        GET_MODULE = getModule;
        IS_MODULE_EXPORTED = isModuleExported;
        CAN_READ_MODULE = canReadModule;
        ADD_MODULE_READ = addReadModule;
    }
}

