/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.implementation;

import com.azure.core.util.FluxUtil;
import com.azure.core.util.implementation.BinaryDataContent;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Flux;

public final class FluxByteBufferContent
extends BinaryDataContent {
    private final Flux<ByteBuffer> content;
    private final AtomicReference<byte[]> bytes = new AtomicReference();
    private final Long length;

    public FluxByteBufferContent(Flux<ByteBuffer> content) {
        this(content, null);
    }

    public FluxByteBufferContent(Flux<ByteBuffer> content, Long length) {
        this.content = Objects.requireNonNull(content, "'content' cannot be null.");
        this.length = length;
    }

    @Override
    public Long getLength() {
        return this.length;
    }

    @Override
    public String toString() {
        return new String(this.toBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toBytes() {
        byte[] data = this.bytes.get();
        if (data == null) {
            this.bytes.set(this.getBytes());
            data = this.bytes.get();
        }
        return data;
    }

    @Override
    public <T> T toObject(TypeReference<T> typeReference, ObjectSerializer serializer) {
        return serializer.deserializeFromBytes(this.toBytes(), typeReference);
    }

    @Override
    public InputStream toStream() {
        return new ByteArrayInputStream(this.toBytes());
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.toBytes()).asReadOnlyBuffer();
    }

    @Override
    public Flux<ByteBuffer> toFluxByteBuffer() {
        return this.content;
    }

    private byte[] getBytes() {
        return (byte[])FluxUtil.collectBytesInByteBufferStream(this.content).share().block();
    }
}

