/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.credential;

import com.azure.core.credential.AzureSasCredential;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class AzureSasCredentialTests {
    @ParameterizedTest
    @MethodSource(value={"invalidConstructorParametersSupplier"})
    public void invalidConstructorParameters(String signature, Class<? extends Throwable> expectedException) {
        Assertions.assertThrows(expectedException, () -> new AzureSasCredential(signature));
        Assertions.assertThrows(expectedException, () -> new AzureSasCredential(signature, String::toString));
    }

    private static Stream<Arguments> invalidConstructorParametersSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, NullPointerException.class}), Arguments.of((Object[])new Object[]{"", IllegalArgumentException.class}));
    }

    @Test
    public void baseConstructorReturnsSignatureAsIs() {
        String signature = "sas=a bc";
        AzureSasCredential credential = new AzureSasCredential("sas=a bc");
        Assertions.assertEquals((Object)"sas=a bc", (Object)credential.getSignature());
    }

    @Test
    public void constructorWithoutEncodingFunctionReturnsSignatureAsIs() {
        String signature = "sas=a bc";
        AzureSasCredential credential = new AzureSasCredential("sas=a bc", null);
        Assertions.assertEquals((Object)"sas=a bc", (Object)credential.getSignature());
    }

    @Test
    public void constructorEncodesSignature() {
        String signature = "sas=a bc";
        String expectedSignature = "sas=a%20bc";
        AzureSasCredential credential = new AzureSasCredential("sas=a bc", sig -> sig.replaceAll(" ", "%20"));
        Assertions.assertEquals((Object)"sas=a%20bc", (Object)credential.getSignature());
    }

    @Test
    public void credentialWithoutEncodingFunctionDoesNotEncodeUpdates() {
        String signature = "sas=a bc";
        String updatedSignature = "sas=a b c";
        AzureSasCredential credential = new AzureSasCredential("sas=a bc").update("sas=a b c");
        Assertions.assertEquals((Object)"sas=a b c", (Object)credential.getSignature());
    }

    @Test
    public void credentialWithEncodingFunctionEncodesSignatureUpdates() {
        String signature = "sas=a bc";
        String updatedSignature = "sas=a b c";
        String expectedSignature = "sas=a%20b%20c";
        AzureSasCredential credential = new AzureSasCredential("sas=a bc", sig -> sig.replaceAll(" ", "%20")).update("sas=a b c");
        Assertions.assertEquals((Object)"sas=a%20b%20c", (Object)credential.getSignature());
    }
}

