/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.credential;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.BasicAuthenticationCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.clients.NoOpHttpClient;
import com.azure.core.http.policy.AzureSasCredentialPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import java.net.URL;
import java.time.OffsetDateTime;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.provider.CsvSource;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public class CredentialsTests {
    private static final String DUMMY_NAME = "Dummy-Name";
    private static final String DUMMY_VALUE = "DummyValue";

    @Test
    public void basicCredentialsTest() throws Exception {
        BasicAuthenticationCredential credentials = new BasicAuthenticationCredential("user", "pass");
        HttpPipelinePolicy auditorPolicy = (context, next) -> {
            String headerValue = context.getHttpRequest().getHeaders().getValue("Authorization");
            Assertions.assertEquals((Object)"Basic dXNlcjpwYXNz", (Object)headerValue);
            return next.process();
        };
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new NoOpHttpClient()).policies(new HttpPipelinePolicy[]{(context, next) -> credentials.getToken(new TokenRequestContext().addScopes(new String[]{"scope./default"})).flatMap(token -> {
            context.getHttpRequest().getHeaders().set("Authorization", "Basic " + token.getToken());
            return next.process();
        }), auditorPolicy}).build();
        HttpRequest request = new HttpRequest(HttpMethod.GET, new URL("http://localhost"));
        pipeline.send(request).block();
    }

    @Test
    public void tokenCredentialTest() throws Exception {
        TokenCredential credentials = request -> Mono.just((Object)new AccessToken("this_is_a_token", OffsetDateTime.MAX));
        HttpPipelinePolicy auditorPolicy = (context, next) -> {
            String headerValue = context.getHttpRequest().getHeaders().getValue("Authorization");
            Assertions.assertEquals((Object)"Bearer this_is_a_token", (Object)headerValue);
            return next.process();
        };
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new NoOpHttpClient()).policies(new HttpPipelinePolicy[]{new BearerTokenAuthenticationPolicy(credentials, new String[]{"scope./default"}), auditorPolicy}).build();
        HttpRequest request2 = new HttpRequest(HttpMethod.GET, new URL("https://localhost"));
        pipeline.send(request2).block();
    }

    @Test
    public void tokenCredentialHttpSchemeTest() throws Exception {
        TokenCredential credentials = request -> Mono.just((Object)new AccessToken("this_is_a_token", OffsetDateTime.MAX));
        HttpPipelinePolicy auditorPolicy = (context, next) -> {
            String headerValue = context.getHttpRequest().getHeaders().getValue("Authorization");
            Assertions.assertEquals((Object)"Bearer this_is_a_token", (Object)headerValue);
            return next.process();
        };
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new NoOpHttpClient()).policies(new HttpPipelinePolicy[]{new BearerTokenAuthenticationPolicy(credentials, new String[]{"scope./default"}), auditorPolicy}).build();
        HttpRequest request2 = new HttpRequest(HttpMethod.GET, new URL("http://localhost"));
        StepVerifier.create((Publisher)pipeline.send(request2)).expectErrorMessage("token credentials require a URL using the HTTPS protocol scheme").verify();
    }

    @ParameterizedTest
    @CsvSource(value={"test_signature,https://localhost,https://localhost?test_signature", "?test_signature,https://localhost,https://localhost?test_signature", "test_signature,https://localhost?,https://localhost?test_signature", "?test_signature,https://localhost?,https://localhost?test_signature", "test_signature,https://localhost?foo=bar,https://localhost?foo=bar&test_signature", "?test_signature,https://localhost?foo=bar,https://localhost?foo=bar&test_signature"})
    public void sasCredentialsTest(String signature, String url, String expectedUrl) throws Exception {
        AzureSasCredential credential = new AzureSasCredential(signature);
        HttpPipelinePolicy auditorPolicy = (context, next) -> {
            String actualUrl = context.getHttpRequest().getUrl().toString();
            Assertions.assertEquals((Object)expectedUrl, (Object)actualUrl);
            return next.process();
        };
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new NoOpHttpClient()).policies(new HttpPipelinePolicy[]{new AzureSasCredentialPolicy(credential), auditorPolicy}).build();
        HttpRequest request = new HttpRequest(HttpMethod.GET, new URL(url));
        pipeline.send(request).block();
    }

    @Test
    public void sasCredentialsRequireHTTPSSchemeTest() throws Exception {
        AzureSasCredential credential = new AzureSasCredential("foo");
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new NoOpHttpClient()).policies(new HttpPipelinePolicy[]{new AzureSasCredentialPolicy(credential)}).build();
        HttpRequest request = new HttpRequest(HttpMethod.GET, new URL("http://localhost"));
        StepVerifier.create((Publisher)pipeline.send(request)).expectErrorMessage("Shared access signature credentials require HTTPS to prevent leaking the shared access signature.").verify();
    }

    @Test
    public void sasCredentialsDoNotRequireHTTPSchemeTest() throws Exception {
        AzureSasCredential credential = new AzureSasCredential("foo");
        HttpPipelinePolicy auditorPolicy = (context, next) -> {
            String actualUrl = context.getHttpRequest().getUrl().toString();
            Assertions.assertEquals((Object)"http://localhost?foo", (Object)actualUrl);
            return next.process();
        };
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new NoOpHttpClient()).policies(new HttpPipelinePolicy[]{new AzureSasCredentialPolicy(credential, false), auditorPolicy}).build();
        HttpRequest request = new HttpRequest(HttpMethod.GET, new URL("http://localhost"));
        pipeline.send(request).block();
    }

    @ParameterizedTest
    @ArgumentsSource(value=InvalidInputsArgumentProvider.class)
    public void namedKeyCredentialsInvalidArgumentTest(String name, String key, Class<Exception> excepionType) {
        Assertions.assertThrows(excepionType, () -> new AzureNamedKeyCredential(name, key));
    }

    @ParameterizedTest
    @ArgumentsSource(value=InvalidInputsArgumentProvider.class)
    public void namedKeyCredentialsInvalidArgumentUpdateTest(String name, String key, Class<Exception> excepionType) {
        AzureNamedKeyCredential azureNamedKeyCredential = new AzureNamedKeyCredential(DUMMY_NAME, DUMMY_VALUE);
        Assertions.assertThrows(excepionType, () -> azureNamedKeyCredential.update(name, key));
    }

    @Test
    public void namedKeyCredentialValueTest() {
        AzureNamedKeyCredential azureNamedKeyCredential = new AzureNamedKeyCredential(DUMMY_NAME, DUMMY_VALUE);
        Assertions.assertEquals((Object)DUMMY_NAME, (Object)azureNamedKeyCredential.getAzureNamedKey().getName());
        Assertions.assertEquals((Object)DUMMY_VALUE, (Object)azureNamedKeyCredential.getAzureNamedKey().getKey());
    }

    @Test
    public void namedKeyCredentialUpdateTest() {
        AzureNamedKeyCredential azureNamedKeyCredential = new AzureNamedKeyCredential(DUMMY_NAME, DUMMY_NAME);
        String expectedName = "New-Name";
        String expectedValue = "NewValue";
        azureNamedKeyCredential.update(expectedName, expectedValue);
        Assertions.assertEquals((Object)expectedName, (Object)azureNamedKeyCredential.getAzureNamedKey().getName());
        Assertions.assertEquals((Object)expectedValue, (Object)azureNamedKeyCredential.getAzureNamedKey().getKey());
    }

    static class InvalidInputsArgumentProvider
    implements ArgumentsProvider {
        InvalidInputsArgumentProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Stream.of(Arguments.of((Object[])new Object[]{null, null, NullPointerException.class}), Arguments.of((Object[])new Object[]{"", null, NullPointerException.class}), Arguments.of((Object[])new Object[]{null, "", NullPointerException.class}), Arguments.of((Object[])new Object[]{"", "", IllegalArgumentException.class}), Arguments.of((Object[])new Object[]{"DummyName", "", IllegalArgumentException.class}), Arguments.of((Object[])new Object[]{"", CredentialsTests.DUMMY_VALUE, IllegalArgumentException.class}));
        }
    }
}

