/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.credential;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.SimpleTokenCache;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.test.scheduler.VirtualTimeScheduler;

public class TokenCacheTests {
    private static final Random RANDOM = new Random();

    @Test
    public void testOnlyOneThreadRefreshesToken() throws Exception {
        AtomicLong refreshes = new AtomicLong(0L);
        SimpleTokenCache cache = new SimpleTokenCache(() -> {
            refreshes.incrementAndGet();
            return this.incrementalRemoteGetTokenAsync(new AtomicInteger(1));
        });
        CountDownLatch latch = new CountDownLatch(1);
        Flux.range((int)1, (int)10).flatMap(ignored -> Mono.just((Object)OffsetDateTime.now())).parallel(10).runOn(Schedulers.boundedElastic()).flatMap(start -> cache.getToken()).doOnComplete(latch::countDown).subscribe();
        latch.await();
        Assertions.assertEquals((long)1L, (long)refreshes.get());
    }

    @Test
    public void testLongRunningWontOverflow() throws Exception {
        AtomicLong refreshes = new AtomicLong(0L);
        SimpleTokenCache cache = new SimpleTokenCache(() -> {
            refreshes.incrementAndGet();
            return this.remoteGetTokenThatExpiresSoonAsync();
        });
        VirtualTimeScheduler virtualTimeScheduler = VirtualTimeScheduler.create();
        CountDownLatch latch = new CountDownLatch(1);
        Flux.interval((Duration)Duration.ofMillis(100L), (Scheduler)virtualTimeScheduler).take(100L).flatMap(i -> cache.getToken()).doOnComplete(latch::countDown).subscribe();
        virtualTimeScheduler.advanceTimeBy(Duration.ofSeconds(40L));
        latch.await();
        Assertions.assertTrue((refreshes.get() <= 11L ? 1 : 0) != 0);
    }

    private Mono<AccessToken> remoteGetTokenThatExpiresSoonAsync() {
        return Mono.delay((Duration)Duration.ofMillis(1000L)).map(l -> new Token(Integer.toString(RANDOM.nextInt(100)), 0L));
    }

    private Mono<AccessToken> incrementalRemoteGetTokenAsync(AtomicInteger latency) {
        return Mono.delay((Duration)Duration.ofSeconds(latency.getAndIncrement())).map(l -> new Token(Integer.toString(RANDOM.nextInt(100))));
    }

    private static class Token
    extends AccessToken {
        Token(String token) {
            this(token, 5000L);
        }

        Token(String token, long validityInMillis) {
            super(token, OffsetDateTime.now().plus(Duration.ofMillis(validityInMillis)));
        }
    }
}

