/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import com.azure.core.http.HttpAuthorization;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class HttpAuthorizationTests {
    @ParameterizedTest
    @MethodSource(value={"invalidConstructorParametersSupplier"})
    public void invalidConstructorParameters(String scheme, String parameter, Class<? extends Throwable> expectedException) {
        Assertions.assertThrows(expectedException, () -> new HttpAuthorization(scheme, parameter));
    }

    private static Stream<Arguments> invalidConstructorParametersSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, "parameter", NullPointerException.class}), Arguments.of((Object[])new Object[]{"scheme", null, NullPointerException.class}), Arguments.of((Object[])new Object[]{"", "parameter", IllegalArgumentException.class}), Arguments.of((Object[])new Object[]{"scheme", "", IllegalArgumentException.class}));
    }

    @Test
    public void toStringTest() {
        String scheme = "scheme";
        String parameter = "parameter";
        HttpAuthorization httpAuthorization = new HttpAuthorization(scheme, parameter);
        Assertions.assertEquals((Object)String.format("%s %s", scheme, parameter), (Object)httpAuthorization.toString());
    }
}

