/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import com.azure.core.http.HttpHeaders;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HttpHeadersTests {
    @Test
    public void testSet() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("a", "b");
        Assertions.assertEquals((Object)"b", (Object)headers.getValue("a"));
        headers.set("a", "c");
        Assertions.assertEquals((Object)"c", (Object)headers.getValue("a"));
        headers.set("a", (String)null);
        Assertions.assertNull((Object)headers.getValue("a"));
        headers.set("A", "");
        Assertions.assertEquals((Object)"", (Object)headers.getValue("a"));
        headers.set("A", "b");
        Assertions.assertEquals((Object)"b", (Object)headers.getValue("A"));
        headers.set("a", (String)null);
        Assertions.assertNull((Object)headers.getValue("a"));
    }

    @Test
    public void testToStringShouldBeRepresentingKeyEqualsignValue() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("key1", "value1");
        headers.set("key2", "value2");
        headers.set("key3", "value3");
        Assertions.assertEquals((Object)"key1=value1, key2=value2, key3=value3", (Object)headers.toString());
    }
}

