/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import com.azure.core.http.HttpRange;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class HttpRangeTests {
    @ParameterizedTest
    @MethodSource(value={"equalsTestSupplier"})
    public void equalsTest(long offset, Long length, HttpRange expected) {
        Assertions.assertEquals((long)expected.getOffset(), (long)offset);
        Assertions.assertEquals((Long)expected.getLength(), (Long)length);
        Assertions.assertEquals((Object)expected, (Object)new HttpRange(offset, length));
    }

    private static Stream<Arguments> equalsTestSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{0, null, new HttpRange(0L)}), Arguments.of((Object[])new Object[]{0, null, new HttpRange(0L, null)}), Arguments.of((Object[])new Object[]{0, 10L, new HttpRange(0L, Long.valueOf(10L))}));
    }

    @ParameterizedTest
    @MethodSource(value={"toStringTestSupplier"})
    public void toStringTest(HttpRange range, String expected) {
        Assertions.assertEquals((Object)expected, (Object)range.toString());
    }

    private static Stream<Arguments> toStringTestSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{new HttpRange(0L), "bytes=0-"}), Arguments.of((Object[])new Object[]{new HttpRange(0L, null), "bytes=0-"}), Arguments.of((Object[])new Object[]{new HttpRange(0L, Long.valueOf(10L)), "bytes=0-9"}), Arguments.of((Object[])new Object[]{new HttpRange(10L, Long.valueOf(10L)), "bytes=10-19"}));
    }

    @ParameterizedTest
    @MethodSource(value={"invalidRangeSupplier"})
    public void invalidRange(long offset, Long length) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new HttpRange(offset, length));
    }

    private static Stream<Arguments> invalidRangeSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{-1, null}), Arguments.of((Object[])new Object[]{0, -1L}));
    }
}

