/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.util.Configuration;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class HttpLogDetailLevelTests {
    @ParameterizedTest
    @MethodSource(value={"fromConfigurationSupplier"})
    public void fromConfiguration(Configuration configuration, HttpLogDetailLevel expected) {
        Assertions.assertEquals((Object)expected, (Object)HttpLogDetailLevel.fromConfiguration((Configuration)configuration));
    }

    private static Stream<Arguments> fromConfigurationSupplier() {
        Configuration returnsNullMock = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)returnsNullMock.get("AZURE_HTTP_LOG_DETAIL_LEVEL")).thenReturn(null);
        return Stream.of(Arguments.of((Object[])new Object[]{returnsNullMock, HttpLogDetailLevel.NONE}), Arguments.of((Object[])new Object[]{HttpLogDetailLevelTests.makeConfiguration(""), HttpLogDetailLevel.NONE}), Arguments.of((Object[])new Object[]{HttpLogDetailLevelTests.makeConfiguration("unknown"), HttpLogDetailLevel.NONE}), Arguments.of((Object[])new Object[]{HttpLogDetailLevelTests.makeConfiguration("basic"), HttpLogDetailLevel.BASIC}), Arguments.of((Object[])new Object[]{HttpLogDetailLevelTests.makeConfiguration(HttpLogDetailLevel.BASIC.name()), HttpLogDetailLevel.BASIC}), Arguments.of((Object[])new Object[]{HttpLogDetailLevelTests.makeConfiguration("bAsIc"), HttpLogDetailLevel.BASIC}), Arguments.of((Object[])new Object[]{HttpLogDetailLevelTests.makeConfiguration("headers"), HttpLogDetailLevel.HEADERS}), Arguments.of((Object[])new Object[]{HttpLogDetailLevelTests.makeConfiguration(HttpLogDetailLevel.HEADERS.name()), HttpLogDetailLevel.HEADERS}), Arguments.of((Object[])new Object[]{HttpLogDetailLevelTests.makeConfiguration("hEaDeRs"), HttpLogDetailLevel.HEADERS}), Arguments.of((Object[])new Object[]{HttpLogDetailLevelTests.makeConfiguration("body"), HttpLogDetailLevel.BODY}), Arguments.of((Object[])new Object[]{HttpLogDetailLevelTests.makeConfiguration(HttpLogDetailLevel.BODY.name()), HttpLogDetailLevel.BODY}), Arguments.of((Object[])new Object[]{HttpLogDetailLevelTests.makeConfiguration("bOdY"), HttpLogDetailLevel.BODY}), Arguments.of((Object[])new Object[]{HttpLogDetailLevelTests.makeConfiguration("body_and_headers"), HttpLogDetailLevel.BODY_AND_HEADERS}), Arguments.of((Object[])new Object[]{HttpLogDetailLevelTests.makeConfiguration(HttpLogDetailLevel.BODY_AND_HEADERS.name()), HttpLogDetailLevel.BODY_AND_HEADERS}), Arguments.of((Object[])new Object[]{HttpLogDetailLevelTests.makeConfiguration("bOdY_aNd_HeAdErS"), HttpLogDetailLevel.BODY_AND_HEADERS}), Arguments.of((Object[])new Object[]{HttpLogDetailLevelTests.makeConfiguration("bodyandheaders"), HttpLogDetailLevel.BODY_AND_HEADERS}), Arguments.of((Object[])new Object[]{HttpLogDetailLevelTests.makeConfiguration("BODYANDHEADERS"), HttpLogDetailLevel.BODY_AND_HEADERS}), Arguments.of((Object[])new Object[]{HttpLogDetailLevelTests.makeConfiguration("bOdYaNdHeAdErS"), HttpLogDetailLevel.BODY_AND_HEADERS}));
    }

    private static Configuration makeConfiguration(String detailLevelValue) {
        return new Configuration().put("AZURE_HTTP_LOG_DETAIL_LEVEL", detailLevelValue);
    }
}

