/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.MockHttpResponse;
import com.azure.core.http.clients.NoOpHttpClient;
import com.azure.core.http.policy.DefaultRedirectStrategy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RedirectPolicy;
import com.azure.core.http.policy.RedirectStrategy;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Mono;

public class RedirectPolicyTest {
    @Test
    public void noRedirectPolicyTest() throws Exception {
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new NoOpHttpClient(){

            @Override
            public Mono<HttpResponse> send(HttpRequest request) {
                if (request.getUrl().toString().equals("http://localhost/")) {
                    HashMap<String, String> headers = new HashMap<String, String>();
                    headers.put("Location", "http://redirecthost/");
                    HttpHeaders httpHeader = new HttpHeaders(headers);
                    return Mono.just((Object)((Object)new MockHttpResponse(request, 308, httpHeader)));
                }
                return Mono.just((Object)((Object)new MockHttpResponse(request, 200)));
            }
        }).build();
        HttpResponse response = (HttpResponse)pipeline.send(new HttpRequest(HttpMethod.GET, new URL("http://localhost/"))).block();
        Assertions.assertEquals((int)308, (int)response.getStatusCode());
    }

    @Test
    public void defaultRedirectWhen308() throws Exception {
        RecordingHttpClient httpClient = new RecordingHttpClient(request -> {
            if (request.getUrl().toString().equals("http://localhost/")) {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Location", "http://redirecthost/");
                HttpHeaders httpHeader = new HttpHeaders(headers);
                return Mono.just((Object)((Object)new MockHttpResponse((HttpRequest)request, 308, httpHeader)));
            }
            return Mono.just((Object)((Object)new MockHttpResponse((HttpRequest)request, 200)));
        });
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)httpClient).policies(new HttpPipelinePolicy[]{new RedirectPolicy()}).build();
        HttpResponse response = (HttpResponse)pipeline.send(new HttpRequest(HttpMethod.GET, new URL("http://localhost/"))).block();
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
    }

    @Test
    public void redirectForNAttempts() throws MalformedURLException {
        int[] requestCount = new int[]{1};
        RecordingHttpClient httpClient = new RecordingHttpClient(request -> {
            HashMap<String, CallSite> headers = new HashMap<String, CallSite>();
            headers.put("Location", (CallSite)((Object)("http://redirecthost/" + requestCount[0])));
            HttpHeaders httpHeader = new HttpHeaders(headers);
            requestCount[0] = requestCount[0] + 1;
            return Mono.just((Object)((Object)new MockHttpResponse((HttpRequest)request, 308, httpHeader)));
        });
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)httpClient).policies(new HttpPipelinePolicy[]{new RedirectPolicy((RedirectStrategy)new DefaultRedirectStrategy(5))}).build();
        HttpResponse response = (HttpResponse)pipeline.send(new HttpRequest(HttpMethod.GET, new URL("http://localhost/"))).block();
        Assertions.assertEquals((int)5, (int)httpClient.getCount());
        Assertions.assertEquals((int)308, (int)response.getStatusCode());
    }

    @Test
    public void redirectNonAllowedMethodTest() throws Exception {
        RecordingHttpClient httpClient = new RecordingHttpClient(request -> {
            if (request.getUrl().toString().equals("http://localhost/")) {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Location", "http://redirecthost/");
                HttpHeaders httpHeader = new HttpHeaders(headers);
                return Mono.just((Object)((Object)new MockHttpResponse((HttpRequest)request, 308, httpHeader)));
            }
            return Mono.just((Object)((Object)new MockHttpResponse((HttpRequest)request, 200)));
        });
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)httpClient).policies(new HttpPipelinePolicy[]{new RedirectPolicy((RedirectStrategy)new DefaultRedirectStrategy(5))}).build();
        HttpResponse response = (HttpResponse)pipeline.send(new HttpRequest(HttpMethod.POST, new URL("http://localhost/"))).block();
        Assertions.assertEquals((int)1, (int)httpClient.getCount());
        Assertions.assertEquals((int)308, (int)response.getStatusCode());
    }

    @Test
    public void redirectAllowedStatusCodesTest() throws Exception {
        RecordingHttpClient httpClient = new RecordingHttpClient(request -> {
            if (request.getUrl().toString().equals("http://localhost/")) {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Location", "http://redirecthost/");
                HttpHeaders httpHeader = new HttpHeaders(headers);
                return Mono.just((Object)((Object)new MockHttpResponse((HttpRequest)request, 308, httpHeader)));
            }
            return Mono.just((Object)((Object)new MockHttpResponse((HttpRequest)request, 200)));
        });
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)httpClient).policies(new HttpPipelinePolicy[]{new RedirectPolicy((RedirectStrategy)new DefaultRedirectStrategy())}).build();
        HttpResponse response = (HttpResponse)pipeline.send(new HttpRequest(HttpMethod.GET, new URL("http://localhost/"))).block();
        Assertions.assertEquals((int)2, (int)httpClient.getCount());
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
    }

    @Test
    public void alreadyAttemptedUrlsTest() throws Exception {
        RecordingHttpClient httpClient = new RecordingHttpClient(request -> {
            if (request.getUrl().toString().equals("http://localhost/")) {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Location", "http://redirecthost/");
                HttpHeaders httpHeader = new HttpHeaders(headers);
                return Mono.just((Object)((Object)new MockHttpResponse((HttpRequest)request, 308, httpHeader)));
            }
            if (request.getUrl().toString().equals("http://redirecthost/")) {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Location", "http://redirecthost/");
                HttpHeaders httpHeader = new HttpHeaders(headers);
                return Mono.just((Object)((Object)new MockHttpResponse((HttpRequest)request, 308, httpHeader)));
            }
            return Mono.just((Object)((Object)new MockHttpResponse((HttpRequest)request, 200)));
        });
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)httpClient).policies(new HttpPipelinePolicy[]{new RedirectPolicy((RedirectStrategy)new DefaultRedirectStrategy())}).build();
        HttpResponse response = (HttpResponse)pipeline.send(new HttpRequest(HttpMethod.GET, new URL("http://localhost/"))).block();
        Assertions.assertEquals((int)2, (int)httpClient.getCount());
        Assertions.assertEquals((int)308, (int)response.getStatusCode());
    }

    @Test
    public void redirectForProvidedHeader() throws MalformedURLException {
        int[] requestCount = new int[]{1};
        RecordingHttpClient httpClient = new RecordingHttpClient(request -> {
            HashMap<String, CallSite> headers = new HashMap<String, CallSite>();
            headers.put("Location1", (CallSite)((Object)("http://redirecthost/" + requestCount[0])));
            HttpHeaders httpHeader = new HttpHeaders(headers);
            requestCount[0] = requestCount[0] + 1;
            return Mono.just((Object)((Object)new MockHttpResponse((HttpRequest)request, 308, httpHeader)));
        });
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)httpClient).policies(new HttpPipelinePolicy[]{new RedirectPolicy((RedirectStrategy)new DefaultRedirectStrategy(5, "Location1", null))}).build();
        HttpResponse response = (HttpResponse)pipeline.send(new HttpRequest(HttpMethod.GET, new URL("http://localhost/"))).block();
        Assertions.assertEquals((int)5, (int)httpClient.getCount());
        Assertions.assertEquals((int)308, (int)response.getStatusCode());
    }

    @Test
    public void redirectForProvidedMethods() throws MalformedURLException {
        HashSet<HttpMethod> allowedMethods = new HashSet<HttpMethod>(){
            {
                this.add(HttpMethod.GET);
                this.add(HttpMethod.PUT);
                this.add(HttpMethod.POST);
            }
        };
        int[] requestCount = new int[]{1};
        RecordingHttpClient httpClient = new RecordingHttpClient(request -> {
            if (request.getUrl().toString().equals("http://localhost/")) {
                HashMap<String, CallSite> headers = new HashMap<String, CallSite>();
                int n = requestCount[0];
                requestCount[0] = n + 1;
                headers.put("Location", (CallSite)((Object)("http://redirecthost/" + n)));
                HttpHeaders httpHeader = new HttpHeaders(headers);
                request.setHttpMethod(HttpMethod.PUT);
                requestCount[0] = requestCount[0] + 1;
                return Mono.just((Object)((Object)new MockHttpResponse((HttpRequest)request, 308, httpHeader)));
            }
            if (request.getUrl().toString().equals("http://redirecthost/" + requestCount[0]) && requestCount[0] == 2) {
                HashMap<String, CallSite> headers = new HashMap<String, CallSite>();
                int n = requestCount[0];
                requestCount[0] = n + 1;
                headers.put("Location", (CallSite)((Object)("http://redirecthost/" + n)));
                HttpHeaders httpHeader = new HttpHeaders(headers);
                request.setHttpMethod(HttpMethod.POST);
                return Mono.just((Object)((Object)new MockHttpResponse((HttpRequest)request, 308, httpHeader)));
            }
            return Mono.just((Object)((Object)new MockHttpResponse((HttpRequest)request, 200)));
        });
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)httpClient).policies(new HttpPipelinePolicy[]{new RedirectPolicy((RedirectStrategy)new DefaultRedirectStrategy(5, null, (Set)allowedMethods))}).build();
        HttpResponse response = (HttpResponse)pipeline.send(new HttpRequest(HttpMethod.GET, new URL("http://localhost/"))).block();
        Assertions.assertEquals((int)2, (int)httpClient.getCount());
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
    }

    @Test
    public void nullRedirectUrlTest() throws MalformedURLException {
        RecordingHttpClient httpClient = new RecordingHttpClient(request -> {
            if (request.getUrl().toString().equals("http://localhost/")) {
                HashMap headers = new HashMap();
                HttpHeaders httpHeader = new HttpHeaders(headers);
                return Mono.just((Object)((Object)new MockHttpResponse((HttpRequest)request, 308, httpHeader)));
            }
            return Mono.just((Object)((Object)new MockHttpResponse((HttpRequest)request, 200)));
        });
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)httpClient).policies(new HttpPipelinePolicy[]{new RedirectPolicy((RedirectStrategy)new DefaultRedirectStrategy())}).build();
        HttpResponse response = (HttpResponse)pipeline.send(new HttpRequest(HttpMethod.GET, new URL("http://localhost/"))).block();
        Assertions.assertEquals((int)1, (int)httpClient.getCount());
        Assertions.assertEquals((int)308, (int)response.getStatusCode());
    }

    @Test
    public void redirectForMultipleRequests() throws MalformedURLException {
        RecordingHttpClient httpClient = new RecordingHttpClient(request -> {
            if (request.getUrl().toString().equals("http://localhost/")) {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Location", "http://redirecthost/");
                HttpHeaders httpHeader = new HttpHeaders(headers);
                return Mono.just((Object)((Object)new MockHttpResponse((HttpRequest)request, 308, httpHeader)));
            }
            return Mono.just((Object)((Object)new MockHttpResponse((HttpRequest)request, 200)));
        });
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)httpClient).policies(new HttpPipelinePolicy[]{new RedirectPolicy()}).build();
        HttpResponse response1 = (HttpResponse)pipeline.send(new HttpRequest(HttpMethod.GET, new URL("http://localhost/"))).block();
        HttpResponse response2 = (HttpResponse)pipeline.send(new HttpRequest(HttpMethod.GET, new URL("http://localhost/"))).block();
        Assertions.assertEquals((int)4, (int)httpClient.getCount());
        Assertions.assertEquals((int)200, (int)response1.getStatusCode());
        Assertions.assertEquals((int)200, (int)response2.getStatusCode());
    }

    static class RecordingHttpClient
    implements HttpClient {
        private final AtomicInteger count = new AtomicInteger();
        private final Function<HttpRequest, Mono<HttpResponse>> handler;

        RecordingHttpClient(Function<HttpRequest, Mono<HttpResponse>> handler) {
            this.handler = handler;
        }

        public Mono<HttpResponse> send(HttpRequest httpRequest) {
            this.count.getAndIncrement();
            return this.handler.apply(httpRequest);
        }

        int getCount() {
            return this.count.get();
        }

        void resetCount() {
            this.count.set(0);
        }
    }
}

