/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.util.IterableStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Flux;

public class IterableResponseTest {
    @Test
    public void testIterableResponseStreamFromStart() {
        IterableStream<Integer> iterableResponse = this.getIntegerIterableResponse(2, 5);
        Assertions.assertEquals((long)iterableResponse.stream().count(), (long)iterableResponse.stream().count());
        List<Integer> originalIntegerList = Arrays.asList(2, 3, 4, 5, 6);
        iterableResponse.stream().forEach(number -> Assertions.assertTrue((boolean)originalIntegerList.contains(number)));
    }

    @Test
    public void testIterableResponseIteratorFromStart() {
        IterableStream<Integer> iterableResponse = this.getIntegerIterableResponse(2, 5);
        ArrayList actualNumberValues1 = new ArrayList();
        ArrayList actualNumberValues2 = new ArrayList();
        iterableResponse.iterator().forEachRemaining(actualNumberValues1::add);
        iterableResponse.iterator().forEachRemaining(actualNumberValues2::add);
        Assertions.assertArrayEquals((Object[])actualNumberValues1.toArray(), (Object[])actualNumberValues2.toArray());
        List<Integer> originalIntegerList = Arrays.asList(2, 3, 4, 5, 6);
        iterableResponse.iterator().forEachRemaining(number -> Assertions.assertTrue((boolean)originalIntegerList.contains(number)));
    }

    private IterableStream<Integer> getIntegerIterableResponse(int startNumber, int noOfValues) {
        Flux integerFlux = Flux.range((int)startNumber, (int)noOfValues);
        return new IterableStream(integerFlux);
    }
}

