/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.util.paging.PageRetriever;
import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PagedFluxJavaDocCodeSnippets {
    public void classDocSnippet() {
        PagedFlux<Integer> pagedFlux = this.createAnInstance();
        pagedFlux.log().subscribe(item -> System.out.println("Processing item with value: " + item), error -> System.err.println("An error occurred: " + error), () -> System.out.println("Processing complete."));
        pagedFlux.byPage().log().subscribe(page -> System.out.printf("Processing page containing item values: %s%n", page.getElements().stream().map(String::valueOf).collect(Collectors.joining(", "))), error -> System.err.println("An error occurred: " + error), () -> System.out.println("Processing complete."));
        String continuationToken = this.getContinuationToken();
        pagedFlux.byPage(continuationToken).log().doOnSubscribe(ignored -> System.out.println("Subscribed to paged flux processing pages starting from: " + continuationToken)).subscribe(page -> System.out.printf("Processing page containing item values: %s%n", page.getElements().stream().map(String::valueOf).collect(Collectors.joining(", "))), error -> System.err.println("An error occurred: " + error), () -> System.out.println("Processing complete."));
    }

    public PagedFlux<Integer> createAnInstance() {
        Supplier<Mono> firstPageRetriever = () -> this.getFirstPage();
        Function<String, Mono> nextPageRetriever = continuationToken -> this.getNextPage((String)continuationToken);
        PagedFlux pagedFlux = new PagedFlux(firstPageRetriever, nextPageRetriever);
        Supplier<Mono> firstPageRetrieverFunction = () -> this.getFirstPage();
        PagedFlux pagedFluxInstance = new PagedFlux(firstPageRetrieverFunction, nextPageRetriever);
        return pagedFlux;
    }

    public void createASinglePageInstanceWithPageSizeSupport() {
        Function<Integer, Mono> singlePageRetriever = pageSize -> this.getFirstPageWithSize((Integer)pageSize);
        PagedFlux singlePageFluxWithPageSize = new PagedFlux(singlePageRetriever);
    }

    public void createAnInstanceWithPageSizeSupport() {
        Function<Integer, Mono> firstPageRetriever = pageSize -> this.getFirstPageWithSize((Integer)pageSize);
        BiFunction<String, Integer, Mono> nextPageRetriever = (continuationToken, pageSize) -> this.getNextPageWithSize((String)continuationToken, (Integer)pageSize);
        PagedFlux pagedFluxWithPageSize = new PagedFlux(firstPageRetriever, nextPageRetriever);
    }

    public void byPageSnippet() {
        PagedFlux<Integer> pagedFlux = this.createAnInstance();
        pagedFlux.byPage().log().doOnSubscribe(ignoredVal -> System.out.println("Subscribed to paged flux processing pages starting from first page")).subscribe(page -> System.out.printf("Processing page containing item values: %s%n", page.getElements().stream().map(String::valueOf).collect(Collectors.joining(", "))), error -> System.err.println("An error occurred: " + error), () -> System.out.println("Processing complete."));
        String continuationToken = this.getContinuationToken();
        pagedFlux.byPage(continuationToken).log().doOnSubscribe(ignoredVal -> System.out.println("Subscribed to paged flux processing page starting from " + continuationToken)).subscribe(page -> System.out.printf("Processing page containing item values: %s%n", page.getElements().stream().map(String::valueOf).collect(Collectors.joining(", "))), error -> System.err.println("An error occurred: " + error), () -> System.out.println("Processing complete."));
    }

    public void byTSnippet() {
        PagedFlux<Integer> pagedFlux = this.createAnInstance();
        pagedFlux.subscribe((CoreSubscriber)new BaseSubscriber<Integer>(){

            protected void hookOnSubscribe(Subscription subscription) {
                System.out.println("Subscribed to paged flux processing items");
                super.hookOnSubscribe(subscription);
            }

            protected void hookOnNext(Integer value) {
                System.out.println("Processing item with value: " + value);
            }

            protected void hookOnComplete() {
                System.out.println("Processing complete.");
            }
        });
    }

    public void pagedFluxFromPagedFlux() {
        PagedFlux<Integer> intPagedFlux = this.createAnInstance();
        Function<PagedResponse, PagedResponse> responseMapper = intResponse -> new PagedResponseBase(intResponse.getRequest(), intResponse.getStatusCode(), intResponse.getHeaders(), intResponse.getValue().stream().map(intValue -> Integer.toString(intValue)).collect(Collectors.toList()), (String)intResponse.getContinuationToken(), null);
        Supplier<PageRetriever> provider = () -> (continuationToken, pageSize) -> {
            Flux flux = continuationToken == null ? intPagedFlux.byPage() : intPagedFlux.byPage(continuationToken);
            return flux.map(responseMapper);
        };
        PagedFlux strPagedFlux = PagedFlux.create(provider);
        PagedFlux<Integer> pagedFlux = this.createAnInstance();
        Supplier<PageRetriever> eprovider = () -> (continuationToken, pageSize) -> {
            Flux flux = continuationToken == null ? pagedFlux.byPage() : pagedFlux.byPage(continuationToken);
            return flux.onErrorMap(PaginationException::new);
        };
        PagedFlux exceptionMappedPagedFlux = PagedFlux.create(eprovider);
    }

    private String getContinuationToken() {
        return UUID.randomUUID().toString();
    }

    private Mono<PagedResponse<Integer>> getFirstPage() {
        return this.getPage(null, null);
    }

    private Mono<PagedResponse<Integer>> getNextPage(String continuationToken) {
        return this.getPage(continuationToken, null);
    }

    private Mono<PagedResponse<Integer>> getFirstPageWithSize(Integer pageSize) {
        return this.getPage(null, pageSize);
    }

    private Mono<PagedResponse<Integer>> getNextPageWithSize(String continuationToken, Integer pageSize) {
        return this.getPage(continuationToken, pageSize);
    }

    private Mono<PagedResponse<Integer>> getPage(String continuationToken, Integer pageSize) {
        boolean lastPage = Math.random() > 0.5;
        String nextContinuationToken = lastPage ? null : UUID.randomUUID().toString();
        int elementCount = pageSize == null ? (int)Math.ceil(Math.random() * 15.0) : pageSize;
        List elements = IntStream.range(elementCount, elementCount + elementCount).map(val -> (int)(Math.random() * (double)val)).boxed().collect(Collectors.toList());
        return Mono.just((Object)new PagedResponseBase(new HttpRequest(HttpMethod.GET, "https://requestUrl.com"), 200, new HttpHeaders(), elements, nextContinuationToken, null));
    }

    static class PaginationException
    extends RuntimeException {
        PaginationException(Throwable ex) {
            super(ex);
        }
    }
}

