/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.OnlyOnePageRetriever;
import com.azure.core.http.rest.OnlyOnePagedFlux;
import com.azure.core.http.rest.Page;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedFluxBase;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.paging.ContinuablePage;
import com.azure.core.util.paging.ContinuablePagedFlux;
import com.azure.core.util.paging.ContinuablePagedFluxCore;
import com.azure.core.util.paging.PageRetriever;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class PagedFluxTest {
    private static final int DEFAULT_PAGE_COUNT = 4;
    private List<PagedResponse<Integer>> pagedResponses;
    private List<PagedResponse<String>> pagedStringResponses;

    @Test
    public void testEmptyResults() {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(0);
        StepVerifier.create(pagedFlux).verifyComplete();
        StepVerifier.create((Publisher)pagedFlux.byPage()).verifyComplete();
        StepVerifier.create((Publisher)pagedFlux.byPage(null)).verifyComplete();
    }

    @Test
    public void testPagedFluxSubscribeToItems() {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(5);
        StepVerifier.create(pagedFlux).expectNext((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14}).verifyComplete();
    }

    @Test
    public void testPagedFluxConverter() {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(5);
        StepVerifier.create((Publisher)pagedFlux.mapPage(String::valueOf)).expectNext((Object[])new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14"}).verifyComplete();
    }

    @Test
    public void testPagedFluxSubscribeToPagesFromStart() {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(5);
        StepVerifier.create((Publisher)pagedFlux.byPage()).expectNext(this.pagedResponses.get(0), this.pagedResponses.get(1), this.pagedResponses.get(2), this.pagedResponses.get(3), this.pagedResponses.get(4)).verifyComplete();
    }

    @Test
    public void testPagedFluxSubscribeToPagesFromStartWithConvertedType() {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(5);
        StepVerifier.create((Publisher)pagedFlux.mapPage(String::valueOf).byPage()).expectNextCount(5L).verifyComplete();
        StepVerifier.create((Publisher)pagedFlux.mapPage(String::valueOf).byPage()).expectNextMatches(pagedResponse -> this.pagedStringResponses.get(0).getValue().equals(pagedResponse.getValue())).expectNextMatches(pagedResponse -> this.pagedStringResponses.get(1).getValue().equals(pagedResponse.getValue())).expectNextMatches(pagedResponse -> this.pagedStringResponses.get(2).getValue().equals(pagedResponse.getValue())).expectNextMatches(pagedResponse -> this.pagedStringResponses.get(3).getValue().equals(pagedResponse.getValue())).expectNextMatches(pagedResponse -> this.pagedStringResponses.get(4).getValue().equals(pagedResponse.getValue())).verifyComplete();
    }

    @Test
    public void testPagedFluxSinglePageConvertedType() {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(1);
        StepVerifier.create((Publisher)pagedFlux.mapPage(String::valueOf).byPage()).expectNextCount(1L).verifyComplete();
        StepVerifier.create((Publisher)pagedFlux.mapPage(String::valueOf).byPage()).expectNextMatches(pagedResponse -> this.pagedStringResponses.get(0).getValue().equals(pagedResponse.getValue())).verifyComplete();
    }

    @Test
    public void testPagedFluxSubscribeToPagesFromContinuationToken() {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(5);
        StepVerifier.create((Publisher)pagedFlux.byPage("3")).expectNext(this.pagedResponses.get(3), this.pagedResponses.get(4)).verifyComplete();
    }

    @Test
    public void testPagedFluxSubscribeToPagesWithSinglePageResult() {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(1);
        StepVerifier.create((Publisher)pagedFlux.byPage()).expectNext(this.pagedResponses.get(0)).verifyComplete();
        pagedFlux = this.getIntegerPagedFlux(1);
        StepVerifier.create((Publisher)pagedFlux.byPage(null)).verifyComplete();
        pagedFlux = this.getIntegerPagedFlux(1);
        StepVerifier.create(pagedFlux).expectNext((Object)0, (Object)1, (Object)2).verifyComplete();
    }

    @Test
    public void testPagedFluxSubscribeToPagesWithSinglePageResultWithoutNextPageRetriever() {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFluxSinglePage();
        StepVerifier.create((Publisher)pagedFlux.byPage()).expectNext(this.pagedResponses.get(0)).verifyComplete();
        pagedFlux = this.getIntegerPagedFluxSinglePage();
        StepVerifier.create((Publisher)pagedFlux.byPage(null)).verifyComplete();
        pagedFlux = this.getIntegerPagedFluxSinglePage();
        StepVerifier.create(pagedFlux).expectNext((Object)0, (Object)1, (Object)2).verifyComplete();
    }

    @Test
    public void testPagedFluxSubscribeToPagesWithTwoPages() {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(2);
        StepVerifier.create((Publisher)pagedFlux.byPage()).expectNext(this.pagedResponses.get(0), this.pagedResponses.get(1)).verifyComplete();
        pagedFlux = this.getIntegerPagedFlux(2);
        StepVerifier.create((Publisher)pagedFlux.byPage("1")).expectNext(this.pagedResponses.get(1)).verifyComplete();
        pagedFlux = this.getIntegerPagedFlux(2);
        StepVerifier.create(pagedFlux).expectNext((Object)0, (Object)1, (Object)2, (Object)3, (Object)4, (Object)5).verifyComplete();
    }

    @Test
    public void testPagedFluxSubscribeToPagesFromNullContinuationToken() {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(5);
        StepVerifier.create((Publisher)pagedFlux.byPage(null)).verifyComplete();
    }

    @Test
    public void testPagedFluxWithContext() {
        String expectedContextKey = "hello";
        String expectedContextValue = "context";
        Consumer<com.azure.core.util.Context> contextVerifier = context -> {
            Assertions.assertNotNull((Object)context);
            Assertions.assertEquals((int)1, (int)context.getValues().size());
            Assertions.assertEquals((Object)"context", (Object)context.getData((Object)"hello").orElse("").toString());
        };
        HttpHeaders headers = new HttpHeaders();
        HttpRequest request = new HttpRequest(HttpMethod.GET, "http://localhost");
        Function<String, PagedResponse> pagedResponseSupplier = continuationToken -> new PagedResponseBase(request, 200, headers, Collections.emptyList(), continuationToken, null);
        PagedFlux singlePageFlux = new PagedFlux(() -> FluxUtil.withContext(context -> {
            contextVerifier.accept((com.azure.core.util.Context)context);
            return Mono.just((Object)((PagedResponse)pagedResponseSupplier.apply(null)));
        }));
        StepVerifier.create((Publisher)singlePageFlux.byPage().contextWrite((ContextView)Context.of((Object)"hello", (Object)"context"))).assertNext(Assertions::assertNotNull).verifyComplete();
        String expectedContinuationToken = "0";
        PagedFlux multiPageFlux = new PagedFlux(() -> FluxUtil.withContext(context -> {
            contextVerifier.accept((com.azure.core.util.Context)context);
            return Mono.just((Object)((PagedResponse)pagedResponseSupplier.apply("0")));
        }), continuationToken -> FluxUtil.withContext(context -> {
            contextVerifier.accept((com.azure.core.util.Context)context);
            Assertions.assertEquals((Object)"0", (Object)continuationToken);
            return Mono.just((Object)((PagedResponse)pagedResponseSupplier.apply(null)));
        }));
        StepVerifier.create((Publisher)multiPageFlux.byPage().contextWrite((ContextView)Context.of((Object)"hello", (Object)"context"))).expectNextCount(2L).verifyComplete();
    }

    @Test
    public void pagedFluxWithPageSize() {
        int expectedPageSize = 5;
        HttpHeaders headers = new HttpHeaders();
        HttpRequest request = new HttpRequest(HttpMethod.GET, "http://localhost");
        Function<String, PagedResponse> pagedResponseSupplier = continuationToken -> new PagedResponseBase(request, 200, headers, Collections.emptyList(), continuationToken, null);
        PagedFlux singlePageFlux = new PagedFlux(pageSize -> {
            Assertions.assertEquals((int)5, (Integer)pageSize);
            return Mono.just((Object)((PagedResponse)pagedResponseSupplier.apply(null)));
        });
        StepVerifier.create((Publisher)singlePageFlux.byPage(5)).assertNext(Assertions::assertNotNull).verifyComplete();
        String expectedContinuationToken = "0";
        PagedFlux multiPageFlux = new PagedFlux(pageSize -> {
            Assertions.assertEquals((int)5, (Integer)pageSize);
            return Mono.just((Object)((PagedResponse)pagedResponseSupplier.apply("0")));
        }, (continuationToken, pageSize) -> {
            Assertions.assertEquals((int)5, (Integer)pageSize);
            Assertions.assertEquals((Object)"0", (Object)continuationToken);
            return Mono.just((Object)((PagedResponse)pagedResponseSupplier.apply(null)));
        });
        StepVerifier.create((Publisher)multiPageFlux.byPage(5)).expectNextCount(2L).verifyComplete();
    }

    private PagedFlux<Integer> getIntegerPagedFlux(int noOfPages) {
        HttpHeaders httpHeaders = new HttpHeaders().set("header1", "value1").set("header2", "value2");
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, "http://localhost");
        String deserializedHeaders = "header1,value1,header2,value2";
        this.pagedResponses = IntStream.range(0, noOfPages).boxed().map(i -> this.createPagedResponse(httpRequest, httpHeaders, deserializedHeaders, (int)i, noOfPages)).collect(Collectors.toList());
        this.pagedStringResponses = IntStream.range(0, noOfPages).boxed().map(i -> this.createPagedResponseWithString(httpRequest, httpHeaders, deserializedHeaders, (int)i, noOfPages)).collect(Collectors.toList());
        return new PagedFlux(() -> this.pagedResponses.isEmpty() ? Mono.empty() : Mono.just(this.pagedResponses.get(0)), continuationToken -> this.getNextPage((String)continuationToken, this.pagedResponses));
    }

    private PagedFlux<Integer> getIntegerPagedFluxSinglePage() {
        HttpHeaders httpHeaders = new HttpHeaders().set("header1", "value1").set("header2", "value2");
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, "http://localhost");
        String deserializedHeaders = "header1,value1,header2,value2";
        this.pagedResponses = IntStream.range(0, 1).boxed().map(i -> this.createPagedResponse(httpRequest, httpHeaders, deserializedHeaders, (int)i, 1)).collect(Collectors.toList());
        this.pagedStringResponses = IntStream.range(0, 1).boxed().map(i -> this.createPagedResponseWithString(httpRequest, httpHeaders, deserializedHeaders, (int)i, 1)).collect(Collectors.toList());
        return new PagedFlux(() -> this.pagedResponses.isEmpty() ? Mono.empty() : Mono.just(this.pagedResponses.get(0)));
    }

    private PagedResponseBase<String, Integer> createPagedResponse(HttpRequest httpRequest, HttpHeaders httpHeaders, String deserializedHeaders, int i, int noOfPages) {
        return new PagedResponseBase(httpRequest, 200, httpHeaders, this.getItems(i), i < noOfPages - 1 ? String.valueOf(i + 1) : null, (Object)deserializedHeaders);
    }

    private PagedResponseBase<String, String> createPagedResponseWithString(HttpRequest httpRequest, HttpHeaders httpHeaders, String deserializedHeaders, int i, int noOfPages) {
        return new PagedResponseBase(httpRequest, 200, httpHeaders, this.getStringItems(i), i < noOfPages - 1 ? String.valueOf(i + 1) : null, (Object)deserializedHeaders);
    }

    private Mono<PagedResponse<Integer>> getNextPage(String continuationToken, List<PagedResponse<Integer>> pagedResponses) {
        if (continuationToken == null || continuationToken.isEmpty()) {
            return Mono.empty();
        }
        int parsedToken = Integer.parseInt(continuationToken);
        if (parsedToken >= pagedResponses.size()) {
            return Mono.empty();
        }
        return Mono.just(pagedResponses.get(parsedToken));
    }

    private List<Integer> getItems(Integer i) {
        return IntStream.range(i * 3, i * 3 + 3).boxed().collect(Collectors.toList());
    }

    private List<String> getStringItems(Integer i) {
        return IntStream.range(i * 3, i * 3 + 3).boxed().map(String::valueOf).collect(Collectors.toList());
    }

    @Test
    public void fluxByItemOnlyRetrievesOnePage() {
        OnlyOnePageRetriever pageRetriever = new OnlyOnePageRetriever(4);
        OnlyOnePagedFlux pagedFlux = new OnlyOnePagedFlux(() -> pageRetriever);
        pagedFlux.ignoreElements().block();
        Assertions.assertEquals((int)4, (int)pageRetriever.getGetCount());
        StepVerifier.create((Publisher)pagedFlux.take(1L).then(Mono.delay((Duration)Duration.ofMillis(500L)).then())).verifyComplete();
        Assertions.assertEquals((int)1, (int)(pageRetriever.getGetCount() - 4));
    }

    @Test
    public void fluxByPageOnlyRetrievesOnePage() {
        OnlyOnePageRetriever pageRetriever = new OnlyOnePageRetriever(4);
        OnlyOnePagedFlux pagedFlux = new OnlyOnePagedFlux(() -> pageRetriever);
        pagedFlux.byPage().ignoreElements().block();
        Assertions.assertEquals((int)4, (int)pageRetriever.getGetCount());
        StepVerifier.create((Publisher)pagedFlux.byPage().take(1L).then(Mono.delay((Duration)Duration.ofMillis(500L)).then())).verifyComplete();
        Assertions.assertEquals((int)1, (int)(pageRetriever.getGetCount() - 4));
    }

    @ParameterizedTest
    @MethodSource(value={"pagingTerminatesOnSupplier"})
    public <C, T, P extends ContinuablePage<C, T>> void pagingTerminatesOn(ContinuablePagedFlux<C, T, P> pagedFlux, List<T> expectedItems) {
        StepVerifier.create((Publisher)pagedFlux.collectList()).assertNext(actualItems -> {
            Assertions.assertEquals((int)expectedItems.size(), (int)actualItems.size());
            for (int i = 0; i < expectedItems.size(); ++i) {
                Assertions.assertEquals(expectedItems.get(i), actualItems.get(i));
            }
        }).verifyComplete();
    }

    private static Stream<Arguments> pagingTerminatesOnSupplier() {
        GetPagesUntil pfEndsWithNullPageRetriever = new GetPagesUntil(null);
        PagedFlux pfEndsWithNull = PagedFlux.create(() -> pfEndsWithNullPageRetriever);
        GetPagesUntil pfEndsWithEmptyStringPageRetriever = new GetPagesUntil("");
        PagedFlux pfEndsWithEmptyString = PagedFlux.create(() -> pfEndsWithEmptyStringPageRetriever);
        GetPagesUntil pfbEndsWithNullPageRetriever = new GetPagesUntil(null);
        PagedFluxBase pfbEndsWithNull = new PagedFluxBase(() -> pfbEndsWithNullPageRetriever, false);
        GetPagesUntil pfbEndsWithEmptyStringPageRetriever = new GetPagesUntil("");
        PagedFluxBase pfbEndsWithEmptyString = new PagedFluxBase(() -> pfbEndsWithEmptyStringPageRetriever, false);
        GetContinuablePagesUntil<String> cpfcStringTokenEndsWithNullPageRetriever = new GetContinuablePagesUntil<String>("1", null, token -> String.valueOf(Integer.parseInt(token) + 1), token -> token.equals("4"));
        ContinuablePagedFluxCore cpfcStringTokenEndsWithNull = PagedFluxTest.createCpfc(() -> cpfcStringTokenEndsWithNullPageRetriever, null);
        GetContinuablePagesUntil<String> cpfcStringTokenEndsWithPredicatePageRetriever = new GetContinuablePagesUntil<String>("1", "finalToken", token -> String.valueOf(Integer.parseInt(token) + 1), token -> token.equals("4"));
        ContinuablePagedFluxCore cpfcStringTokenEndsWithPredicate = PagedFluxTest.createCpfc(() -> cpfcStringTokenEndsWithPredicatePageRetriever, token -> !token.equals("finalToken"));
        GetContinuablePagesUntil<byte[]> cpfcByteArrayTokenEndsWithNullPageRetriever = new GetContinuablePagesUntil<byte[]>("1".getBytes(StandardCharsets.UTF_8), null, token -> String.valueOf(Integer.parseInt(new String((byte[])token, StandardCharsets.UTF_8)) + 1).getBytes(StandardCharsets.UTF_8), token -> new String((byte[])token, StandardCharsets.UTF_8).equals("4"));
        ContinuablePagedFluxCore cpfcByteArrayTokenEndsWithNull = PagedFluxTest.createCpfc(() -> cpfcByteArrayTokenEndsWithNullPageRetriever, null);
        GetContinuablePagesUntil<byte[]> cpfcByteArrayTokenEndsWithPredicatePageRetriever = new GetContinuablePagesUntil<byte[]>("1".getBytes(StandardCharsets.UTF_8), "finalToken".getBytes(StandardCharsets.UTF_8), token -> String.valueOf(Integer.parseInt(new String((byte[])token, StandardCharsets.UTF_8)) + 1).getBytes(StandardCharsets.UTF_8), token -> new String((byte[])token, StandardCharsets.UTF_8).equals("4"));
        ContinuablePagedFluxCore cpfcByteArrayTokenEndsWithPredicate = PagedFluxTest.createCpfc(() -> cpfcByteArrayTokenEndsWithPredicatePageRetriever, token -> !new String((byte[])token, StandardCharsets.UTF_8).equals("finalToken"));
        List<String> pagedFluxExpectedItems = Arrays.asList("1", "2", "3", "4", "5");
        return Stream.of(Arguments.arguments((Object[])new Object[]{pfEndsWithNull, pagedFluxExpectedItems}), Arguments.arguments((Object[])new Object[]{pfEndsWithEmptyString, pagedFluxExpectedItems}), Arguments.arguments((Object[])new Object[]{pfbEndsWithNull, pagedFluxExpectedItems}), Arguments.arguments((Object[])new Object[]{pfbEndsWithEmptyString, pagedFluxExpectedItems}), Arguments.arguments((Object[])new Object[]{cpfcStringTokenEndsWithNull, pagedFluxExpectedItems}), Arguments.arguments((Object[])new Object[]{cpfcStringTokenEndsWithPredicate, pagedFluxExpectedItems}), Arguments.arguments((Object[])new Object[]{cpfcByteArrayTokenEndsWithNull, pagedFluxExpectedItems}), Arguments.arguments((Object[])new Object[]{cpfcByteArrayTokenEndsWithPredicate, pagedFluxExpectedItems}));
    }

    private static <C, T, P extends ContinuablePage<C, T>> ContinuablePagedFluxCore<C, T, P> createCpfc(Supplier<PageRetriever<C, P>> pageRetrieverSupplier, Predicate<C> continuationPredicate) {
        if (continuationPredicate == null) {
            return new ContinuablePagedFluxCore<C, T, P>(pageRetrieverSupplier){};
        }
        return new ContinuablePagedFluxCore<C, T, P>(pageRetrieverSupplier, null, continuationPredicate){};
    }

    private static <T> PagedResponse<T> createPagedResponse(final String continuationToken, final List<T> items) {
        return new PagedResponseBase(null, 200, null, new Page<T>(){

            public IterableStream<T> getElements() {
                return IterableStream.of((Iterable)items);
            }

            public String getContinuationToken() {
                return continuationToken;
            }
        }, null);
    }

    private static <C, T> ContinuablePage<C, T> createPage(final C token, final List<T> items) {
        return new ContinuablePage<C, T>(){

            public IterableStream<T> getElements() {
                return IterableStream.of((Iterable)items);
            }

            public C getContinuationToken() {
                return token;
            }
        };
    }

    private static final class GetContinuablePagesUntil<C>
    implements PageRetriever<C, ContinuablePage<C, String>> {
        private static final Function<String, String> INCREMENT_STRING_AS_INT = str -> String.valueOf(Integer.parseInt(str) + 1);
        private static final Function<String, String> NEXT_PAGE_VALUE = INCREMENT_STRING_AS_INT;
        private final BiFunction<C, String, ContinuablePage<C, String>> pageCreator = (token, item) -> PagedFluxTest.createPage(token, Collections.singletonList(item));
        private final String[] pageValue = new String[]{"1"};
        private final C initialToken;
        private final C finalToken;
        private final Function<C, C> nextToken;
        private final Predicate<C> isFinalPage;

        private GetContinuablePagesUntil(C initialToken, C finalToken, Function<C, C> nextToken, Predicate<C> isFinalPage) {
            this.initialToken = initialToken;
            this.finalToken = finalToken;
            this.nextToken = nextToken;
            this.isFinalPage = isFinalPage;
        }

        public Flux<ContinuablePage<C, String>> get(C token, Integer pageSize) {
            return Flux.defer(() -> {
                C nextContinuationToken = token == null ? this.initialToken : (this.isFinalPage.test(token) ? this.finalToken : this.nextToken.apply(token));
                ContinuablePage<C, String> page = this.pageCreator.apply(nextContinuationToken, this.pageValue[0]);
                this.pageValue[0] = NEXT_PAGE_VALUE.apply(this.pageValue[0]);
                return Flux.just(page);
            });
        }
    }

    private static final class GetPagesUntil
    implements PageRetriever<String, PagedResponse<String>> {
        private static final Function<String, String> INCREMENT_STRING_AS_INT = str -> String.valueOf(Integer.parseInt(str) + 1);
        private static final Function<String, String> NEXT_PAGE_VALUE = INCREMENT_STRING_AS_INT;
        private static final BiFunction<String, String, PagedResponse<String>> PAGE_CREATOR = (token, item) -> PagedFluxTest.createPagedResponse(token, Collections.singletonList(item));
        private final String[] pageValue = new String[]{"1"};
        private final Predicate<String> isFinalPage;
        private final String finalToken;

        private GetPagesUntil(String finalToken) {
            this.finalToken = finalToken;
            this.isFinalPage = token -> token.equals("4");
        }

        public Flux<PagedResponse<String>> get(String token, Integer pageSize) {
            return Flux.defer(() -> {
                String nextContinuationToken = token == null ? "1" : (this.isFinalPage.test(token) ? this.finalToken : INCREMENT_STRING_AS_INT.apply(token));
                PagedResponse<String> page = PAGE_CREATOR.apply(nextContinuationToken, this.pageValue[0]);
                this.pageValue[0] = NEXT_PAGE_VALUE.apply(this.pageValue[0]);
                return Flux.just(page);
            });
        }
    }
}

