/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import reactor.core.publisher.Mono;

public class PagedIterableJavaDocCodeSnippets {
    public void streamByPageSnippet() {
        PagedFlux<Integer> pagedFlux = this.createAnInstance();
        PagedIterable pagedIterableResponse = new PagedIterable(pagedFlux);
        pagedIterableResponse.streamByPage().forEach(resp -> {
            System.out.printf("Response headers are %s. Url %s  and status code %d %n", resp.getHeaders(), resp.getRequest().getUrl(), resp.getStatusCode());
            resp.getElements().forEach(value -> System.out.printf("Response value is %d %n", value));
        });
    }

    public void iterateByPageSnippet() {
        PagedFlux<Integer> pagedFlux = this.createAnInstance();
        PagedIterable pagedIterableResponse = new PagedIterable(pagedFlux);
        pagedIterableResponse.iterableByPage().forEach(resp -> {
            System.out.printf("Response headers are %s. Url %s  and status code %d %n", resp.getHeaders(), resp.getRequest().getUrl(), resp.getStatusCode());
            resp.getElements().forEach(value -> System.out.printf("Response value is %d %n", value));
        });
    }

    public void iterableByPageWhileSnippet() {
        PagedFlux<Integer> pagedFlux = this.createAnInstance();
        PagedIterable pagedIterableResponse = new PagedIterable(pagedFlux);
        for (PagedResponse resp : pagedIterableResponse.iterableByPage()) {
            System.out.printf("Response headers are %s. Url %s  and status code %d %n", resp.getHeaders(), resp.getRequest().getUrl(), resp.getStatusCode());
            resp.getElements().forEach(value -> System.out.printf("Response value is %d %n", value));
        }
    }

    public PagedFlux<Integer> createAnInstance() {
        Supplier<Mono> firstPageRetriever = () -> this.getFirstPage();
        Function<String, Mono> nextPageRetriever = continuationToken -> this.getNextPage((String)continuationToken);
        return new PagedFlux(firstPageRetriever, nextPageRetriever);
    }

    private Mono<PagedResponse<Integer>> getNextPage(String continuationToken) {
        return this.getPage(continuationToken);
    }

    private Mono<PagedResponse<Integer>> getFirstPage() {
        return this.getPage(null);
    }

    private Mono<PagedResponse<Integer>> getPage(String continuationToken) {
        boolean lastPage = Math.random() > 0.5;
        String nextContinuationToken = lastPage ? null : UUID.randomUUID().toString();
        int elementCount = (int)Math.ceil(Math.random() * 15.0);
        List elements = IntStream.range(elementCount, elementCount + elementCount).map(val -> (int)(Math.random() * (double)val)).boxed().collect(Collectors.toList());
        return Mono.just((Object)new PagedResponseBase(new HttpRequest(HttpMethod.GET, "https://requestUrl.com"), 200, new HttpHeaders(), elements, nextContinuationToken, null));
    }
}

