/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.rest.PercentEscaper;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class PercentEscaperTests {
    @Test
    public void cannotUseSpaceAsPlusAndSpaceAsSafeCharacter() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PercentEscaper(" ", true));
    }

    @ParameterizedTest
    @MethodSource(value={"escapeSupplier"})
    public void escape(PercentEscaper escaper, String original, String expected) {
        Assertions.assertEquals((Object)expected, (Object)escaper.escape(original));
    }

    private static Stream<Arguments> escapeSupplier() {
        PercentEscaper defaultEscaper = new PercentEscaper(null, false);
        return Stream.of(Arguments.arguments((Object[])new Object[]{defaultEscaper, null, null}), Arguments.arguments((Object[])new Object[]{defaultEscaper, "", ""}), Arguments.arguments((Object[])new Object[]{defaultEscaper, "$", "%24"}), Arguments.arguments((Object[])new Object[]{defaultEscaper, "\u00a2", "%C2%A2"}), Arguments.arguments((Object[])new Object[]{defaultEscaper, "\u0939", "%E0%A4%B9"}), Arguments.arguments((Object[])new Object[]{defaultEscaper, "\u20ac", "%E2%82%AC"}), Arguments.arguments((Object[])new Object[]{defaultEscaper, "\ud55c", "%ED%95%9C"}), Arguments.arguments((Object[])new Object[]{defaultEscaper, "\u5186", "%E5%86%86"}), Arguments.arguments((Object[])new Object[]{defaultEscaper, "\ud800\udf48", "%F0%90%8D%88"}), Arguments.arguments((Object[])new Object[]{defaultEscaper, "\u65e5\u672c\u8a9e", "%E6%97%A5%E6%9C%AC%E8%AA%9E"}), Arguments.arguments((Object[])new Object[]{defaultEscaper, " ", "%20"}), Arguments.arguments((Object[])new Object[]{new PercentEscaper(null, true), " ", "+"}), Arguments.arguments((Object[])new Object[]{new PercentEscaper("$", false), "$", "$"}), Arguments.arguments((Object[])new Object[]{new PercentEscaper("\u0939", false), "\u0939", "\u0939"}));
    }

    @ParameterizedTest
    @MethodSource(value={"invalidEscapeSupplier"})
    public void invalidEscape(String original) {
        Assertions.assertThrows(IllegalStateException.class, () -> new PercentEscaper(null, false).escape(original));
    }

    private static Stream<Arguments> invalidEscapeSupplier() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{"abcd\ud800"}), Arguments.arguments((Object[])new Object[]{"abcd\udf48\ud800"}), Arguments.arguments((Object[])new Object[]{"\ud800abcd"}));
    }
}

