/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseConstructorsCache;
import com.azure.core.http.rest.ResponseConstructorsCacheBenchMarkTestData;
import com.azure.core.http.rest.ResponseConstructorsCacheLambdaMetaFactory;
import com.azure.core.http.rest.ResponseConstructorsNoCacheReflection;
import com.azure.core.implementation.TypeUtil;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.Main;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.RunnerException;
import reactor.core.publisher.Mono;

@Fork(value=3)
@Warmup(iterations=5, time=2)
@Measurement(iterations=5, time=10)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Thread)
public class ResponseConstructorsCacheBenchMark {
    private ResponseConstructorsCacheBenchMarkTestData testData;
    private ResponseConstructorsCache defaultCache;
    private ResponseConstructorsCacheLambdaMetaFactory lambdaMetaCache;
    private ResponseConstructorsNoCacheReflection reflectionNoCache;

    @Setup
    public void setup() {
        this.testData = new ResponseConstructorsCacheBenchMarkTestData();
        this.defaultCache = new ResponseConstructorsCache();
        this.lambdaMetaCache = new ResponseConstructorsCacheLambdaMetaFactory();
        this.reflectionNoCache = new ResponseConstructorsNoCacheReflection();
    }

    @Benchmark
    public void reflectionCache(Blackhole blackhole) {
        ResponseConstructorsCacheBenchMarkTestData.Input[] inputs = this.testData.inputs();
        for (int i = 0; i < inputs.length; ++i) {
            Class responseClass = TypeUtil.getRawClass((Type)inputs[i].returnType());
            MethodHandle handle = this.defaultCache.get(responseClass);
            if (handle == null) {
                throw new IllegalStateException("Response constructor with expected parameters not found.");
            }
            Mono response = this.defaultCache.invoke(handle, inputs[i].decodedResponse(), inputs[i].bodyAsObject());
            blackhole.consume(response.block());
        }
    }

    @Benchmark
    public void lambdaMetaFactoryCache(Blackhole blackhole) {
        ResponseConstructorsCacheBenchMarkTestData.Input[] inputs = this.testData.inputs();
        for (int i = 0; i < inputs.length; ++i) {
            Class responseClass = TypeUtil.getRawClass((Type)inputs[i].returnType());
            ResponseConstructorsCacheLambdaMetaFactory.ResponseConstructor constructor = this.lambdaMetaCache.get(responseClass);
            if (constructor == null) {
                throw new IllegalStateException("Response constructor with expected parameters not found.");
            }
            Mono<Response<?>> response = constructor.invoke(inputs[i].decodedResponse(), inputs[i].bodyAsObject());
            blackhole.consume(response.block());
        }
    }

    @Benchmark
    public void reflectionNoCache(Blackhole blackhole) {
        ResponseConstructorsCacheBenchMarkTestData.Input[] inputs = this.testData.inputs();
        for (int i = 0; i < inputs.length; ++i) {
            Class responseClass = TypeUtil.getRawClass((Type)inputs[i].returnType());
            Constructor<? extends Response<?>> constructor = this.reflectionNoCache.get(responseClass);
            if (constructor == null) {
                throw new IllegalStateException("Response constructor with expected parameters not found.");
            }
            Mono<Response<?>> response = this.reflectionNoCache.invoke(constructor, inputs[i].decodedResponse(), inputs[i].bodyAsObject());
            blackhole.consume(response.block());
        }
    }

    public static void main(String ... args) throws IOException, RunnerException {
        Main.main((String[])args);
    }
}

