/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.exception.UnexpectedLengthException;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.MockHttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.FluxUtil;
import java.nio.ByteBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public class RestProxyTests {
    private static final byte[] EXPECTED = new byte[]{0, 1, 2, 3, 4};

    @Test
    public void emptyRequestBody() {
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, "http://localhost");
        StepVerifier.create((Publisher)RestProxy.validateLength((HttpRequest)httpRequest)).verifyComplete();
    }

    @Test
    public void expectedBodyLength() {
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, "http://localhost").setBody(EXPECTED).setHeader("Content-Length", "5");
        StepVerifier.create(RestProxyTests.collectRequest(httpRequest)).assertNext(bytes -> Assertions.assertArrayEquals((byte[])EXPECTED, (byte[])bytes)).verifyComplete();
    }

    @Test
    public void unexpectedBodyLength() {
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, "http://localhost").setBody(EXPECTED);
        StepVerifier.create(RestProxyTests.collectRequest(httpRequest.setHeader("Content-Length", "4"))).verifyErrorSatisfies(throwable -> {
            Assertions.assertTrue((boolean)(throwable instanceof UnexpectedLengthException));
            Assertions.assertEquals((Object)"Request body emitted 5 bytes, more than the expected 4 bytes.", (Object)throwable.getMessage());
        });
        StepVerifier.create(RestProxyTests.collectRequest(httpRequest.setHeader("Content-Length", "6"))).verifyErrorSatisfies(throwable -> {
            Assertions.assertTrue((boolean)(throwable instanceof UnexpectedLengthException));
            Assertions.assertEquals((Object)"Request body emitted 5 bytes, less than the expected 6 bytes.", (Object)throwable.getMessage());
        });
    }

    @Test
    public void multipleSubscriptionsToCheckBodyLength() {
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, "http://localhost").setBody(EXPECTED).setHeader("Content-Length", "5");
        Flux verifierFlux = RestProxy.validateLength((HttpRequest)httpRequest);
        StepVerifier.create((Publisher)FluxUtil.collectBytesInByteBufferStream((Flux)verifierFlux)).assertNext(bytes -> Assertions.assertArrayEquals((byte[])EXPECTED, (byte[])bytes)).verifyComplete();
        StepVerifier.create((Publisher)FluxUtil.collectBytesInByteBufferStream((Flux)verifierFlux)).assertNext(bytes -> Assertions.assertArrayEquals((byte[])EXPECTED, (byte[])bytes)).verifyComplete();
    }

    @Test
    public void contentTypeHeaderPriorityOverBodyParamAnnotationTest() {
        LocalHttpClient client = new LocalHttpClient();
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)client).build();
        TestInterface testInterface = (TestInterface)RestProxy.create(TestInterface.class, (HttpPipeline)pipeline);
        byte[] bytes = "hello".getBytes();
        Response response = (Response)testInterface.testMethod((Flux<ByteBuffer>)Flux.just((Object)ByteBuffer.wrap(bytes)), "application/json", Long.valueOf(bytes.length)).block();
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
    }

    private static Mono<byte[]> collectRequest(HttpRequest request) {
        return FluxUtil.collectBytesInByteBufferStream((Flux)RestProxy.validateLength((HttpRequest)request));
    }

    private static final class LocalHttpClient
    implements HttpClient {
        private LocalHttpClient() {
        }

        public Mono<HttpResponse> send(HttpRequest request) {
            boolean success = request.getHeaders().stream().filter(header -> header.getName().equals("Content-Type")).map(header -> header.getValue()).anyMatch(contentType -> contentType.equals("application/json"));
            int statusCode = success ? 200 : 400;
            return Mono.just((Object)((Object)new MockHttpResponse(request, statusCode)));
        }
    }

    @Host(value="https://azure.com")
    @ServiceInterface(name="myService")
    static interface TestInterface {
        @Post(value="my/url/path")
        @ExpectedResponses(value={200})
        public Mono<Response<Void>> testMethod(@BodyParam(value="application/octet-stream") Flux<ByteBuffer> var1, @HeaderParam(value="Content-Type") String var2, @HeaderParam(value="Content-Length") Long var3);
    }
}

