/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.FormParam;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnValueWireType;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.rest.MissingRequiredAnnotationException;
import com.azure.core.http.rest.Page;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.SwaggerMethodParser;
import com.azure.core.implementation.UnixTime;
import com.azure.core.util.Base64Url;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.UrlBuilder;
import java.lang.reflect.Method;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class SwaggerMethodParserTests {
    @Test
    public void noHttpMethodAnnotation() throws NoSuchMethodException {
        Method noHttpMethodAnnotation = OperationMethods.class.getDeclaredMethod("noMethod", new Class[0]);
        Assertions.assertThrows(MissingRequiredAnnotationException.class, () -> new SwaggerMethodParser(noHttpMethodAnnotation, "s://raw.host.com"));
    }

    @ParameterizedTest
    @MethodSource(value={"httpMethodSupplier"})
    public void httpMethod(Method method, HttpMethod expectedMethod, String expectedRelativePath, String expectedFullyQualifiedName) {
        SwaggerMethodParser swaggerMethodParser = new SwaggerMethodParser(method, "https://raw.host.com");
        Assertions.assertEquals((Object)expectedMethod, (Object)swaggerMethodParser.getHttpMethod());
        Assertions.assertEquals((Object)expectedRelativePath, (Object)swaggerMethodParser.setPath(null));
        Assertions.assertEquals((Object)expectedFullyQualifiedName, (Object)swaggerMethodParser.getFullyQualifiedMethodName());
    }

    private static Stream<Arguments> httpMethodSupplier() throws NoSuchMethodException {
        Class<OperationMethods> clazz = OperationMethods.class;
        return Stream.of(Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("getMethod", new Class[0]), HttpMethod.GET, "test", "com.azure.core.http.rest.SwaggerMethodParserTests$OperationMethods.getMethod"}), Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("putMethod", new Class[0]), HttpMethod.PUT, "test", "com.azure.core.http.rest.SwaggerMethodParserTests$OperationMethods.putMethod"}), Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("headMethod", new Class[0]), HttpMethod.HEAD, "test", "com.azure.core.http.rest.SwaggerMethodParserTests$OperationMethods.headMethod"}), Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("deleteMethod", new Class[0]), HttpMethod.DELETE, "test", "com.azure.core.http.rest.SwaggerMethodParserTests$OperationMethods.deleteMethod"}), Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("postMethod", new Class[0]), HttpMethod.POST, "test", "com.azure.core.http.rest.SwaggerMethodParserTests$OperationMethods.postMethod"}), Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("patchMethod", new Class[0]), HttpMethod.PATCH, "test", "com.azure.core.http.rest.SwaggerMethodParserTests$OperationMethods.patchMethod"}));
    }

    @ParameterizedTest
    @MethodSource(value={"wireTypesSupplier"})
    public void wireTypes(Method method, Class<?> expectedWireType) {
        SwaggerMethodParser swaggerMethodParser = new SwaggerMethodParser(method, "https://raw.host.com");
        Assertions.assertEquals(expectedWireType, (Object)swaggerMethodParser.getReturnValueWireType());
    }

    private static Stream<Arguments> wireTypesSupplier() throws NoSuchMethodException {
        Class<WireTypesMethods> clazz = WireTypesMethods.class;
        return Stream.of(Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("noWireType", new Class[0]), null}), Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("base64Url", new Class[0]), Base64Url.class}), Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("unixTime", new Class[0]), UnixTime.class}), Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("dateTimeRfc1123", new Class[0]), DateTimeRfc1123.class}), Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("page", new Class[0]), Page.class}), Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("unknownType", new Class[0]), null}));
    }

    @ParameterizedTest
    @MethodSource(value={"headersSupplier"})
    public void headers(Method method, HttpHeaders expectedHeaders) {
        SwaggerMethodParser swaggerMethodParser = new SwaggerMethodParser(method, "https://raw.host.com");
        HttpHeaders actual = new HttpHeaders();
        swaggerMethodParser.setHeaders(null, actual);
        for (HttpHeader header : actual) {
            Assertions.assertEquals((Object)expectedHeaders.getValue(header.getName()), (Object)header.getValue());
        }
    }

    private static Stream<Arguments> headersSupplier() throws NoSuchMethodException {
        Class<HeaderMethods> clazz = HeaderMethods.class;
        return Stream.of(Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("noHeaders", new Class[0]), new HttpHeaders()}), Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("malformedHeaders", new Class[0]), new HttpHeaders()}), Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("headers", new Class[0]), new HttpHeaders().set("name1", "value1").set("name2", "value2").set("name3", "value3")}), Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("sameKeyTwiceLastWins", new Class[0]), new HttpHeaders().set("name", "value2")}));
    }

    @ParameterizedTest
    @MethodSource(value={"hostSubstitutionSupplier"})
    public void hostSubstitution(Method method, String rawHost, Object[] arguments, String expectedUrl) {
        SwaggerMethodParser swaggerMethodParser = new SwaggerMethodParser(method, rawHost);
        UrlBuilder urlBuilder = new UrlBuilder();
        swaggerMethodParser.setSchemeAndHost(arguments, urlBuilder);
        Assertions.assertEquals((Object)expectedUrl, (Object)urlBuilder.toString());
    }

    private static Stream<Arguments> hostSubstitutionSupplier() throws NoSuchMethodException {
        String sub1RawHost = "https://{sub1}.host.com";
        String sub2RawHost = "https://{sub2}.host.com";
        Class<HostSubstitutionMethods> clazz = HostSubstitutionMethods.class;
        Method noSubstitutions = clazz.getDeclaredMethod("noSubstitutions", String.class);
        Method substitution = clazz.getDeclaredMethod("substitution", String.class);
        Method encodingSubstitution = clazz.getDeclaredMethod("encodingSubstitution", String.class);
        return Stream.of(Arguments.of((Object[])new Object[]{noSubstitutions, sub1RawHost, SwaggerMethodParserTests.toObjectArray("raw"), "https://{sub1}.host.com"}), Arguments.of((Object[])new Object[]{noSubstitutions, sub2RawHost, SwaggerMethodParserTests.toObjectArray("raw"), "https://{sub2}.host.com"}), Arguments.of((Object[])new Object[]{substitution, sub1RawHost, SwaggerMethodParserTests.toObjectArray("raw"), "https://raw.host.com"}), Arguments.of((Object[])new Object[]{substitution, sub1RawHost, SwaggerMethodParserTests.toObjectArray("{sub1}"), "https://{sub1}.host.com"}), Arguments.of((Object[])new Object[]{substitution, sub1RawHost, SwaggerMethodParserTests.toObjectArray(new Object[]{null}), "https://.host.com"}), Arguments.of((Object[])new Object[]{substitution, sub1RawHost, null, "https://{sub1}.host.com"}), Arguments.of((Object[])new Object[]{substitution, sub2RawHost, SwaggerMethodParserTests.toObjectArray("raw"), "https://{sub2}.host.com"}), Arguments.of((Object[])new Object[]{encodingSubstitution, sub1RawHost, SwaggerMethodParserTests.toObjectArray("raw"), "https://raw.host.com"}), Arguments.of((Object[])new Object[]{encodingSubstitution, sub1RawHost, SwaggerMethodParserTests.toObjectArray("{sub1}"), "https://%7Bsub1%7D.host.com"}), Arguments.of((Object[])new Object[]{encodingSubstitution, sub1RawHost, SwaggerMethodParserTests.toObjectArray(new Object[]{null}), "https://.host.com"}), Arguments.of((Object[])new Object[]{substitution, sub1RawHost, null, "https://{sub1}.host.com"}), Arguments.of((Object[])new Object[]{encodingSubstitution, sub2RawHost, SwaggerMethodParserTests.toObjectArray("raw"), "https://{sub2}.host.com"}));
    }

    @ParameterizedTest
    @MethodSource(value={"schemeSubstitutionSupplier"})
    public void schemeSubstitution(Method method, String rawHost, Object[] arguments, String expectedUrl) {
        SwaggerMethodParser swaggerMethodParser = new SwaggerMethodParser(method, rawHost);
        UrlBuilder urlBuilder = new UrlBuilder();
        swaggerMethodParser.setSchemeAndHost(arguments, urlBuilder);
        Assertions.assertEquals((Object)expectedUrl, (Object)urlBuilder.toString());
    }

    private static Stream<Arguments> schemeSubstitutionSupplier() throws NoSuchMethodException {
        String sub1RawHost = "{sub1}://raw.host.com";
        String sub2RawHost = "{sub2}://raw.host.com";
        Class<HostSubstitutionMethods> clazz = HostSubstitutionMethods.class;
        Method noSubstitutions = clazz.getDeclaredMethod("noSubstitutions", String.class);
        Method substitution = clazz.getDeclaredMethod("substitution", String.class);
        Method encodingSubstitution = clazz.getDeclaredMethod("encodingSubstitution", String.class);
        return Stream.of(Arguments.of((Object[])new Object[]{noSubstitutions, sub1RawHost, SwaggerMethodParserTests.toObjectArray("raw"), "raw.host.com"}), Arguments.of((Object[])new Object[]{noSubstitutions, sub2RawHost, SwaggerMethodParserTests.toObjectArray("raw"), "raw.host.com"}), Arguments.of((Object[])new Object[]{substitution, sub1RawHost, SwaggerMethodParserTests.toObjectArray("http"), "http://raw.host.com"}), Arguments.of((Object[])new Object[]{substitution, sub1RawHost, SwaggerMethodParserTests.toObjectArray("\u0125ttps"), "\u0125ttps://raw.host.com"}), Arguments.of((Object[])new Object[]{substitution, sub1RawHost, SwaggerMethodParserTests.toObjectArray(new Object[]{null}), "raw.host.com"}), Arguments.of((Object[])new Object[]{substitution, sub1RawHost, null, "raw.host.com"}), Arguments.of((Object[])new Object[]{substitution, sub2RawHost, SwaggerMethodParserTests.toObjectArray("raw"), "raw.host.com"}), Arguments.of((Object[])new Object[]{encodingSubstitution, sub1RawHost, SwaggerMethodParserTests.toObjectArray("http"), "http://raw.host.com"}), Arguments.of((Object[])new Object[]{encodingSubstitution, sub1RawHost, SwaggerMethodParserTests.toObjectArray("\u0125ttps"), "raw.host.com"}), Arguments.of((Object[])new Object[]{encodingSubstitution, sub1RawHost, SwaggerMethodParserTests.toObjectArray(new Object[]{null}), "raw.host.com"}), Arguments.of((Object[])new Object[]{substitution, sub1RawHost, null, "raw.host.com"}), Arguments.of((Object[])new Object[]{encodingSubstitution, sub2RawHost, SwaggerMethodParserTests.toObjectArray("raw"), "raw.host.com"}));
    }

    @ParameterizedTest
    @MethodSource(value={"pathSubstitutionSupplier"})
    public void pathSubstitution(Method method, Object[] arguments, String expectedPath) {
        SwaggerMethodParser swaggerMethodParser = new SwaggerMethodParser(method, "https://raw.host.com");
        Assertions.assertEquals((Object)expectedPath, (Object)swaggerMethodParser.setPath(arguments));
    }

    private static Stream<Arguments> pathSubstitutionSupplier() throws NoSuchMethodException {
        Class<PathSubstitutionMethods> clazz = PathSubstitutionMethods.class;
        Method noSubstitutions = clazz.getDeclaredMethod("noSubstitutions", String.class);
        Method substitution = clazz.getDeclaredMethod("substitution", String.class);
        Method encodedSubstitution = clazz.getDeclaredMethod("encodedSubstitution", String.class);
        return Stream.of(Arguments.of((Object[])new Object[]{noSubstitutions, SwaggerMethodParserTests.toObjectArray("path"), "{sub1}"}), Arguments.of((Object[])new Object[]{encodedSubstitution, SwaggerMethodParserTests.toObjectArray("path"), "path"}), Arguments.of((Object[])new Object[]{encodedSubstitution, SwaggerMethodParserTests.toObjectArray("{sub1}"), "{sub1}"}), Arguments.of((Object[])new Object[]{encodedSubstitution, SwaggerMethodParserTests.toObjectArray(new Object[]{null}), ""}), Arguments.of((Object[])new Object[]{substitution, SwaggerMethodParserTests.toObjectArray("path"), "path"}), Arguments.of((Object[])new Object[]{substitution, SwaggerMethodParserTests.toObjectArray("{sub1}"), "%7Bsub1%7D"}), Arguments.of((Object[])new Object[]{substitution, SwaggerMethodParserTests.toObjectArray(new Object[]{null}), ""}));
    }

    @ParameterizedTest
    @MethodSource(value={"querySubstitutionSupplier"})
    public void querySubstitution(Method method, Object[] arguments, String expectedUrl) {
        SwaggerMethodParser swaggerMethodParser = new SwaggerMethodParser(method, "https://raw.host.com");
        UrlBuilder urlBuilder = UrlBuilder.parse((String)"https://raw.host.com");
        swaggerMethodParser.setEncodedQueryParameters(arguments, urlBuilder);
        Assertions.assertEquals((Object)expectedUrl, (Object)urlBuilder.toString());
    }

    private static Stream<Arguments> querySubstitutionSupplier() throws NoSuchMethodException {
        Class<QuerySubstitutionMethods> clazz = QuerySubstitutionMethods.class;
        Method substitution = clazz.getDeclaredMethod("substitutions", String.class, Boolean.TYPE);
        Method encodedSubstitution = clazz.getDeclaredMethod("encodedSubstitutions", String.class, Boolean.TYPE);
        return Stream.of(Arguments.of((Object[])new Object[]{substitution, null, "https://raw.host.com"}), Arguments.of((Object[])new Object[]{substitution, SwaggerMethodParserTests.toObjectArray("raw", true), "https://raw.host.com?sub1=raw&sub2=true"}), Arguments.of((Object[])new Object[]{substitution, SwaggerMethodParserTests.toObjectArray(null, true), "https://raw.host.com?sub2=true"}), Arguments.of((Object[])new Object[]{substitution, SwaggerMethodParserTests.toObjectArray("{sub1}", false), "https://raw.host.com?sub1=%7Bsub1%7D&sub2=false"}), Arguments.of((Object[])new Object[]{encodedSubstitution, null, "https://raw.host.com"}), Arguments.of((Object[])new Object[]{encodedSubstitution, SwaggerMethodParserTests.toObjectArray("raw", true), "https://raw.host.com?sub1=raw&sub2=true"}), Arguments.of((Object[])new Object[]{encodedSubstitution, SwaggerMethodParserTests.toObjectArray(null, true), "https://raw.host.com?sub2=true"}), Arguments.of((Object[])new Object[]{encodedSubstitution, SwaggerMethodParserTests.toObjectArray("{sub1}", false), "https://raw.host.com?sub1={sub1}&sub2=false"}));
    }

    @ParameterizedTest
    @MethodSource(value={"headerSubstitutionSupplier"})
    public void headerSubstitution(Method method, Object[] arguments, Map<String, String> expectedHeaders) {
        SwaggerMethodParser swaggerMethodParser = new SwaggerMethodParser(method, "https://raw.host.com");
        HttpHeaders actual = new HttpHeaders();
        swaggerMethodParser.setHeaders(arguments, actual);
        for (HttpHeader header : actual) {
            Assertions.assertEquals((Object)expectedHeaders.get(header.getName()), (Object)header.getValue());
        }
    }

    private static Stream<Arguments> headerSubstitutionSupplier() throws NoSuchMethodException {
        Class<HeaderSubstitutionMethods> clazz = HeaderSubstitutionMethods.class;
        Method addHeaders = clazz.getDeclaredMethod("addHeaders", String.class, Boolean.TYPE);
        Method overrideHeaders = clazz.getDeclaredMethod("overrideHeaders", String.class, Boolean.TYPE);
        Method headerMap = clazz.getDeclaredMethod("headerMap", Map.class);
        Map<String, String> simpleHeaderMap = Collections.singletonMap("key", "value");
        Map<String, String> expectedSimpleHeadersMap = Collections.singletonMap("x-ms-meta-key", "value");
        Map complexHeaderMap = new HttpHeaders().set("key1", (String)null).set("key2", "value2").toMap();
        Map<String, String> expectedComplexHeaderMap = Collections.singletonMap("x-ms-meta-key2", "value2");
        return Stream.of(Arguments.of((Object[])new Object[]{addHeaders, null, null}), Arguments.of((Object[])new Object[]{addHeaders, SwaggerMethodParserTests.toObjectArray("header", true), SwaggerMethodParserTests.createExpectedParameters("header", true)}), Arguments.of((Object[])new Object[]{addHeaders, SwaggerMethodParserTests.toObjectArray(null, true), SwaggerMethodParserTests.createExpectedParameters(null, true)}), Arguments.of((Object[])new Object[]{addHeaders, SwaggerMethodParserTests.toObjectArray("{sub1}", false), SwaggerMethodParserTests.createExpectedParameters("{sub1}", false)}), Arguments.of((Object[])new Object[]{overrideHeaders, null, SwaggerMethodParserTests.createExpectedParameters("sub1", false)}), Arguments.of((Object[])new Object[]{overrideHeaders, SwaggerMethodParserTests.toObjectArray(null, true), SwaggerMethodParserTests.createExpectedParameters("sub1", true)}), Arguments.of((Object[])new Object[]{overrideHeaders, SwaggerMethodParserTests.toObjectArray("header", false), SwaggerMethodParserTests.createExpectedParameters("header", false)}), Arguments.of((Object[])new Object[]{overrideHeaders, SwaggerMethodParserTests.toObjectArray("{sub1}", true), SwaggerMethodParserTests.createExpectedParameters("{sub1}", true)}), Arguments.of((Object[])new Object[]{headerMap, null, null}), Arguments.of((Object[])new Object[]{headerMap, SwaggerMethodParserTests.toObjectArray(simpleHeaderMap), expectedSimpleHeadersMap}), Arguments.of((Object[])new Object[]{headerMap, SwaggerMethodParserTests.toObjectArray(complexHeaderMap), expectedComplexHeaderMap}));
    }

    @ParameterizedTest
    @MethodSource(value={"bodySubstitutionSupplier"})
    public void bodySubstitution(Method method, Object[] arguments, String expectedBodyContentType, Object expectedBody) {
        SwaggerMethodParser swaggerMethodParser = new SwaggerMethodParser(method, "https://raw.host.com");
        Assertions.assertEquals(Void.TYPE, (Object)swaggerMethodParser.getReturnType());
        Assertions.assertEquals(String.class, (Object)swaggerMethodParser.getBodyJavaType());
        Assertions.assertEquals((Object)expectedBodyContentType, (Object)swaggerMethodParser.getBodyContentType());
        Assertions.assertEquals((Object)expectedBody, (Object)swaggerMethodParser.setBody(arguments));
    }

    private static Stream<Arguments> bodySubstitutionSupplier() throws NoSuchMethodException {
        Class<BodySubstitutionMethods> clazz = BodySubstitutionMethods.class;
        Method jsonBody = clazz.getDeclaredMethod("applicationJsonBody", String.class);
        Method formBody = clazz.getDeclaredMethod("formBody", String.class, Integer.class, OffsetDateTime.class, List.class);
        Method encodedFormBody = clazz.getDeclaredMethod("encodedFormBody", String.class, Integer.class, OffsetDateTime.class, List.class);
        Method encodedFormKey = clazz.getDeclaredMethod("encodedFormKey", String.class);
        Method encodedFormKey2 = clazz.getDeclaredMethod("encodedFormKey2", String.class);
        OffsetDateTime dob = OffsetDateTime.of(1980, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        List<String> favoriteColors = Arrays.asList("blue", "green");
        List<String> badFavoriteColors = Arrays.asList(null, "green");
        return Stream.of(Arguments.of((Object[])new Object[]{jsonBody, null, "application/json", null}), Arguments.of((Object[])new Object[]{jsonBody, SwaggerMethodParserTests.toObjectArray("{name:John Doe,age:40,dob:01-01-1980}"), "application/json", "{name:John Doe,age:40,dob:01-01-1980}"}), Arguments.of((Object[])new Object[]{formBody, null, "application/x-www-form-urlencoded", null}), Arguments.of((Object[])new Object[]{formBody, SwaggerMethodParserTests.toObjectArray("John Doe", null, dob, null), "application/x-www-form-urlencoded", "name=John+Doe&dob=1980-01-01T00%3A00%3A00Z"}), Arguments.of((Object[])new Object[]{formBody, SwaggerMethodParserTests.toObjectArray("John Doe", 40, null, favoriteColors), "application/x-www-form-urlencoded", "name=John+Doe&age=40&favoriteColors=blue&favoriteColors=green"}), Arguments.of((Object[])new Object[]{formBody, SwaggerMethodParserTests.toObjectArray("John Doe", 40, null, badFavoriteColors), "application/x-www-form-urlencoded", "name=John+Doe&age=40&favoriteColors=green"}), Arguments.of((Object[])new Object[]{encodedFormBody, null, "application/x-www-form-urlencoded", null}), Arguments.of((Object[])new Object[]{encodedFormBody, SwaggerMethodParserTests.toObjectArray("John Doe", null, dob, null), "application/x-www-form-urlencoded", "name=John Doe&dob=1980-01-01T00%3A00%3A00Z"}), Arguments.of((Object[])new Object[]{encodedFormBody, SwaggerMethodParserTests.toObjectArray("John Doe", 40, null, favoriteColors), "application/x-www-form-urlencoded", "name=John Doe&age=40&favoriteColors=blue&favoriteColors=green"}), Arguments.of((Object[])new Object[]{encodedFormBody, SwaggerMethodParserTests.toObjectArray("John Doe", 40, null, badFavoriteColors), "application/x-www-form-urlencoded", "name=John Doe&age=40&favoriteColors=green"}), Arguments.of((Object[])new Object[]{encodedFormKey, SwaggerMethodParserTests.toObjectArray("value"), "application/x-www-form-urlencoded", "x%3Ams%3Avalue=value"}), Arguments.of((Object[])new Object[]{encodedFormKey2, SwaggerMethodParserTests.toObjectArray("value"), "application/x-www-form-urlencoded", "x%3Ams%3Avalue=value"}));
    }

    @ParameterizedTest
    @MethodSource(value={"setContextSupplier"})
    public void setContext(SwaggerMethodParser swaggerMethodParser, Object[] arguments, Context expectedContext) {
        Assertions.assertEquals((Object)expectedContext, (Object)swaggerMethodParser.setContext(arguments));
    }

    @ParameterizedTest
    @MethodSource(value={"setRequestOptionsSupplier"})
    public void setRequestOptions(SwaggerMethodParser swaggerMethodParser, Object[] arguments, RequestOptions expectedRequestOptions) {
        Assertions.assertEquals((Object)expectedRequestOptions, (Object)swaggerMethodParser.setRequestOptions(arguments));
    }

    private static Stream<Arguments> setContextSupplier() throws NoSuchMethodException {
        Method method = OperationMethods.class.getDeclaredMethod("getMethod", new Class[0]);
        SwaggerMethodParser swaggerMethodParser = new SwaggerMethodParser(method, "https://raw.host.com");
        Context context = new Context((Object)"key", (Object)"value");
        return Stream.of(Arguments.of((Object[])new Object[]{swaggerMethodParser, null, Context.NONE}), Arguments.of((Object[])new Object[]{swaggerMethodParser, SwaggerMethodParserTests.toObjectArray(new Object[0]), Context.NONE}), Arguments.of((Object[])new Object[]{swaggerMethodParser, SwaggerMethodParserTests.toObjectArray("string"), Context.NONE}), Arguments.of((Object[])new Object[]{swaggerMethodParser, SwaggerMethodParserTests.toObjectArray(context), context}));
    }

    private static Stream<Arguments> setRequestOptionsSupplier() throws NoSuchMethodException {
        Method method = OperationMethods.class.getDeclaredMethod("getMethod", new Class[0]);
        SwaggerMethodParser swaggerMethodParser = new SwaggerMethodParser(method, "https://raw.host.com");
        RequestOptions bodyOptions = new RequestOptions().setBody(BinaryData.fromString((String)"{\"id\":\"123\"}"));
        RequestOptions headerQueryOptions = new RequestOptions().addHeader("x-ms-foo", "bar").addQueryParam("foo", "bar");
        RequestOptions urlOptions = new RequestOptions().addRequestCallback(httpRequest -> httpRequest.setUrl("https://foo.host.com"));
        RequestOptions statusOptionOptions = new RequestOptions().setThrowOnError(false);
        return Stream.of(Arguments.of((Object[])new Object[]{swaggerMethodParser, null, null}), Arguments.of((Object[])new Object[]{swaggerMethodParser, SwaggerMethodParserTests.toObjectArray(new Object[0]), null}), Arguments.of((Object[])new Object[]{swaggerMethodParser, SwaggerMethodParserTests.toObjectArray("string"), null}), Arguments.of((Object[])new Object[]{swaggerMethodParser, SwaggerMethodParserTests.toObjectArray(bodyOptions), bodyOptions}), Arguments.of((Object[])new Object[]{swaggerMethodParser, SwaggerMethodParserTests.toObjectArray("string", headerQueryOptions), headerQueryOptions}), Arguments.of((Object[])new Object[]{swaggerMethodParser, SwaggerMethodParserTests.toObjectArray("string1", "string2", urlOptions), urlOptions}), Arguments.of((Object[])new Object[]{swaggerMethodParser, SwaggerMethodParserTests.toObjectArray(statusOptionOptions), statusOptionOptions}));
    }

    @ParameterizedTest
    @MethodSource(value={"expectedStatusCodeSupplier"})
    public void expectedStatusCodeSupplier(Method method, int statusCode, int[] expectedStatusCodes, boolean matchesExpected) {
        SwaggerMethodParser swaggerMethodParser = new SwaggerMethodParser(method, "https://raw.host.com");
        if (expectedStatusCodes != null) {
            for (int expectedCode : expectedStatusCodes) {
                Assertions.assertTrue((boolean)swaggerMethodParser.isExpectedResponseStatusCode(expectedCode));
            }
        }
        Assertions.assertEquals((Object)matchesExpected, (Object)swaggerMethodParser.isExpectedResponseStatusCode(statusCode));
    }

    private static Stream<Arguments> expectedStatusCodeSupplier() throws NoSuchMethodException {
        Class<ExpectedStatusCodeMethods> clazz = ExpectedStatusCodeMethods.class;
        return Stream.of(Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("noExpectedStatusCodes", new Class[0]), 200, null, true}), Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("noExpectedStatusCodes", new Class[0]), 201, null, true}), Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("noExpectedStatusCodes", new Class[0]), 400, null, false}), Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("only200IsExpected", new Class[0]), 200, new int[]{200}, true}), Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("only200IsExpected", new Class[0]), 201, new int[]{200}, false}), Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("only200IsExpected", new Class[0]), 400, new int[]{200}, false}), Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("retryAfterExpected", new Class[0]), 200, new int[]{429, 503}, false}), Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("retryAfterExpected", new Class[0]), 201, new int[]{429, 503}, false}), Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("retryAfterExpected", new Class[0]), 400, new int[]{429, 503}, false}), Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("retryAfterExpected", new Class[0]), 429, new int[]{429, 503}, true}), Arguments.of((Object[])new Object[]{clazz.getDeclaredMethod("retryAfterExpected", new Class[0]), 503, new int[]{429, 503}, true}));
    }

    @ParameterizedTest
    @MethodSource(value={"unexpectedStatusCodeSupplier"})
    public void unexpectedStatusCode(Method method, int statusCode, Class<?> expectedExceptionType) {
        SwaggerMethodParser swaggerMethodParser = new SwaggerMethodParser(method, "https://raw.host.com");
        Assertions.assertEquals(expectedExceptionType, (Object)swaggerMethodParser.getUnexpectedException(statusCode).getExceptionType());
    }

    private static Stream<Arguments> unexpectedStatusCodeSupplier() throws NoSuchMethodException {
        Class<UnexpectedStatusCodeMethods> clazz = UnexpectedStatusCodeMethods.class;
        Method noUnexpectedStatusCodes = clazz.getDeclaredMethod("noUnexpectedStatusCodes", new Class[0]);
        Method notFoundStatusCode = clazz.getDeclaredMethod("notFoundStatusCode", new Class[0]);
        Method customDefault = clazz.getDeclaredMethod("customDefault", new Class[0]);
        return Stream.of(Arguments.of((Object[])new Object[]{noUnexpectedStatusCodes, 500, HttpResponseException.class}), Arguments.of((Object[])new Object[]{noUnexpectedStatusCodes, 400, HttpResponseException.class}), Arguments.of((Object[])new Object[]{noUnexpectedStatusCodes, 404, HttpResponseException.class}), Arguments.of((Object[])new Object[]{notFoundStatusCode, 500, HttpResponseException.class}), Arguments.of((Object[])new Object[]{notFoundStatusCode, 400, ResourceNotFoundException.class}), Arguments.of((Object[])new Object[]{notFoundStatusCode, 404, ResourceNotFoundException.class}), Arguments.of((Object[])new Object[]{customDefault, 500, ResourceModifiedException.class}), Arguments.of((Object[])new Object[]{customDefault, 400, ResourceNotFoundException.class}), Arguments.of((Object[])new Object[]{customDefault, 404, ResourceNotFoundException.class}));
    }

    private static Object[] toObjectArray(Object ... objects) {
        return objects;
    }

    private static Map<String, String> createExpectedParameters(String sub1Value, boolean sub2Value) {
        HashMap<String, String> expectedParameters = new HashMap<String, String>();
        if (sub1Value != null) {
            expectedParameters.put("sub1", sub1Value);
        }
        expectedParameters.put("sub2", String.valueOf(sub2Value));
        return expectedParameters;
    }

    static interface UnexpectedStatusCodeMethods {
        @Get(value="test")
        public void noUnexpectedStatusCodes();

        @Get(value="test")
        @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={400, 404})
        public void notFoundStatusCode();

        @Get(value="test")
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={400, 404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class)})
        public void customDefault();
    }

    static interface ExpectedStatusCodeMethods {
        @Get(value="test")
        public void noExpectedStatusCodes();

        @Get(value="test")
        @ExpectedResponses(value={200})
        public void only200IsExpected();

        @Get(value="test")
        @ExpectedResponses(value={429, 503})
        public void retryAfterExpected();
    }

    static interface BodySubstitutionMethods {
        @Get(value="test")
        public void applicationJsonBody(@BodyParam(value="application/json") String var1);

        @Get(value="test")
        public void formBody(@FormParam(value="name") String var1, @FormParam(value="age") Integer var2, @FormParam(value="dob") OffsetDateTime var3, @FormParam(value="favoriteColors") List<String> var4);

        @Get(value="test")
        public void encodedFormBody(@FormParam(value="name", encoded=true) String var1, @FormParam(value="age") Integer var2, @FormParam(value="dob") OffsetDateTime var3, @FormParam(value="favoriteColors") List<String> var4);

        @Get(value="test")
        public void encodedFormKey(@FormParam(value="x:ms:value") String var1);

        @Get(value="test")
        public void encodedFormKey2(@FormParam(value="x:ms:value", encoded=true) String var1);
    }

    static interface HeaderSubstitutionMethods {
        @Get(value="test")
        public void addHeaders(@HeaderParam(value="sub1") String var1, @HeaderParam(value="sub2") boolean var2);

        @Get(value="test")
        @Headers(value={"sub1:sub1", "sub2:false"})
        public void overrideHeaders(@HeaderParam(value="sub1") String var1, @HeaderParam(value="sub2") boolean var2);

        @Get(value="test")
        public void headerMap(@HeaderParam(value="x-ms-meta-") Map<String, String> var1);
    }

    static interface QuerySubstitutionMethods {
        @Get(value="test")
        public void substitutions(@QueryParam(value="sub1") String var1, @QueryParam(value="sub2") boolean var2);

        @Get(value="test")
        public void encodedSubstitutions(@QueryParam(value="sub1", encoded=true) String var1, @QueryParam(value="sub2", encoded=true) boolean var2);
    }

    static interface PathSubstitutionMethods {
        @Get(value="{sub1}")
        public void noSubstitutions(String var1);

        @Get(value="{sub1}")
        public void substitution(@PathParam(value="sub1") String var1);

        @Get(value="{sub1}")
        public void encodedSubstitution(@PathParam(value="sub1", encoded=true) String var1);
    }

    static interface HostSubstitutionMethods {
        @Get(value="test")
        public void noSubstitutions(String var1);

        @Get(value="test")
        public void substitution(@HostParam(value="sub1") String var1);

        @Get(value="test")
        public void encodingSubstitution(@HostParam(value="sub1", encoded=false) String var1);
    }

    static interface HeaderMethods {
        @Get(value="test")
        public void noHeaders();

        @Get(value="test")
        @Headers(value={"", ":", "nameOnly:", ":valueOnly"})
        public void malformedHeaders();

        @Get(value="test")
        @Headers(value={"name1:value1", " name2: value2", "name3 :value3 "})
        public void headers();

        @Get(value="test")
        @Headers(value={"name:value1", "name:value2"})
        public void sameKeyTwiceLastWins();
    }

    static interface WireTypesMethods {
        @Get(value="test")
        public void noWireType();

        @Get(value="test")
        @ReturnValueWireType(value=Base64Url.class)
        public void base64Url();

        @Get(value="test")
        @ReturnValueWireType(value=UnixTime.class)
        public void unixTime();

        @Get(value="test")
        @ReturnValueWireType(value=DateTimeRfc1123.class)
        public void dateTimeRfc1123();

        @Get(value="test")
        @ReturnValueWireType(value=Page.class)
        public void page();

        @Get(value="test")
        @ReturnValueWireType(value=Boolean.class)
        public void unknownType();
    }

    static interface OperationMethods {
        public void noMethod();

        @Get(value="test")
        public void getMethod();

        @Put(value="test")
        public void putMethod();

        @Head(value="test")
        public void headMethod();

        @Delete(value="test")
        public void deleteMethod();

        @Post(value="test")
        public void postMethod();

        @Patch(value="test")
        public void patchMethod();
    }
}

