/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.implementation.ByteBufferCollector;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ByteBufferCollectorTests {
    @Test
    public void throwsOnZeroInitialSize() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ByteBufferCollector(0));
    }

    @Test
    public void throwsOnNegativeInitialSize() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ByteBufferCollector(-1));
    }

    @Test
    public void throwsIllegalStateExceptionOnBufferRequirementTooLarge() {
        Assumptions.assumeTrue(((double)Runtime.getRuntime().maxMemory() > 3.2212254705E9 ? 1 : 0) != 0, (String)"JVM doesn't have the requisite max heap size to support running this test.");
        ByteBuffer buffer = ByteBuffer.allocate(0x40000000);
        ByteBufferCollector collector = new ByteBufferCollector();
        collector.write(buffer.duplicate());
        Assertions.assertThrows(IllegalStateException.class, () -> collector.write(buffer.duplicate()));
    }

    @ParameterizedTest
    @MethodSource(value={"combineBuffersSupplier"})
    public void combineBuffers(List<ByteBuffer> buffers, byte[] expected) {
        ByteBufferCollector collector = new ByteBufferCollector();
        buffers.forEach(arg_0 -> ((ByteBufferCollector)collector).write(arg_0));
        Assertions.assertArrayEquals((byte[])expected, (byte[])collector.toByteArray());
    }

    private static Stream<Arguments> combineBuffersSupplier() {
        byte[] helloWorldBytes = "Hello world!".getBytes(StandardCharsets.UTF_8);
        ByteBuffer helloBuffer = ByteBuffer.wrap("Hello".getBytes(StandardCharsets.UTF_8));
        ByteBuffer worldBuffer = ByteBuffer.wrap(" world!".getBytes(StandardCharsets.UTF_8));
        int helloWorldLength = helloWorldBytes.length;
        byte[] manyHelloWorldsBytes = new byte[helloWorldLength * 100];
        ArrayList<ByteBuffer> manyHelloWorldsByteBuffers = new ArrayList<ByteBuffer>();
        for (int i = 0; i < 100; ++i) {
            System.arraycopy(helloWorldBytes, 0, manyHelloWorldsBytes, i * helloWorldLength, helloWorldLength);
            manyHelloWorldsByteBuffers.add(helloBuffer.duplicate());
            manyHelloWorldsByteBuffers.add(worldBuffer.duplicate());
        }
        return Stream.of(Arguments.of((Object[])new Object[]{Arrays.asList(null, null), new byte[0]}), Arguments.of((Object[])new Object[]{Arrays.asList(ByteBuffer.allocate(0), ByteBuffer.allocate(0)), new byte[0]}), Arguments.of((Object[])new Object[]{Arrays.asList(helloBuffer.duplicate(), worldBuffer.duplicate()), helloWorldBytes}), Arguments.of((Object[])new Object[]{manyHelloWorldsByteBuffers, manyHelloWorldsBytes}));
    }
}

