/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.implementation.FileWriteSubscriber;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.reactivestreams.Subscription;
import reactor.core.publisher.MonoSink;

public class FileWriteSubscriberTests {
    @Test
    public void multipleSubscriptionsCancelsLaterSubscriptions() {
        AsynchronousFileChannel channel = (AsynchronousFileChannel)Mockito.mock(AsynchronousFileChannel.class);
        ((AsynchronousFileChannel)Mockito.doAnswer(invocation -> {
            ByteBuffer stream = (ByteBuffer)invocation.getArgument(0);
            CompletionHandler handler = (CompletionHandler)invocation.getArgument(3);
            int remaining = stream.remaining();
            stream.position(stream.limit());
            handler.completed(remaining, stream);
            return null;
        }).when((Object)channel)).write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.any(), (CompletionHandler)ArgumentMatchers.any());
        MonoSink sink = (MonoSink)Mockito.mock(MonoSink.class);
        FileWriteSubscriber fileWriteSubscriber = new FileWriteSubscriber(channel, 0L, sink);
        Subscription subscription1 = (Subscription)Mockito.mock(Subscription.class);
        Subscription subscription2 = (Subscription)Mockito.mock(Subscription.class);
        fileWriteSubscriber.onSubscribe(subscription1);
        fileWriteSubscriber.onSubscribe(subscription2);
        ((Subscription)Mockito.verify((Object)subscription1, (VerificationMode)Mockito.times((int)1))).request(1L);
        ((Subscription)Mockito.verify((Object)subscription1, (VerificationMode)Mockito.never())).cancel();
        ((Subscription)Mockito.verify((Object)subscription2, (VerificationMode)Mockito.never())).request(1L);
        ((Subscription)Mockito.verify((Object)subscription2, (VerificationMode)Mockito.times((int)1))).cancel();
    }
}

