/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.implementation.Option;
import java.util.NoSuchElementException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OptionTests {
    @Test
    public void testOfNonNull() {
        Option setOption = Option.of((Object)1);
        Assertions.assertTrue((boolean)setOption.isInitialized());
        Assertions.assertEquals((int)1, (Integer)((Integer)setOption.getValue()));
    }

    @Test
    public void testOfNull() {
        Option setOption = Option.of(null);
        Assertions.assertTrue((boolean)setOption.isInitialized());
        Assertions.assertNull((Object)setOption.getValue());
    }

    @Test
    public void testEmpty() {
        Option emptyOption = Option.empty();
        Assertions.assertTrue((boolean)emptyOption.isInitialized());
        Assertions.assertNull((Object)emptyOption.getValue());
    }

    @Test
    public void testUninitialized() {
        Option uninitializedOption = Option.uninitialized();
        Assertions.assertFalse((boolean)uninitializedOption.isInitialized());
    }

    @Test
    public void testGetValueThrows() {
        Option uninitializedOption = Option.uninitialized();
        Assertions.assertThrows(NoSuchElementException.class, () -> ((Option)uninitializedOption).getValue());
    }

    @Test
    public void testHashCode() {
        Option uninitializedOption = Option.uninitialized();
        Assertions.assertEquals((int)-1, (int)uninitializedOption.hashCode());
        Option nullValueOption = Option.of(null);
        Assertions.assertEquals((int)0, (int)nullValueOption.hashCode());
        Integer val = 44;
        Option nonNullValueOption = Option.of((Object)val);
        Assertions.assertEquals((int)val.hashCode(), (int)nonNullValueOption.hashCode());
    }

    @Test
    public void testEqual() {
        Assertions.assertEquals((Object)Option.uninitialized(), (Object)Option.uninitialized());
        Assertions.assertEquals((Object)Option.of((Object)44), (Object)Option.of((Object)44));
        Assertions.assertEquals((Object)Option.of(null), (Object)Option.of(null));
        Assertions.assertNotEquals((Object)Option.uninitialized(), (Object)Option.of(null));
        Assertions.assertNotEquals((Object)Option.uninitialized(), (Object)Option.of((Object)44));
        Assertions.assertNotEquals((Object)Option.of(null), (Object)Option.of((Object)44));
        Assertions.assertNotEquals((Object)Option.of((Object)88), (Object)Option.of((Object)44));
    }
}

