/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.models.GeoBoundingBox;
import com.azure.core.models.GeoCollection;
import com.azure.core.models.GeoObject;
import com.azure.core.models.GeoTestHelpers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class GeoCollectionTests {
    @Test
    public void nullGeometriesThrows() {
        Assertions.assertThrows(NullPointerException.class, () -> new GeoCollection(null));
    }

    @Test
    public void simpleConstructor() {
        List<GeoObject> geometries = Arrays.asList((GeoObject)GeoTestHelpers.SQUARE_LINE.get(), (GeoObject)GeoTestHelpers.SQUARE_POLYGON.get());
        GeoCollection collection = new GeoCollection(geometries);
        Assertions.assertEquals(geometries, (Object)collection.getGeometries());
        Assertions.assertNull((Object)collection.getBoundingBox());
        Assertions.assertNull((Object)collection.getCustomProperties());
    }

    @Test
    public void complexConstructor() {
        List<GeoObject> geometries = Arrays.asList((GeoObject)GeoTestHelpers.SQUARE_LINE.get(), (GeoObject)GeoTestHelpers.SQUARE_POLYGON.get());
        GeoBoundingBox boundingBox = new GeoBoundingBox(0.0, 0.0, 1.0, 1.0);
        Map<String, String> properties = Collections.singletonMap("key", "value");
        GeoCollection collection = new GeoCollection(geometries, boundingBox, properties);
        Assertions.assertEquals(geometries, (Object)collection.getGeometries());
        Assertions.assertEquals((Object)boundingBox, (Object)collection.getBoundingBox());
        Assertions.assertEquals(properties, (Object)collection.getCustomProperties());
    }

    @Test
    public void constructorCopiesGeometries() {
        ArrayList<GeoObject> geometries = new ArrayList<GeoObject>();
        geometries.add((GeoObject)GeoTestHelpers.SQUARE_LINE.get());
        geometries.add((GeoObject)GeoTestHelpers.SQUARE_POLYGON.get());
        GeoCollection collection = new GeoCollection(geometries);
        Assertions.assertEquals(geometries, (Object)collection.getGeometries());
        geometries.add((GeoObject)GeoTestHelpers.TRIANGLE_LINE.get());
        Assertions.assertNotEquals(geometries, (Object)collection.getGeometries());
    }

    @ParameterizedTest
    @MethodSource(value={"equalsSupplier"})
    public void collectionGeometriesEquals(GeoCollection collection, Object obj, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)collection.equals(obj));
    }

    private static Stream<Arguments> equalsSupplier() {
        List<GeoObject> geometries = Arrays.asList((GeoObject)GeoTestHelpers.SQUARE_LINE.get(), (GeoObject)GeoTestHelpers.SQUARE_POLYGON.get());
        List<GeoObject> geometries1 = Arrays.asList((GeoObject)GeoTestHelpers.RECTANGLE_LINE.get(), (GeoObject)GeoTestHelpers.RECTANGLE_POLYGON.get());
        GeoBoundingBox boundingBox = new GeoBoundingBox(0.0, 0.0, 2.0, 2.0);
        Map<String, String> properties = Collections.singletonMap("key", "value");
        GeoCollection collection = new GeoCollection(geometries);
        GeoCollection collection1 = new GeoCollection(geometries1, boundingBox, properties);
        return Stream.of(Arguments.of((Object[])new Object[]{collection, null, false}), Arguments.of((Object[])new Object[]{collection, 1, false}), Arguments.of((Object[])new Object[]{collection, collection, true}), Arguments.of((Object[])new Object[]{collection1, collection1, true}), Arguments.of((Object[])new Object[]{collection, collection1, false}), Arguments.of((Object[])new Object[]{collection1, collection, false}), Arguments.of((Object[])new Object[]{collection, new GeoCollection(geometries), true}), Arguments.of((Object[])new Object[]{collection1, new GeoCollection(geometries1, boundingBox, properties), true}));
    }
}

