/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.models.GeoArray;
import com.azure.core.models.GeoBoundingBox;
import com.azure.core.models.GeoLineString;
import com.azure.core.models.GeoPosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class GeoLineStringTests {
    @Test
    public void nullPositionsThrows() {
        Assertions.assertThrows(NullPointerException.class, () -> new GeoLineString(null));
    }

    @Test
    public void simpleConstructor() {
        GeoArray expectedPositions = new GeoArray(Arrays.asList(new GeoPosition(0.0, 0.0), new GeoPosition(0.0, 1.0)));
        GeoLineString line = new GeoLineString((List)expectedPositions);
        Assertions.assertEquals((Object)expectedPositions, (Object)line.getCoordinates());
        Assertions.assertNull((Object)line.getBoundingBox());
        Assertions.assertNull((Object)line.getCustomProperties());
    }

    @Test
    public void complexConstructor() {
        GeoArray expectedPositions = new GeoArray(Arrays.asList(new GeoPosition(0.0, 0.0), new GeoPosition(0.0, 1.0)));
        GeoBoundingBox expectedBoundingBox = new GeoBoundingBox(0.0, 0.0, 1.0, 1.0);
        Map<String, String> expectedProperties = Collections.singletonMap("key", "value");
        GeoLineString line = new GeoLineString((List)expectedPositions, expectedBoundingBox, expectedProperties);
        Assertions.assertEquals((Object)expectedPositions, (Object)line.getCoordinates());
        Assertions.assertEquals((Object)expectedBoundingBox, (Object)line.getBoundingBox());
        Assertions.assertEquals(expectedProperties, (Object)line.getCustomProperties());
    }

    @Test
    public void constructorCopiesPositions() {
        ArrayList<GeoPosition> expectedPositions = new ArrayList<GeoPosition>();
        expectedPositions.add(new GeoPosition(0.0, 0.0));
        expectedPositions.add(new GeoPosition(0.0, 1.0));
        GeoLineString line = new GeoLineString(expectedPositions);
        Assertions.assertEquals((Object)new GeoArray(expectedPositions), (Object)line.getCoordinates());
        expectedPositions.add(new GeoPosition(1.0, 1.0));
        Assertions.assertNotEquals((Object)new GeoArray(expectedPositions), (Object)line.getCoordinates());
    }

    @ParameterizedTest
    @MethodSource(value={"equalsSupplier"})
    public void lineGeometriesEqual(GeoLineString line, Object obj, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)line.equals(obj));
    }

    private static Stream<Arguments> equalsSupplier() {
        List<GeoPosition> positions = Arrays.asList(new GeoPosition(0.0, 0.0), new GeoPosition(0.0, 1.0));
        List<GeoPosition> positions1 = Arrays.asList(new GeoPosition(0.0, 0.0), new GeoPosition(1.0, 1.0));
        GeoBoundingBox boundingBox = new GeoBoundingBox(0.0, 0.0, 1.0, 1.0);
        Map<String, String> properties = Collections.singletonMap("key", "value");
        GeoLineString line = new GeoLineString(positions);
        GeoLineString line1 = new GeoLineString(positions1, boundingBox, properties);
        return Stream.of(Arguments.of((Object[])new Object[]{line, null, false}), Arguments.of((Object[])new Object[]{line, 1, false}), Arguments.of((Object[])new Object[]{line, line, true}), Arguments.of((Object[])new Object[]{line1, line1, true}), Arguments.of((Object[])new Object[]{line, line1, false}), Arguments.of((Object[])new Object[]{line1, line, false}), Arguments.of((Object[])new Object[]{line, new GeoLineString(positions), true}), Arguments.of((Object[])new Object[]{line1, new GeoLineString(positions1, boundingBox, properties), true}));
    }
}

