/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.models.GeoBoundingBox;
import com.azure.core.models.GeoPoint;
import com.azure.core.models.GeoPosition;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class GeoPointTests {
    @Test
    public void nullPositionThrows() {
        Assertions.assertThrows(NullPointerException.class, () -> new GeoPoint(null));
    }

    @Test
    public void simpleConstructor() {
        GeoPosition position = new GeoPosition(0.0, 0.0);
        GeoPoint point = new GeoPoint(position);
        Assertions.assertEquals((Object)position, (Object)point.getCoordinates());
        Assertions.assertNull((Object)point.getBoundingBox());
        Assertions.assertNull((Object)point.getCustomProperties());
    }

    @Test
    public void complexConstructor() {
        GeoPosition position = new GeoPosition(0.0, 0.0);
        GeoBoundingBox boundingBox = new GeoBoundingBox(0.0, 0.0, 1.0, 1.0);
        Map<String, String> properties = Collections.singletonMap("key", "value");
        GeoPoint point = new GeoPoint(position, boundingBox, properties);
        Assertions.assertEquals((Object)position, (Object)point.getCoordinates());
        Assertions.assertEquals((Object)boundingBox, (Object)point.getBoundingBox());
        Assertions.assertEquals(properties, (Object)point.getCustomProperties());
    }

    @ParameterizedTest
    @MethodSource(value={"equalsSupplier"})
    public void pointGeometriesEquals(GeoPoint point, Object obj, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)point.equals(obj));
    }

    private static Stream<Arguments> equalsSupplier() {
        GeoPosition position = new GeoPosition(0.0, 0.0);
        GeoPosition position1 = new GeoPosition(1.0, 1.0);
        GeoBoundingBox boundingBox = new GeoBoundingBox(0.0, 0.0, 1.0, 1.0);
        Map<String, String> properties = Collections.singletonMap("key", "value");
        GeoPoint point = new GeoPoint(position);
        GeoPoint point1 = new GeoPoint(position1, boundingBox, properties);
        return Stream.of(Arguments.of((Object[])new Object[]{point, null, false}), Arguments.of((Object[])new Object[]{point, 1, false}), Arguments.of((Object[])new Object[]{point, point, true}), Arguments.of((Object[])new Object[]{point1, point1, true}), Arguments.of((Object[])new Object[]{point, point1, false}), Arguments.of((Object[])new Object[]{point1, point, false}), Arguments.of((Object[])new Object[]{point, new GeoPoint(position), true}), Arguments.of((Object[])new Object[]{point1, new GeoPoint(position1, boundingBox, properties), true}));
    }
}

