/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.models.GeoBoundingBox;
import com.azure.core.models.GeoPolygon;
import com.azure.core.models.GeoPolygonCollection;
import com.azure.core.models.GeoTestHelpers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class GeoPolygonCollectionTests {
    @Test
    public void nullPolygonsThrows() {
        Assertions.assertThrows(NullPointerException.class, () -> new GeoPolygonCollection(null));
    }

    @Test
    public void simpleConstructor() {
        List<GeoPolygon> polygons = Arrays.asList(GeoTestHelpers.TRIANGLE_POLYGON.get(), GeoTestHelpers.SQUARE_POLYGON.get());
        GeoPolygonCollection multiPolygon = new GeoPolygonCollection(polygons);
        Assertions.assertEquals(polygons, (Object)multiPolygon.getPolygons());
        Assertions.assertNull((Object)multiPolygon.getBoundingBox());
        Assertions.assertNull((Object)multiPolygon.getCustomProperties());
    }

    @Test
    public void complexConstructor() {
        List<GeoPolygon> polygons = Arrays.asList(GeoTestHelpers.TRIANGLE_POLYGON.get(), GeoTestHelpers.SQUARE_POLYGON.get());
        GeoBoundingBox boundingBox = new GeoBoundingBox(0.0, 0.0, 1.0, 1.0);
        Map<String, String> properties = Collections.singletonMap("key", "value");
        GeoPolygonCollection multiPolygon = new GeoPolygonCollection(polygons, boundingBox, properties);
        Assertions.assertEquals(polygons, (Object)multiPolygon.getPolygons());
        Assertions.assertEquals((Object)boundingBox, (Object)multiPolygon.getBoundingBox());
        Assertions.assertEquals(properties, (Object)multiPolygon.getCustomProperties());
    }

    @Test
    public void constructorCopiesPolygons() {
        ArrayList<GeoPolygon> polygons = new ArrayList<GeoPolygon>();
        polygons.add(GeoTestHelpers.TRIANGLE_POLYGON.get());
        polygons.add(GeoTestHelpers.SQUARE_POLYGON.get());
        GeoPolygonCollection multiPolygon = new GeoPolygonCollection(polygons);
        Assertions.assertEquals(polygons, (Object)multiPolygon.getPolygons());
        polygons.add(GeoTestHelpers.RECTANGLE_POLYGON.get());
        Assertions.assertNotEquals(polygons, (Object)multiPolygon.getPolygons());
    }

    @ParameterizedTest
    @MethodSource(value={"equalsSupplier"})
    public void multiPolygonGeometriesEquals(GeoPolygonCollection multiPolygon, Object obj, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)multiPolygon.equals(obj));
    }

    private static Stream<Arguments> equalsSupplier() {
        List<GeoPolygon> polygons = Arrays.asList(GeoTestHelpers.TRIANGLE_POLYGON.get(), GeoTestHelpers.SQUARE_POLYGON.get());
        List<GeoPolygon> polygons1 = Arrays.asList(GeoTestHelpers.TRIANGLE_POLYGON.get(), GeoTestHelpers.RECTANGLE_POLYGON.get());
        GeoBoundingBox boundingBox = new GeoBoundingBox(0.0, 0.0, 2.0, 2.0);
        Map<String, String> properties = Collections.singletonMap("key", "value");
        GeoPolygonCollection multiPolygon = new GeoPolygonCollection(polygons);
        GeoPolygonCollection multiPolygon1 = new GeoPolygonCollection(polygons1, boundingBox, properties);
        return Stream.of(Arguments.of((Object[])new Object[]{multiPolygon, null, false}), Arguments.of((Object[])new Object[]{multiPolygon, 1, false}), Arguments.of((Object[])new Object[]{multiPolygon, multiPolygon, true}), Arguments.of((Object[])new Object[]{multiPolygon1, multiPolygon1, true}), Arguments.of((Object[])new Object[]{multiPolygon, multiPolygon1, false}), Arguments.of((Object[])new Object[]{multiPolygon1, multiPolygon, false}), Arguments.of((Object[])new Object[]{multiPolygon, new GeoPolygonCollection(polygons), true}), Arguments.of((Object[])new Object[]{multiPolygon1, new GeoPolygonCollection(polygons1, boundingBox, properties), true}));
    }
}

