/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.models.GeoBoundingBox;
import com.azure.core.models.GeoLinearRing;
import com.azure.core.models.GeoPolygon;
import com.azure.core.models.GeoTestHelpers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class GeoPolygonTests {
    @Test
    public void nullRingsThrows() {
        Assertions.assertThrows(NullPointerException.class, () -> new GeoPolygon((GeoLinearRing)null));
    }

    @Test
    public void simpleConstructor() {
        List<GeoLinearRing> rings = Collections.singletonList(new GeoLinearRing(GeoTestHelpers.SQUARE_LINE_POSITIONS));
        GeoPolygon polygon = new GeoPolygon(new GeoLinearRing(GeoTestHelpers.SQUARE_LINE.get().getCoordinates()));
        Assertions.assertEquals(rings, (Object)polygon.getRings());
        Assertions.assertNull((Object)polygon.getBoundingBox());
        Assertions.assertNull((Object)polygon.getCustomProperties());
    }

    @Test
    public void complexConstructor() {
        List<GeoLinearRing> rings = Collections.singletonList(new GeoLinearRing(GeoTestHelpers.SQUARE_LINE_POSITIONS));
        GeoBoundingBox boundingBox = new GeoBoundingBox(0.0, 0.0, 1.0, 1.0);
        Map<String, String> properties = Collections.singletonMap("key", "value");
        GeoPolygon polygon = new GeoPolygon(rings, boundingBox, properties);
        Assertions.assertEquals(rings, (Object)polygon.getRings());
        Assertions.assertEquals((Object)boundingBox, (Object)polygon.getBoundingBox());
        Assertions.assertEquals(properties, (Object)polygon.getCustomProperties());
    }

    @Test
    public void constructorCopiesRings() {
        ArrayList<GeoLinearRing> rings = new ArrayList<GeoLinearRing>();
        rings.add(new GeoLinearRing(GeoTestHelpers.SQUARE_LINE_POSITIONS));
        GeoPolygon polygon = new GeoPolygon(rings);
        Assertions.assertEquals(rings, (Object)polygon.getRings());
        rings.add(new GeoLinearRing(GeoTestHelpers.TRIANGLE_LINE_POSITIONS));
        Assertions.assertNotEquals(rings, (Object)polygon.getRings());
    }

    @ParameterizedTest
    @MethodSource(value={"equalsSupplier"})
    public void polygonGeometriesEquals(GeoPolygon polygon, Object obj, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)polygon.equals(obj));
    }

    private static Stream<Arguments> equalsSupplier() {
        GeoLinearRing squareLine = new GeoLinearRing(GeoTestHelpers.SQUARE_LINE_POSITIONS);
        GeoLinearRing triangleLine = new GeoLinearRing(GeoTestHelpers.TRIANGLE_LINE_POSITIONS);
        GeoBoundingBox boundingBox = new GeoBoundingBox(0.0, 0.0, 1.0, 1.0);
        Map<String, String> properties = Collections.singletonMap("key", "value");
        GeoPolygon polygon = new GeoPolygon(squareLine);
        GeoPolygon polygon1 = new GeoPolygon(triangleLine, boundingBox, properties);
        return Stream.of(Arguments.of((Object[])new Object[]{polygon, null, false}), Arguments.of((Object[])new Object[]{polygon, 1, false}), Arguments.of((Object[])new Object[]{polygon, polygon, true}), Arguments.of((Object[])new Object[]{polygon1, polygon1, true}), Arguments.of((Object[])new Object[]{polygon, polygon1, false}), Arguments.of((Object[])new Object[]{polygon1, polygon, false}), Arguments.of((Object[])new Object[]{polygon, new GeoPolygon(squareLine), true}), Arguments.of((Object[])new Object[]{polygon1, new GeoPolygon(triangleLine, boundingBox, properties), true}));
    }
}

