/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.models.GeoPosition;
import com.azure.core.models.GeoTestHelpers;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class GeoPositionTests {
    @Test
    public void simpleConstructor() {
        double expectedLongitude = -180.0;
        double expectedLatitude = -90.0;
        GeoPosition position = new GeoPosition(expectedLongitude, expectedLatitude);
        Assertions.assertEquals((double)expectedLongitude, (double)position.getLongitude());
        Assertions.assertEquals((double)expectedLatitude, (double)position.getLatitude());
        Assertions.assertNull((Object)position.getAltitude());
    }

    @Test
    public void complexConstructor() {
        double expectedLongitude = -180.0;
        double expectedLatitude = -90.0;
        double expectedAltitude = 1000.0;
        GeoPosition position = new GeoPosition(expectedLongitude, expectedLatitude, Double.valueOf(expectedAltitude));
        Assertions.assertEquals((double)expectedLongitude, (double)position.getLongitude());
        Assertions.assertEquals((double)expectedLatitude, (double)position.getLatitude());
        Assertions.assertEquals((double)expectedAltitude, (Double)position.getAltitude());
    }

    @Test
    public void constructorDoesNotValidate() {
        double expectedLongitude = -200.0;
        double expectedLatitude = -100.0;
        GeoPosition position = new GeoPosition(expectedLongitude, expectedLatitude);
        Assertions.assertEquals((double)expectedLongitude, (double)position.getLongitude());
        Assertions.assertEquals((double)expectedLatitude, (double)position.getLatitude());
    }

    @ParameterizedTest
    @MethodSource(value={"equalsSupplier"})
    public void geoPositionEquals(GeoPosition position, Object obj, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)position.equals(obj));
    }

    private static Stream<Arguments> equalsSupplier() {
        GeoPosition pikePlacePosition = GeoTestHelpers.PIKES_PLACE_POSITION.get();
        GeoPosition mtRainierPosition = GeoTestHelpers.MT_RAINIER_POSITION.get();
        return Stream.of(Arguments.of((Object[])new Object[]{pikePlacePosition, null, false}), Arguments.of((Object[])new Object[]{pikePlacePosition, 1, false}), Arguments.of((Object[])new Object[]{pikePlacePosition, pikePlacePosition, true}), Arguments.of((Object[])new Object[]{mtRainierPosition, mtRainierPosition, true}), Arguments.of((Object[])new Object[]{pikePlacePosition, mtRainierPosition, false}), Arguments.of((Object[])new Object[]{mtRainierPosition, pikePlacePosition, false}), Arguments.of((Object[])new Object[]{pikePlacePosition, GeoTestHelpers.PIKES_PLACE_POSITION.get(), true}), Arguments.of((Object[])new Object[]{mtRainierPosition, GeoTestHelpers.MT_RAINIER_POSITION.get(), true}));
    }
}

