/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.implementation.serializer.DefaultJsonSerializer;
import com.azure.core.models.JsonPatchDocument;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import java.io.IOException;
import java.util.Collections;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class JsonPatchDocumentTests {
    private static final SerializerAdapter SERIALIZER = JacksonAdapter.createDefaultSerializerAdapter();
    private static final JsonSerializer JSON_SERIALIZER = new DefaultJsonSerializer();

    @ParameterizedTest
    @MethodSource(value={"formattingSupplier"})
    public void toStringTest(JsonPatchDocument document, String expected) {
        Assertions.assertEquals((Object)expected, (Object)document.toString());
    }

    @ParameterizedTest
    @MethodSource(value={"formattingSupplier"})
    public void jsonifyDocument(JsonPatchDocument document, String expected) throws IOException {
        Assertions.assertEquals((Object)expected, (Object)SERIALIZER.serialize((Object)document, SerializerEncoding.JSON).replace(" ", ""));
    }

    @ParameterizedTest
    @MethodSource(value={"formattingSupplier"})
    public void jsonifyOperations(JsonPatchDocument document, String expected) throws IOException {
        Assertions.assertEquals((Object)expected, (Object)SERIALIZER.serialize((Object)document.getOperations(), SerializerEncoding.JSON).replace(" ", ""));
    }

    private static Stream<Arguments> formattingSupplier() {
        JsonPatchDocument complexDocument = JsonPatchDocumentTests.newDocument().appendTest("/a/b/c", (Object)"foo").appendRemove("/a/b/c").appendAdd("/a/b/c", (Object)new String[]{"foo", "bar"}).appendReplace("/a/b/c", (Object)42).appendMove("/a/b/c", "/a/b/d").appendCopy("/a/b/d", "/a/b/e");
        JsonPatchDocument complexDocumentRaw = JsonPatchDocumentTests.newDocument().appendTestRaw("/a/b/c", "\"foo\"").appendRemove("/a/b/c").appendAddRaw("/a/b/c", "[\"foo\",\"bar\"]").appendReplaceRaw("/a/b/c", "42").appendMove("/a/b/c", "/a/b/d").appendCopy("/a/b/d", "/a/b/e");
        String complexExpected = "[{\"op\":\"test\",\"path\":\"/a/b/c\",\"value\":\"foo\"},{\"op\":\"remove\",\"path\":\"/a/b/c\"},{\"op\":\"add\",\"path\":\"/a/b/c\",\"value\":[\"foo\",\"bar\"]},{\"op\":\"replace\",\"path\":\"/a/b/c\",\"value\":42},{\"op\":\"move\",\"from\":\"/a/b/c\",\"path\":\"/a/b/d\"},{\"op\":\"copy\",\"from\":\"/a/b/d\",\"path\":\"/a/b/e\"}]";
        return Stream.of(Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendAdd("/baz", (Object)"qux"), JsonPatchDocumentTests.constructExpectedOperation("add", null, "/baz", "qux")}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendAdd("/foo/1", (Object)"qux"), JsonPatchDocumentTests.constructExpectedOperation("add", null, "/foo/1", "qux")}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendAdd("/child", Collections.singletonMap("grandchild", Collections.emptyMap())), JsonPatchDocumentTests.constructExpectedOperation("add", null, "/child", "{\"grandchild\":{}}", false)}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendAdd("/foo/-", (Object)new String[]{"abc", "def"}), JsonPatchDocumentTests.constructExpectedOperation("add", null, "/foo/-", "[\"abc\",\"def\"]", false)}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendAddRaw("/baz", "\"qux\""), JsonPatchDocumentTests.constructExpectedOperation("add", null, "/baz", "qux")}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendAddRaw("/foo/1", "\"qux\""), JsonPatchDocumentTests.constructExpectedOperation("add", null, "/foo/1", "qux")}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendAddRaw("/child", "{\"grandchild\":{}}"), JsonPatchDocumentTests.constructExpectedOperation("add", null, "/child", "{\"grandchild\":{}}", false)}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendAddRaw("/foo/-", "[\"abc\",\"def\"]"), JsonPatchDocumentTests.constructExpectedOperation("add", null, "/foo/-", "[\"abc\",\"def\"]", false)}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendReplace("/bar", (Object)"foo"), JsonPatchDocumentTests.constructExpectedOperation("replace", null, "/bar", "foo")}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendReplace("/foo", (Object)new String[]{"fizz", "buzz", "fizzbuzz"}), JsonPatchDocumentTests.constructExpectedOperation("replace", null, "/foo", "[\"fizz\",\"buzz\",\"fizzbuzz\"]", false)}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendReplace("/baz", (Object)"foo"), JsonPatchDocumentTests.constructExpectedOperation("replace", null, "/baz", "foo")}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendReplaceRaw("/bar", "\"foo\""), JsonPatchDocumentTests.constructExpectedOperation("replace", null, "/bar", "foo")}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendReplaceRaw("/foo", "[\"fizz\",\"buzz\",\"fizzbuzz\"]"), JsonPatchDocumentTests.constructExpectedOperation("replace", null, "/foo", "[\"fizz\",\"buzz\",\"fizzbuzz\"]", false)}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendReplaceRaw("/baz", "\"foo\""), JsonPatchDocumentTests.constructExpectedOperation("replace", null, "/baz", "foo")}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendCopy("/foo", "/copy"), JsonPatchDocumentTests.constructExpectedOperation("copy", "/foo", "/copy", null)}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendCopy("/foo/bar", "/bar"), JsonPatchDocumentTests.constructExpectedOperation("copy", "/foo/bar", "/bar", null)}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendCopy("/baz", "/fizz"), JsonPatchDocumentTests.constructExpectedOperation("copy", "/baz", "/fizz", null)}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendMove("/foo", "/bar"), JsonPatchDocumentTests.constructExpectedOperation("move", "/foo", "/bar", null)}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendMove("/foo/bar", "/foo"), JsonPatchDocumentTests.constructExpectedOperation("move", "/foo/bar", "/foo", null)}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendMove("/foo", "/foo/bar"), JsonPatchDocumentTests.constructExpectedOperation("move", "/foo", "/foo/bar", null)}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendMove("/baz", "/fizz"), JsonPatchDocumentTests.constructExpectedOperation("move", "/baz", "/fizz", null)}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendRemove("/bar"), JsonPatchDocumentTests.constructExpectedOperation("remove", null, "/bar", null)}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendRemove("/foo/bar"), JsonPatchDocumentTests.constructExpectedOperation("remove", null, "/foo/bar", null)}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendRemove("/baz"), JsonPatchDocumentTests.constructExpectedOperation("remove", null, "/baz", null)}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendTest("/foo", (Object)"bar"), JsonPatchDocumentTests.constructExpectedOperation("test", null, "/foo", "bar")}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendTest("/foo", (Object)42), JsonPatchDocumentTests.constructExpectedOperation("test", null, "/foo", "42", false)}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendTest("/baz", (Object)"bar"), JsonPatchDocumentTests.constructExpectedOperation("test", null, "/baz", "bar")}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendTestRaw("/foo", "\"bar\""), JsonPatchDocumentTests.constructExpectedOperation("test", null, "/foo", "bar")}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendTestRaw("/foo", "42"), JsonPatchDocumentTests.constructExpectedOperation("test", null, "/foo", "42", false)}), Arguments.of((Object[])new Object[]{JsonPatchDocumentTests.newDocument().appendTestRaw("/baz", "\"bar\""), JsonPatchDocumentTests.constructExpectedOperation("test", null, "/baz", "bar")}), Arguments.of((Object[])new Object[]{complexDocument, complexExpected}), Arguments.of((Object[])new Object[]{complexDocumentRaw, complexExpected}));
    }

    private static String constructExpectedOperation(String op, String from, String path, String value) {
        return JsonPatchDocumentTests.constructExpectedOperation(op, from, path, value, true);
    }

    private static String constructExpectedOperation(String op, String from, String path, String value, boolean quoteValue) {
        StringBuilder builder = new StringBuilder("[{\"op\":\"").append(op).append("\"");
        if (from != null) {
            builder.append(",\"from\":\"").append(from).append("\"");
        }
        builder.append(",\"path\":\"").append(path).append("\"");
        if (value != null) {
            builder.append(",\"value\":").append(quoteValue ? "\"" : "").append(value).append(quoteValue ? "\"" : "");
        }
        return builder.append("}]").toString();
    }

    @ParameterizedTest
    @MethodSource(value={"invalidArgumentSupplier"})
    public void invalidArgument(Runnable runnable) {
        Assertions.assertThrows(NullPointerException.class, runnable::run);
    }

    private static Stream<Arguments> invalidArgumentSupplier() {
        JsonPatchDocument document = JsonPatchDocumentTests.newDocument();
        return Stream.of(Arguments.of((Object[])new Object[]{() -> document.appendAdd(null, (Object)"\"bar\"")}), Arguments.of((Object[])new Object[]{() -> document.appendReplace(null, (Object)"\"bar\"")}), Arguments.of((Object[])new Object[]{() -> document.appendCopy(null, "\"bar\"")}), Arguments.of((Object[])new Object[]{() -> document.appendCopy("/foo", null)}), Arguments.of((Object[])new Object[]{() -> document.appendMove(null, "\"bar\"")}), Arguments.of((Object[])new Object[]{() -> document.appendMove("/foo", null)}), Arguments.of((Object[])new Object[]{() -> document.appendRemove(null)}), Arguments.of((Object[])new Object[]{() -> document.appendTest(null, (Object)"\"bar\"")}));
    }

    private static JsonPatchDocument newDocument() {
        return new JsonPatchDocument(JSON_SERIALIZER);
    }
}

