/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.AsyncCloseable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class AsyncCloseableJavaDocCodeSnippet {
    public void asyncResource() throws IOException {
        NetworkResource resource = new NetworkResource();
        resource.longRunningDownload("https://longdownload.com").subscribe(byteBuffer -> System.out.println("Buffer received: " + byteBuffer), error -> System.err.printf("Error occurred while downloading: %s%n", error), () -> System.out.println("Completed download operation."));
        System.out.println("Press enter to stop downloading.");
        System.in.read();
        resource.closeAsync().block();
    }

    static class NetworkResource
    implements AsyncCloseable {
        private final AtomicBoolean isClosed = new AtomicBoolean();
        private final Sinks.Empty<Void> closeMono = Sinks.empty();

        NetworkResource() {
        }

        Flux<ByteBuffer> longRunningDownload(String url) {
            byte[] bytes = url.getBytes(StandardCharsets.UTF_8);
            return Flux.fromStream(IntStream.range(0, bytes.length).mapToObj(index -> ByteBuffer.wrap(bytes))).takeUntilOther((Publisher)this.closeMono.asMono());
        }

        public Mono<Void> closeAsync() {
            if (this.isClosed.getAndSet(true)) {
                return this.closeMono.asMono();
            }
            return this.startAsyncClose().then(this.closeMono.asMono());
        }

        private Mono<Void> startAsyncClose() {
            return Mono.delay((Duration)Duration.ofSeconds(10L)).then().doOnError(error -> this.closeMono.emitError(error, Sinks.EmitFailureHandler.FAIL_FAST)).doOnSuccess(unused -> this.closeMono.emitEmpty(Sinks.EmitFailureHandler.FAIL_FAST));
        }
    }
}

