/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.Base64Url;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Base64UrlTests {
    @Test
    public void constructorWithNullBytes() {
        Base64Url base64Url = new Base64Url((byte[])null);
        Assertions.assertNull((Object)base64Url.encodedBytes());
        Assertions.assertNull((Object)base64Url.decodedBytes());
        Base64UrlTests.assertEmptyString(base64Url.toString());
    }

    @Test
    public void constructorWithEmptyBytes() {
        Base64Url base64Url = new Base64Url(new byte[0]);
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])base64Url.encodedBytes());
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])base64Url.decodedBytes());
        Assertions.assertEquals((Object)"", (Object)base64Url.toString());
    }

    @Test
    public void constructorWithNonEmptyBytes() {
        Base64Url base64Url = new Base64Url(new byte[]{65, 65, 69, 67, 65, 119, 81, 70, 66, 103, 99, 73, 67, 81});
        Assertions.assertArrayEquals((byte[])new byte[]{65, 65, 69, 67, 65, 119, 81, 70, 66, 103, 99, 73, 67, 81}, (byte[])base64Url.encodedBytes());
        Assertions.assertArrayEquals((byte[])new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, (byte[])base64Url.decodedBytes());
        Assertions.assertEquals((Object)"AAECAwQFBgcICQ", (Object)base64Url.toString());
    }

    @Test
    public void constructorWithNullString() {
        Base64Url base64Url = new Base64Url((String)null);
        Assertions.assertNull((Object)base64Url.encodedBytes());
        Assertions.assertNull((Object)base64Url.decodedBytes());
        Base64UrlTests.assertEmptyString(base64Url.toString());
    }

    @Test
    public void constructorWithEmptyString() {
        Base64Url base64Url = new Base64Url("");
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])base64Url.encodedBytes());
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])base64Url.decodedBytes());
        Assertions.assertEquals((Object)"", (Object)base64Url.toString());
    }

    @Test
    public void constructorWithEmptyDoubleQuotedString() {
        Base64Url base64Url = new Base64Url("\"\"");
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])base64Url.encodedBytes());
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])base64Url.decodedBytes());
        Assertions.assertEquals((Object)"", (Object)base64Url.toString());
    }

    @Test
    public void constructorWithEmptySingleQuotedString() {
        Base64Url base64Url = new Base64Url("''");
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])base64Url.encodedBytes());
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])base64Url.decodedBytes());
        Assertions.assertEquals((Object)"", (Object)base64Url.toString());
    }

    @Test
    public void constructorWithNonEmptyString() {
        Base64Url base64Url = new Base64Url("AAECAwQFBgcICQ");
        Assertions.assertArrayEquals((byte[])new byte[]{65, 65, 69, 67, 65, 119, 81, 70, 66, 103, 99, 73, 67, 81}, (byte[])base64Url.encodedBytes());
        Assertions.assertArrayEquals((byte[])new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, (byte[])base64Url.decodedBytes());
        Assertions.assertEquals((Object)"AAECAwQFBgcICQ", (Object)base64Url.toString());
    }

    @Test
    public void constructorWithNonEmptyDoubleQuotedString() {
        Base64Url base64Url = new Base64Url("\"AAECAwQFBgcICQ\"");
        Assertions.assertArrayEquals((byte[])new byte[]{65, 65, 69, 67, 65, 119, 81, 70, 66, 103, 99, 73, 67, 81}, (byte[])base64Url.encodedBytes());
        Assertions.assertArrayEquals((byte[])new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, (byte[])base64Url.decodedBytes());
        Assertions.assertEquals((Object)"AAECAwQFBgcICQ", (Object)base64Url.toString());
    }

    @Test
    public void constructorWithNonEmptySingleQuotedString() {
        Base64Url base64Url = new Base64Url("'AAECAwQFBgcICQ'");
        Assertions.assertArrayEquals((byte[])new byte[]{65, 65, 69, 67, 65, 119, 81, 70, 66, 103, 99, 73, 67, 81}, (byte[])base64Url.encodedBytes());
        Assertions.assertArrayEquals((byte[])new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, (byte[])base64Url.decodedBytes());
        Assertions.assertEquals((Object)"AAECAwQFBgcICQ", (Object)base64Url.toString());
    }

    @Test
    public void encodeWithNullBytes() {
        Base64Url base64Url = Base64Url.encode(null);
        Assertions.assertNull((Object)base64Url.encodedBytes());
        Assertions.assertNull((Object)base64Url.decodedBytes());
        Base64UrlTests.assertEmptyString(base64Url.toString());
    }

    @Test
    public void encodeWithEmptyBytes() {
        Base64Url base64Url = Base64Url.encode((byte[])new byte[0]);
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])base64Url.encodedBytes());
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])base64Url.decodedBytes());
        Assertions.assertEquals((Object)"", (Object)base64Url.toString());
    }

    @Test
    public void encodeWithNonEmptyBytes() {
        Base64Url base64Url = Base64Url.encode((byte[])new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
        Assertions.assertArrayEquals((byte[])new byte[]{65, 65, 69, 67, 65, 119, 81, 70, 66, 103, 99, 73, 67, 81}, (byte[])base64Url.encodedBytes());
        Assertions.assertArrayEquals((byte[])new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, (byte[])base64Url.decodedBytes());
        Assertions.assertEquals((Object)"AAECAwQFBgcICQ", (Object)base64Url.toString());
    }

    private static void assertEmptyString(String input) {
        Assertions.assertEquals((Object)"", (Object)input);
    }
}

