/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.BinaryData;
import com.azure.core.util.Person;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class BinaryDataJavaDocCodeSnippet {
    public void fromStream() {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("Some Data".getBytes(StandardCharsets.UTF_8));
        BinaryData binaryData = BinaryData.fromStream((InputStream)inputStream);
        System.out.println(binaryData.toString());
    }

    public void fromStreamAsync() throws InterruptedException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("Some Data".getBytes(StandardCharsets.UTF_8));
        Mono binaryDataMono = BinaryData.fromStreamAsync((InputStream)inputStream);
        Disposable subscriber = binaryDataMono.map(binaryData -> {
            System.out.println(binaryData.toString());
            return true;
        }).subscribe();
        TimeUnit.SECONDS.sleep(5L);
        subscriber.dispose();
    }

    public void fromFlux() throws InterruptedException {
        byte[] data = "Some Data".getBytes(StandardCharsets.UTF_8);
        Flux dataFlux = Flux.just((Object)ByteBuffer.wrap(data));
        Mono binaryDataMono = BinaryData.fromFlux((Flux)dataFlux);
        Disposable subscriber = binaryDataMono.map(binaryData -> {
            System.out.println(binaryData.toString());
            return true;
        }).subscribe();
        TimeUnit.SECONDS.sleep(5L);
        subscriber.dispose();
    }

    public void fromString() {
        String data = "Some Data";
        BinaryData binaryData = BinaryData.fromString((String)"Some Data");
        System.out.println(binaryData.toString());
    }

    public void fromBytes() {
        byte[] data = "Some Data".getBytes(StandardCharsets.UTF_8);
        BinaryData binaryData = BinaryData.fromBytes((byte[])data);
        System.out.println(new String(binaryData.toBytes(), StandardCharsets.UTF_8));
    }

    public void fromFile() {
        BinaryData binaryData = BinaryData.fromFile((Path)new File("path/to/file").toPath());
        System.out.println(new String(binaryData.toBytes(), StandardCharsets.UTF_8));
    }

    public void fromFileWithChunkSize() {
        BinaryData binaryData = BinaryData.fromFile((Path)new File("path/to/file").toPath(), (int)8092);
        System.out.println(new String(binaryData.toBytes(), StandardCharsets.UTF_8));
    }

    public void fromObjectDefaultJsonSerializers() {
        class Person {
            @JsonProperty
            private String name;

            Person() {
            }

            @JsonSetter
            public Person setName(String name) {
                this.name = name;
                return this;
            }

            @JsonGetter
            public String getName() {
                return this.name;
            }
        }
        Person data = new Person().setName("John");
        BinaryData binaryData = BinaryData.fromObject((Object)data);
        System.out.println(binaryData.toString());
    }

    public void fromObjectAsyncDefaultJsonSerializer() throws InterruptedException {
        class Person {
            @JsonProperty
            private String name;

            Person() {
            }

            @JsonSetter
            public Person setName(String name) {
                this.name = name;
                return this;
            }

            @JsonGetter
            public String getName() {
                return this.name;
            }
        }
        Person data = new Person().setName("John");
        Disposable subscriber = BinaryData.fromObjectAsync((Object)data).subscribe(binaryData -> System.out.println(binaryData.toString()));
        TimeUnit.SECONDS.sleep(5L);
        subscriber.dispose();
    }

    private void sendToService(BinaryData binaryData) {
    }

    public void fromObjectObjectSerializer() {
        class Person {
            @JsonProperty
            private String name;

            Person() {
            }

            @JsonSetter
            public Person setName(String name) {
                this.name = name;
                return this;
            }

            @JsonGetter
            public String getName() {
                return this.name;
            }
        }
        Person data = new Person().setName("John");
        MyJsonSerializer serializer = new MyJsonSerializer();
        BinaryData binaryData = BinaryData.fromObject((Object)data, (ObjectSerializer)serializer);
        System.out.println(binaryData.toString());
    }

    public void fromObjectAsyncObjectSerializer() throws InterruptedException {
        class Person {
            @JsonProperty
            private String name;

            Person() {
            }

            @JsonSetter
            public Person setName(String name) {
                this.name = name;
                return this;
            }

            @JsonGetter
            public String getName() {
                return this.name;
            }
        }
        Person data = new Person().setName("John");
        MyJsonSerializer serializer = new MyJsonSerializer();
        Disposable subscriber = BinaryData.fromObjectAsync((Object)data, (ObjectSerializer)serializer).subscribe(binaryData -> System.out.println(binaryData.toString()));
        TimeUnit.SECONDS.sleep(5L);
        subscriber.dispose();
    }

    public void toObjectClassDefaultJsonSerializer() {
        class Person {
            @JsonProperty
            private String name;

            Person() {
            }

            @JsonSetter
            public Person setName(String name) {
                this.name = name;
                return this;
            }

            @JsonGetter
            public String getName() {
                return this.name;
            }
        }
        Person data = new Person().setName("John");
        BinaryData binaryData = BinaryData.fromObject((Object)data);
        Person person = (Person)binaryData.toObject(Person.class);
        System.out.println(person.getName());
    }

    public void toObjectTypeReferenceDefaultJsonSerializer() {
        class Person {
            @JsonProperty
            private String name;

            Person() {
            }

            @JsonSetter
            public Person setName(String name) {
                this.name = name;
                return this;
            }

            @JsonGetter
            public String getName() {
                return this.name;
            }
        }
        Person data = new Person().setName("John");
        BinaryData binaryData = BinaryData.fromObject((Object)data);
        Person person = (Person)binaryData.toObject(TypeReference.createInstance(Person.class));
        System.out.println(person.getName());
    }

    public void toObjectTypeReferenceDefaultJsonSerializerWithGenerics() {
        Person person1 = new Person().setName("John");
        Person person2 = new Person().setName("Jack");
        ArrayList<Person> personList = new ArrayList<Person>();
        personList.add(person1);
        personList.add(person2);
        BinaryData binaryData = BinaryData.fromObject(personList);
        List persons = (List)binaryData.toObject((TypeReference)new TypeReference<List<Person>>(){});
        persons.forEach(person -> System.out.println(person.getName()));
    }

    public void toObjectClassObjectSerializer() {
        class Person {
            @JsonProperty
            private String name;

            Person() {
            }

            @JsonSetter
            public Person setName(String name) {
                this.name = name;
                return this;
            }

            @JsonGetter
            public String getName() {
                return this.name;
            }
        }
        Person data = new Person().setName("John");
        MyJsonSerializer serializer = new MyJsonSerializer();
        BinaryData binaryData = BinaryData.fromObject((Object)data, (ObjectSerializer)serializer);
        Person person = (Person)binaryData.toObject(Person.class, (ObjectSerializer)serializer);
        System.out.println("Name : " + person.getName());
    }

    public void toObjectTypeReferenceObjectSerializer() {
        class Person {
            @JsonProperty
            private String name;

            Person() {
            }

            @JsonSetter
            public Person setName(String name) {
                this.name = name;
                return this;
            }

            @JsonGetter
            public String getName() {
                return this.name;
            }
        }
        Person data = new Person().setName("John");
        MyJsonSerializer serializer = new MyJsonSerializer();
        BinaryData binaryData = BinaryData.fromObject((Object)data, (ObjectSerializer)serializer);
        Person person = (Person)binaryData.toObject(TypeReference.createInstance(Person.class), (ObjectSerializer)serializer);
        System.out.println("Name : " + person.getName());
    }

    public void toObjectTypeReferenceObjectSerializerWithGenerics() {
        Person person1 = new Person().setName("John");
        Person person2 = new Person().setName("Jack");
        ArrayList<Person> personList = new ArrayList<Person>();
        personList.add(person1);
        personList.add(person2);
        MyJsonSerializer serializer = new MyJsonSerializer();
        BinaryData binaryData = BinaryData.fromObject(personList, (ObjectSerializer)serializer);
        List persons = (List)binaryData.toObject((TypeReference)new TypeReference<List<Person>>(){}, (ObjectSerializer)serializer);
        persons.forEach(person -> System.out.println("Name : " + person.getName()));
    }

    public void toObjectAsyncClassDefaultJsonSerializer() throws InterruptedException {
        class Person {
            @JsonProperty
            private String name;

            Person() {
            }

            @JsonSetter
            public Person setName(String name) {
                this.name = name;
                return this;
            }

            @JsonGetter
            public String getName() {
                return this.name;
            }
        }
        Person data = new Person().setName("John");
        BinaryData binaryData = BinaryData.fromObject((Object)data);
        Disposable subscriber = binaryData.toObjectAsync(Person.class).subscribe(person -> System.out.println(person.getName()));
        TimeUnit.SECONDS.sleep(5L);
        subscriber.dispose();
    }

    public void toObjectAsyncTypeReferenceDefaultJsonSerializer() throws InterruptedException {
        class Person {
            @JsonProperty
            private String name;

            Person() {
            }

            @JsonSetter
            public Person setName(String name) {
                this.name = name;
                return this;
            }

            @JsonGetter
            public String getName() {
                return this.name;
            }
        }
        Person data = new Person().setName("John");
        BinaryData binaryData = BinaryData.fromObject((Object)data);
        Disposable subscriber = binaryData.toObjectAsync(TypeReference.createInstance(Person.class)).subscribe(person -> System.out.println(person.getName()));
        TimeUnit.SECONDS.sleep(5L);
        subscriber.dispose();
    }

    public void toObjectAsyncTypeReferenceDefaultJsonSerializerGeneric() throws InterruptedException {
        Person person1 = new Person().setName("John");
        Person person2 = new Person().setName("Jack");
        ArrayList<Person> personList = new ArrayList<Person>();
        personList.add(person1);
        personList.add(person2);
        BinaryData binaryData = BinaryData.fromObject(personList);
        Disposable subscriber = binaryData.toObjectAsync((TypeReference)new TypeReference<List<Person>>(){}).subscribe(persons -> persons.forEach(person -> System.out.println(person.getName())));
        TimeUnit.SECONDS.sleep(5L);
        subscriber.dispose();
    }

    public void toObjectAsyncClassObjectSerializer() throws InterruptedException {
        class Person {
            @JsonProperty
            private String name;

            Person() {
            }

            @JsonSetter
            public Person setName(String name) {
                this.name = name;
                return this;
            }

            @JsonGetter
            public String getName() {
                return this.name;
            }
        }
        Person data = new Person().setName("John");
        MyJsonSerializer serializer = new MyJsonSerializer();
        BinaryData binaryData = BinaryData.fromObject((Object)data, (ObjectSerializer)serializer);
        Disposable subscriber = binaryData.toObjectAsync(Person.class, (ObjectSerializer)serializer).subscribe(person -> System.out.println(person.getName()));
        TimeUnit.SECONDS.sleep(5L);
        subscriber.dispose();
    }

    public void toObjectAsyncTypeReferenceObjectSerializer() throws InterruptedException {
        class Person {
            @JsonProperty
            private String name;

            Person() {
            }

            @JsonSetter
            public Person setName(String name) {
                this.name = name;
                return this;
            }

            @JsonGetter
            public String getName() {
                return this.name;
            }
        }
        Person data = new Person().setName("John");
        MyJsonSerializer serializer = new MyJsonSerializer();
        BinaryData binaryData = BinaryData.fromObject((Object)data, (ObjectSerializer)serializer);
        Disposable subscriber = binaryData.toObjectAsync(TypeReference.createInstance(Person.class), (ObjectSerializer)serializer).subscribe(person -> System.out.println(person.getName()));
        TimeUnit.SECONDS.sleep(5L);
        subscriber.dispose();
    }

    public void toObjectAsyncTypeReferenceObjectSerializerGeneric() throws InterruptedException {
        Person person1 = new Person().setName("John");
        Person person2 = new Person().setName("Jack");
        ArrayList<Person> personList = new ArrayList<Person>();
        personList.add(person1);
        personList.add(person2);
        MyJsonSerializer serializer = new MyJsonSerializer();
        BinaryData binaryData = BinaryData.fromObject(personList, (ObjectSerializer)serializer);
        Disposable subscriber = binaryData.toObjectAsync((TypeReference)new TypeReference<List<Person>>(){}, (ObjectSerializer)serializer).subscribe(persons -> persons.forEach(person -> System.out.println(person.getName())));
        TimeUnit.SECONDS.sleep(5L);
        subscriber.dispose();
    }

    public void toStream() throws IOException {
        byte[] data = "Some Data".getBytes(StandardCharsets.UTF_8);
        BinaryData binaryData = BinaryData.fromStream((InputStream)new ByteArrayInputStream(data));
        byte[] bytes = new byte[data.length];
        binaryData.toStream().read(bytes, 0, data.length);
        System.out.println(new String(bytes));
    }

    public void toReadOnlyByteBuffer() {
        byte[] data = "Some Data".getBytes(StandardCharsets.UTF_8);
        BinaryData binaryData = BinaryData.fromBytes((byte[])data);
        byte[] bytes = new byte[data.length];
        binaryData.toByteBuffer().get(bytes, 0, data.length);
        System.out.println(new String(bytes));
    }

    public static class MyJsonSerializer
    implements JsonSerializer {
        private final ClientLogger logger = new ClientLogger(MyJsonSerializer.class);
        private final ObjectMapper mapper = new ObjectMapper();
        private final TypeFactory typeFactory = this.mapper.getTypeFactory();

        public <T> T deserialize(InputStream stream, TypeReference<T> typeReference) {
            if (stream == null) {
                return null;
            }
            try {
                return (T)this.mapper.readValue(stream, this.typeFactory.constructType(typeReference.getJavaType()));
            }
            catch (IOException ex) {
                throw this.logger.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
            }
        }

        public <T> Mono<T> deserializeAsync(InputStream stream, TypeReference<T> typeReference) {
            return Mono.fromCallable(() -> this.deserialize(stream, typeReference));
        }

        public void serialize(OutputStream stream, Object value) {
            try {
                this.mapper.writeValue(stream, value);
            }
            catch (IOException ex) {
                throw this.logger.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
            }
        }

        public Mono<Void> serializeAsync(OutputStream stream, Object value) {
            return Mono.fromRunnable(() -> this.serialize(stream, value));
        }
    }
}

