/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.Configuration;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class ConfigurationTests {
    private static final String MY_CONFIGURATION = "myConfigurationABC123";
    private static final String EXPECTED_VALUE = "aConfigurationValueAbc123";
    private static final String UNEXPECTED_VALUE = "notMyConfigurationValueDef456";
    private static final String DEFAULT_VALUE = "theDefaultValueGhi789";

    @Test
    public void runtimeConfigurationFound() {
        Configuration configuration = (Configuration)Mockito.spy(Configuration.class);
        Mockito.when((Object)configuration.loadFromProperties(MY_CONFIGURATION)).thenReturn((Object)EXPECTED_VALUE);
        Mockito.when((Object)configuration.loadFromEnvironment(MY_CONFIGURATION)).thenReturn(null);
        Assertions.assertEquals((Object)EXPECTED_VALUE, (Object)configuration.get(MY_CONFIGURATION));
    }

    @Test
    public void environmentConfigurationFound() {
        Configuration configuration = (Configuration)Mockito.spy(Configuration.class);
        Mockito.when((Object)configuration.loadFromProperties(MY_CONFIGURATION)).thenReturn(null);
        Mockito.when((Object)configuration.loadFromEnvironment(MY_CONFIGURATION)).thenReturn((Object)EXPECTED_VALUE);
        Assertions.assertEquals((Object)EXPECTED_VALUE, (Object)configuration.get(MY_CONFIGURATION));
    }

    @Test
    public void configurationNotFound() {
        Configuration configuration = new Configuration();
        Assertions.assertNull((Object)configuration.get(MY_CONFIGURATION));
    }

    @Test
    public void runtimeConfigurationPreferredOverEnvironmentConfiguration() {
        Configuration configuration = (Configuration)Mockito.spy(Configuration.class);
        Mockito.when((Object)configuration.loadFromProperties(MY_CONFIGURATION)).thenReturn((Object)EXPECTED_VALUE);
        Mockito.when((Object)configuration.loadFromEnvironment(MY_CONFIGURATION)).thenReturn((Object)UNEXPECTED_VALUE);
        Assertions.assertEquals((Object)EXPECTED_VALUE, (Object)configuration.get(MY_CONFIGURATION));
    }

    @Test
    public void foundConfigurationPreferredOverDefault() {
        Configuration configuration = (Configuration)Mockito.spy(Configuration.class);
        Mockito.when((Object)configuration.loadFromEnvironment(MY_CONFIGURATION)).thenReturn((Object)EXPECTED_VALUE);
        Assertions.assertEquals((Object)EXPECTED_VALUE, (Object)configuration.get(MY_CONFIGURATION, (Object)DEFAULT_VALUE));
    }

    @Test
    public void fallbackToDefaultConfiguration() {
        Configuration configuration = new Configuration();
        Assertions.assertEquals((Object)DEFAULT_VALUE, (Object)configuration.get(MY_CONFIGURATION, (Object)DEFAULT_VALUE));
    }

    @Test
    public void foundConfigurationIsConverted() {
        Configuration configuration = (Configuration)Mockito.spy(Configuration.class);
        Mockito.when((Object)configuration.loadFromProperties(MY_CONFIGURATION)).thenReturn((Object)EXPECTED_VALUE);
        Assertions.assertEquals((Object)EXPECTED_VALUE.toUpperCase(), (Object)configuration.get(MY_CONFIGURATION, String::toUpperCase));
    }

    @Test
    public void notFoundConfigurationIsConvertedToNull() {
        Assertions.assertNull((Object)new Configuration().get(MY_CONFIGURATION, String::toUpperCase));
    }

    @Test
    public void cloneConfiguration() {
        Configuration configuration = new Configuration().put("variable1", "value1").put("variable2", "value2");
        Configuration configurationClone = configuration.clone();
        Assertions.assertEquals((Object)configuration.get("variable1"), (Object)configurationClone.get("variable1"));
        Assertions.assertEquals((Object)configuration.get("variable2"), (Object)configurationClone.get("variable2"));
        configurationClone.remove("variable2");
        Assertions.assertTrue((boolean)configuration.contains("variable2"));
    }

    @Test
    public void loadValueTwice() {
        Configuration configuration = new Configuration();
        String tracingDisabled = configuration.get("AZURE_TRACING_DISABLED");
        String tracingDisabled2 = configuration.get("AZURE_TRACING_DISABLED");
        Assertions.assertEquals((Object)tracingDisabled, (Object)tracingDisabled2);
    }

    @ParameterizedTest
    @MethodSource(value={"getOrDefaultSupplier"})
    public void getOrDefault(String configurationValue, Object defaultValue, Object expectedValue) {
        Configuration configuration = new Configuration().put("getOrDefault", configurationValue);
        Assertions.assertEquals((Object)expectedValue, (Object)configuration.get("getOrDefault", defaultValue));
    }

    private static Stream<Arguments> getOrDefaultSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{String.valueOf(42), (byte)12, (byte)42}), Arguments.of((Object[])new Object[]{String.valueOf(42), (short)12, (short)42}), Arguments.of((Object[])new Object[]{String.valueOf(42), 12, 42}), Arguments.of((Object[])new Object[]{String.valueOf(42L), 12L, 42L}), Arguments.of((Object[])new Object[]{String.valueOf(42.0f), Float.valueOf(12.0f), Float.valueOf(42.0f)}), Arguments.of((Object[])new Object[]{String.valueOf(42.0), 12.0, 42.0}), Arguments.of((Object[])new Object[]{String.valueOf(true), false, true}), Arguments.of((Object[])new Object[]{"42", "12", "42"}));
    }

    @Test
    public void getOrDefaultReturnsDefault() {
        Assertions.assertEquals((Object)"42", (Object)new Configuration().get("empty", (Object)"42"));
    }
}

