/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.Context;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ContextTests {
    @Test
    public void simpleContext() {
        Context context = new Context((Object)"key", (Object)"value");
        Assertions.assertEquals((Object)"value", (Object)context.getData((Object)"key").orElse(""));
        Assertions.assertFalse((boolean)context.getData((Object)"fakeKey").isPresent());
    }

    @Test
    public void constructorKeyCannotBeNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new Context(null, null));
    }

    @ParameterizedTest
    @MethodSource(value={"addDataSupplier"})
    public void addData(String key, String value, String expectedOriginalValue) {
        Context context = new Context((Object)"key", (Object)"value").addData((Object)key, (Object)value);
        Assertions.assertEquals((Object)value, (Object)context.getData((Object)key).orElse(""));
        Assertions.assertEquals((Object)expectedOriginalValue, (Object)context.getData((Object)"key").orElse(""));
    }

    private static Stream<Arguments> addDataSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{"key", "newValue", "newValue"}), Arguments.of((Object[])new Object[]{"key", "", ""}), Arguments.of((Object[])new Object[]{"key2", "newValue", "value"}), Arguments.of((Object[])new Object[]{"key2", "", "value"}));
    }

    @Test
    public void addDataKeyCannotBeNull() {
        Context context = new Context((Object)"key", (Object)"value");
        Assertions.assertThrows(IllegalArgumentException.class, () -> context.addData(null, null));
    }

    @Test
    public void of() {
        Context context = Context.of(Collections.singletonMap("key", "value"));
        Assertions.assertEquals((Object)"value", (Object)context.getData((Object)"key").orElse(""));
        HashMap<String, String> complexValues = new HashMap<String, String>();
        complexValues.put("key", "value");
        complexValues.put("key2", "value2");
        context = Context.of(complexValues);
        Assertions.assertEquals((Object)"value", (Object)context.getData((Object)"key").orElse(""));
        Assertions.assertEquals((Object)"value2", (Object)context.getData((Object)"key2").orElse(""));
    }

    @Test
    public void ofValuesCannotBeNullOrEmpty() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Context.of(null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Context.of(Collections.emptyMap()));
    }

    @Test
    public void getValueKeyCannotBeNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Context.NONE.getData(null));
    }

    @ParameterizedTest
    @MethodSource(value={"getValuesSupplier"})
    public void getValues(Context context, Map<Object, Object> expected) {
        Assertions.assertEquals(expected, (Object)context.getValues());
    }

    private static Stream<Arguments> getValuesSupplier() {
        Context contextWithMultipleKeys = new Context((Object)"key", (Object)"value").addData((Object)"key2", (Object)"value2");
        HashMap<String, String> expectedMultipleKeys = new HashMap<String, String>();
        expectedMultipleKeys.put("key", "value");
        expectedMultipleKeys.put("key2", "value2");
        Context contextWithMultipleSameKeys = new Context((Object)"key", (Object)"value").addData((Object)"key", (Object)"value2");
        return Stream.of(Arguments.of((Object[])new Object[]{Context.NONE, Collections.emptyMap()}), Arguments.of((Object[])new Object[]{new Context((Object)"key", (Object)"value"), Collections.singletonMap("key", "value")}), Arguments.of((Object[])new Object[]{contextWithMultipleKeys, expectedMultipleKeys}), Arguments.of((Object[])new Object[]{contextWithMultipleSameKeys, Collections.singletonMap("key", "value2")}));
    }
}

