/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.ExpandableStringEnum;
import java.util.HashSet;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import wiremock.com.google.common.base.Objects;

public class ExpandableStringEnumTests {
    @Test
    public void nullNameReturnsNull() {
        Assertions.assertNull((Object)((Object)TestStringEnum.fromString(null)));
    }

    @Test
    public void privateStringEnumAlwaysReturnsNull() {
        Assertions.assertNull((Object)((Object)PrivateStringEnum.fromString("test")));
        Assertions.assertNull((Object)((Object)PrivateStringEnum.fromString("anotherTest")));
        Assertions.assertNull((Object)((Object)PrivateStringEnum.fromString("finalTest")));
    }

    @Test
    public void stringEnumValues() {
        HashSet values = new HashSet(ExpandableStringEnum.values(ValuesTestStringEnum.class));
        Assertions.assertEquals((int)0, (int)values.size());
        ValuesTestStringEnum value1 = ValuesTestStringEnum.fromString("value1");
        ValuesTestStringEnum value2 = ValuesTestStringEnum.fromString("value2");
        values = new HashSet(ExpandableStringEnum.values(ValuesTestStringEnum.class));
        Assertions.assertEquals((int)2, (int)values.size());
        Assertions.assertTrue((boolean)values.contains((Object)value1));
        Assertions.assertTrue((boolean)values.contains((Object)value2));
    }

    @Test
    public void validateHashCode() {
        Assertions.assertEquals((int)Objects.hashCode((Object[])new Object[]{TestStringEnum.class, "test"}), (int)TestStringEnum.fromString("test").hashCode());
    }

    @ParameterizedTest
    @MethodSource(value={"validateEqualsSupplier"})
    public void validateEquals(ExpandableStringEnum<?> lhs, ExpandableStringEnum<?> rhs, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)lhs.equals(rhs));
    }

    private static Stream<Arguments> validateEqualsSupplier() {
        TestStringEnum testStringEnum = TestStringEnum.fromString("test");
        TestStringEnum2 testStringEnum2 = TestStringEnum2.fromString("test");
        return Stream.of(Arguments.of((Object[])new Object[]{testStringEnum, null, false}), Arguments.of((Object[])new Object[]{testStringEnum, testStringEnum2, false}), Arguments.of((Object[])new Object[]{testStringEnum, testStringEnum, true}), Arguments.of((Object[])new Object[]{testStringEnum2, testStringEnum2, true}), Arguments.of((Object[])new Object[]{testStringEnum, TestStringEnum.fromString("test"), true}), Arguments.of((Object[])new Object[]{testStringEnum, TestStringEnum.fromString("test2"), false}));
    }

    public static final class ValuesTestStringEnum
    extends ExpandableStringEnum<ValuesTestStringEnum> {
        static ValuesTestStringEnum fromString(String name) {
            return (ValuesTestStringEnum)ValuesTestStringEnum.fromString((String)name, ValuesTestStringEnum.class);
        }
    }

    private static final class PrivateStringEnum
    extends ExpandableStringEnum<PrivateStringEnum> {
        private PrivateStringEnum() {
        }

        static PrivateStringEnum fromString(String name) {
            return (PrivateStringEnum)PrivateStringEnum.fromString((String)name, PrivateStringEnum.class);
        }
    }

    public static final class TestStringEnum2
    extends ExpandableStringEnum<TestStringEnum2> {
        static TestStringEnum2 fromString(String name) {
            return (TestStringEnum2)TestStringEnum2.fromString((String)name, TestStringEnum2.class);
        }
    }

    public static final class TestStringEnum
    extends ExpandableStringEnum<TestStringEnum> {
        static TestStringEnum fromString(String name) {
            return (TestStringEnum)TestStringEnum.fromString((String)name, TestStringEnum.class);
        }
    }
}

