/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.HttpClientOptions;
import java.time.Duration;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class HttpClientOptionsTests {
    @ParameterizedTest
    @MethodSource(value={"timeoutSupplier"})
    public void nullTimeoutDefaultsTo60Seconds(BiFunction<HttpClientOptions, Duration, HttpClientOptions> timeoutSetter, Function<HttpClientOptions, Duration> timeoutGetter) {
        HttpClientOptions httpClientOptions = timeoutSetter.apply(new HttpClientOptions(), null);
        Assertions.assertEquals((Object)Duration.ofSeconds(60L), (Object)timeoutGetter.apply(httpClientOptions));
    }

    @ParameterizedTest
    @MethodSource(value={"timeoutSupplier"})
    public void negativeTimeoutDefaultsToInfiniteTimeout(BiFunction<HttpClientOptions, Duration, HttpClientOptions> timeoutSetter, Function<HttpClientOptions, Duration> timeoutGetter) {
        HttpClientOptions httpClientOptions = timeoutSetter.apply(new HttpClientOptions(), Duration.ofSeconds(-1L));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)timeoutGetter.apply(httpClientOptions));
    }

    public void zeroTimeoutDefaultsToInfiniteTimeout(BiFunction<HttpClientOptions, Duration, HttpClientOptions> timeoutSetter, Function<HttpClientOptions, Duration> timeoutGetter) {
        HttpClientOptions httpClientOptions = timeoutSetter.apply(new HttpClientOptions(), Duration.ZERO);
        Assertions.assertEquals((Object)Duration.ZERO, (Object)timeoutGetter.apply(httpClientOptions));
    }

    @ParameterizedTest
    @MethodSource(value={"timeoutSupplier"})
    public void smallTimeoutDefaultsToOneMillisecond(BiFunction<HttpClientOptions, Duration, HttpClientOptions> timeoutSetter, Function<HttpClientOptions, Duration> timeoutGetter) {
        HttpClientOptions httpClientOptions = timeoutSetter.apply(new HttpClientOptions(), Duration.ofNanos(1L));
        Assertions.assertEquals((Object)Duration.ofMillis(1L), (Object)timeoutGetter.apply(httpClientOptions));
    }

    @ParameterizedTest
    @MethodSource(value={"timeoutSupplier"})
    public void timeoutReturnsAsIs(BiFunction<HttpClientOptions, Duration, HttpClientOptions> timeoutSetter, Function<HttpClientOptions, Duration> timeoutGetter) {
        HttpClientOptions httpClientOptions = timeoutSetter.apply(new HttpClientOptions(), Duration.ofMinutes(5L));
        Assertions.assertEquals((Object)Duration.ofMinutes(5L), (Object)timeoutGetter.apply(httpClientOptions));
    }

    private static Stream<Arguments> timeoutSupplier() {
        BiFunction<HttpClientOptions, Duration, HttpClientOptions> setWriteTimeout = HttpClientOptions::setWriteTimeout;
        Function<HttpClientOptions, Duration> getWriteTimeout = HttpClientOptions::getWriteTimeout;
        BiFunction<HttpClientOptions, Duration, HttpClientOptions> responseTimeout = HttpClientOptions::responseTimeout;
        BiFunction<HttpClientOptions, Duration, HttpClientOptions> setResponseTimeout = HttpClientOptions::setResponseTimeout;
        Function<HttpClientOptions, Duration> getResponseTimeout = HttpClientOptions::getResponseTimeout;
        BiFunction<HttpClientOptions, Duration, HttpClientOptions> readTimeout = HttpClientOptions::readTimeout;
        BiFunction<HttpClientOptions, Duration, HttpClientOptions> setReadTimeout = HttpClientOptions::setReadTimeout;
        Function<HttpClientOptions, Duration> getReadTimeout = HttpClientOptions::getReadTimeout;
        BiFunction<HttpClientOptions, Duration, HttpClientOptions> setConnectionIdleTimeout = HttpClientOptions::setConnectionIdleTimeout;
        Function<HttpClientOptions, Duration> getConnectionIdleTimeout = HttpClientOptions::getConnectionIdleTimeout;
        return Stream.of(Arguments.of((Object[])new Object[]{setWriteTimeout, getWriteTimeout}), Arguments.of((Object[])new Object[]{responseTimeout, getResponseTimeout}), Arguments.of((Object[])new Object[]{setResponseTimeout, getResponseTimeout}), Arguments.of((Object[])new Object[]{readTimeout, getReadTimeout}), Arguments.of((Object[])new Object[]{setReadTimeout, getReadTimeout}), Arguments.of((Object[])new Object[]{setConnectionIdleTimeout, getConnectionIdleTimeout}));
    }

    @Test
    public void nullMaximumConnectionPoolSizeRemainsNull() {
        HttpClientOptions httpClientOptions = new HttpClientOptions().setMaximumConnectionPoolSize(null);
        Assertions.assertNull((Object)httpClientOptions.getMaximumConnectionPoolSize());
    }

    @Test
    public void maximumConnectionPoolSizeReturnsAsIs() {
        HttpClientOptions httpClientOptions = new HttpClientOptions().setMaximumConnectionPoolSize(Integer.valueOf(50));
        Assertions.assertEquals((int)50, (Integer)httpClientOptions.getMaximumConnectionPoolSize());
    }

    @Test
    public void zeroOrNegativeMaximumConnectionPoolSizeThrows() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new HttpClientOptions().setMaximumConnectionPoolSize(Integer.valueOf(0)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new HttpClientOptions().setMaximumConnectionPoolSize(Integer.valueOf(-1)));
    }
}

