/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.UrlToken;
import com.azure.core.util.UrlTokenizer;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UrlTokenizerTests {
    @Test
    public void constructor() {
        UrlTokenizer tokenizer = new UrlTokenizer("http://www.bing.com");
        Assertions.assertNull((Object)tokenizer.current());
    }

    @Test
    public void nextWithNullText() {
        UrlTokenizer tokenizer = new UrlTokenizer(null);
        Assertions.assertFalse((boolean)tokenizer.next());
        Assertions.assertNull((Object)tokenizer.current());
    }

    @Test
    public void nextWithEmptyText() {
        UrlTokenizer tokenizer = new UrlTokenizer("");
        Assertions.assertFalse((boolean)tokenizer.next());
        Assertions.assertNull((Object)tokenizer.current());
    }

    @Test
    public void nextWithSchemeButNoSeparator() {
        UrlTokenizerTests.nextTest("http", UrlToken.host((String)"http"));
    }

    @Test
    public void nextWithSchemeAndColon() {
        UrlTokenizerTests.nextTest("http:", UrlToken.host((String)"http"), UrlToken.port((String)""));
    }

    @Test
    public void nextWithSchemeAndColonAndForwardSlash() {
        UrlTokenizerTests.nextTest("http:/", UrlToken.host((String)"http"), UrlToken.port((String)""), UrlToken.path((String)"/"));
    }

    @Test
    public void nextWithSchemeAndColonAndTwoForwardSlashes() {
        UrlTokenizerTests.nextTest("http://", UrlToken.scheme((String)"http"), UrlToken.host((String)""));
    }

    @Test
    public void nextWithSchemeAndHost() {
        UrlTokenizerTests.nextTest("https://www.example.com", UrlToken.scheme((String)"https"), UrlToken.host((String)"www.example.com"));
    }

    @Test
    public void nextWithSchemeAndHostAndColon() {
        UrlTokenizerTests.nextTest("https://www.example.com:", UrlToken.scheme((String)"https"), UrlToken.host((String)"www.example.com"), UrlToken.port((String)""));
    }

    @Test
    public void nextWithSchemeAndHostAndPort() {
        UrlTokenizerTests.nextTest("https://www.example.com:8080", UrlToken.scheme((String)"https"), UrlToken.host((String)"www.example.com"), UrlToken.port((String)"8080"));
    }

    @Test
    public void nextWithSchemeAndHostAndPortAndForwardSlash() {
        UrlTokenizerTests.nextTest("ftp://www.bing.com:123/", UrlToken.scheme((String)"ftp"), UrlToken.host((String)"www.bing.com"), UrlToken.port((String)"123"), UrlToken.path((String)"/"));
    }

    @Test
    public void nextWithSchemeAndHostAndPortAndPath() {
        UrlTokenizerTests.nextTest("ftp://www.bing.com:123/a/b/c.txt", UrlToken.scheme((String)"ftp"), UrlToken.host((String)"www.bing.com"), UrlToken.port((String)"123"), UrlToken.path((String)"/a/b/c.txt"));
    }

    @Test
    public void nextWithSchemeAndHostAndPortAndQuestionMark() {
        UrlTokenizerTests.nextTest("ftp://www.bing.com:123?", UrlToken.scheme((String)"ftp"), UrlToken.host((String)"www.bing.com"), UrlToken.port((String)"123"), UrlToken.query((String)""));
    }

    @Test
    public void nextWithSchemeAndHostAndPortAndQuery() {
        UrlTokenizerTests.nextTest("ftp://www.bing.com:123?a=b&c=d", UrlToken.scheme((String)"ftp"), UrlToken.host((String)"www.bing.com"), UrlToken.port((String)"123"), UrlToken.query((String)"a=b&c=d"));
    }

    @Test
    public void nextWithSchemeAndHostAndForwardSlash() {
        UrlTokenizerTests.nextTest("https://www.example.com/", UrlToken.scheme((String)"https"), UrlToken.host((String)"www.example.com"), UrlToken.path((String)"/"));
    }

    @Test
    public void nextWithSchemeAndHostAndPath() {
        UrlTokenizerTests.nextTest("https://www.example.com/index.html", UrlToken.scheme((String)"https"), UrlToken.host((String)"www.example.com"), UrlToken.path((String)"/index.html"));
    }

    @Test
    public void nextWithSchemeAndHostAndPathAndQuestionMark() {
        UrlTokenizerTests.nextTest("https://www.example.com/index.html?", UrlToken.scheme((String)"https"), UrlToken.host((String)"www.example.com"), UrlToken.path((String)"/index.html"), UrlToken.query((String)""));
    }

    @Test
    public void nextWithSchemeAndHostAndPathAndQuery() {
        UrlTokenizerTests.nextTest("https://www.example.com/index.html?alpha=beta", UrlToken.scheme((String)"https"), UrlToken.host((String)"www.example.com"), UrlToken.path((String)"/index.html"), UrlToken.query((String)"alpha=beta"));
    }

    @Test
    public void nextWithSchemeAndHostAndQuestionMark() {
        UrlTokenizerTests.nextTest("https://www.example.com?", UrlToken.scheme((String)"https"), UrlToken.host((String)"www.example.com"), UrlToken.query((String)""));
    }

    @Test
    public void nextWithSchemeAndHostAndQuery() {
        UrlTokenizerTests.nextTest("https://www.example.com?a=b", UrlToken.scheme((String)"https"), UrlToken.host((String)"www.example.com"), UrlToken.query((String)"a=b"));
    }

    @Test
    public void nextWithHostAndForwardSlash() {
        UrlTokenizerTests.nextTest("www.test.com/", UrlToken.host((String)"www.test.com"), UrlToken.path((String)"/"));
    }

    @Test
    public void nextWithHostAndQuestionMark() {
        UrlTokenizerTests.nextTest("www.test.com?", UrlToken.host((String)"www.test.com"), UrlToken.query((String)""));
    }

    @Test
    public void nextWithPath() {
        UrlTokenizerTests.nextTest("folder/index.html", UrlToken.host((String)"folder"), UrlToken.path((String)"/index.html"));
    }

    @Test
    public void nextWithForwardSlashAndPath() {
        UrlTokenizerTests.nextTest("/folder/index.html", UrlToken.host((String)""), UrlToken.path((String)"/folder/index.html"));
    }

    private static void nextTest(String text, UrlToken ... expectedTokens) {
        UrlTokenizer tokenizer = new UrlTokenizer(text);
        ArrayList<UrlToken> tokenList = new ArrayList<UrlToken>();
        while (tokenizer.next()) {
            tokenList.add(tokenizer.current());
        }
        Object[] tokenArray = new UrlToken[tokenList.size()];
        tokenList.toArray(tokenArray);
        Assertions.assertArrayEquals((Object[])expectedTokens, (Object[])tokenArray);
        Assertions.assertFalse((boolean)tokenizer.next());
        Assertions.assertNull((Object)tokenizer.current());
    }
}

