/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.polling;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.OperationResourcePollingStrategy;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.PollingStrategy;
import com.azure.core.util.serializer.TypeReference;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.function.Predicate;
import reactor.core.publisher.Mono;

public final class PollerJavaDocCodeSnippets {
    private final PollerFlux<String, String> pollerFlux = new PollerFlux(Duration.ofMillis(100L), context -> Mono.empty(), context -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)"Completed")), (activationResponse, context) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported")), context -> Mono.just((Object)"Final Output"));

    public void initializeAndSubscribe() {
        LocalDateTime timeToReturnFinalResponse = LocalDateTime.now().plus(Duration.ofMillis(800L));
        PollerFlux poller = new PollerFlux(Duration.ofMillis(100L), context -> Mono.empty(), context -> {
            if (LocalDateTime.now().isBefore(timeToReturnFinalResponse)) {
                System.out.println("Returning intermediate response.");
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)"Operation in progress."));
            }
            System.out.println("Returning final response.");
            return Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)"Operation completed."));
        }, (activationResponse, context) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported")), context -> Mono.just((Object)"Final Output"));
        poller.subscribe(response -> System.out.printf("Got response. Status: %s, Value: %s%n", response.getStatus(), response.getValue()));
    }

    public void getResult() {
        LocalDateTime timeToReturnFinalResponse = LocalDateTime.now().plus(Duration.ofMinutes(5L));
        PollerFlux poller = new PollerFlux(Duration.ofMillis(100L), context -> Mono.empty(), context -> {
            if (LocalDateTime.now().isBefore(timeToReturnFinalResponse)) {
                System.out.println("Returning intermediate response.");
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)"Operation in progress."));
            }
            System.out.println("Returning final response.");
            return Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)"Operation completed."));
        }, (activationResponse, context) -> Mono.just((Object)"FromServer:OperationIsCancelled"), context -> Mono.just((Object)"FromServer:FinalOutput"));
        poller.take(Duration.ofMinutes(30L)).last().flatMap(asyncPollResponse -> {
            if (asyncPollResponse.getStatus() == LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
                return asyncPollResponse.getFinalResult();
            }
            return Mono.error((Throwable)new RuntimeException("polling completed unsuccessfully with status:" + asyncPollResponse.getStatus()));
        }).block();
    }

    public void blockAndGetResult() {
        AsyncPollResponse terminalResponse = (AsyncPollResponse)this.pollerFlux.blockLast();
        System.out.printf("Polling complete. Final Status: %s", terminalResponse.getStatus());
        if (terminalResponse.getStatus() == LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String finalResult = (String)terminalResponse.getFinalResult().block();
            System.out.printf("Polling complete. Final Status: %s", finalResult);
        }
    }

    public void polluntil() {
        Predicate<AsyncPollResponse> isComplete = response -> response.getStatus() != LongRunningOperationStatus.IN_PROGRESS && response.getStatus() != LongRunningOperationStatus.NOT_STARTED;
        this.pollerFlux.takeUntil(isComplete).subscribe(completed -> System.out.println("Completed poll response, status: " + completed.getStatus()));
    }

    public void cancelOperation() {
        LocalDateTime timeToReturnFinalResponse = LocalDateTime.now().plus(Duration.ofMinutes(5L));
        PollerFlux poller = new PollerFlux(Duration.ofMillis(100L), context -> Mono.empty(), context -> {
            if (LocalDateTime.now().isBefore(timeToReturnFinalResponse)) {
                System.out.println("Returning intermediate response.");
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)"Operation in progress."));
            }
            System.out.println("Returning final response.");
            return Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)"Operation completed."));
        }, (activationResponse, context) -> Mono.just((Object)"FromServer:OperationIsCancelled"), context -> Mono.just((Object)"FromServer:FinalOutput"));
        poller.take(Duration.ofMinutes(30L)).last().flatMap(asyncPollResponse -> {
            if (!asyncPollResponse.getStatus().isComplete()) {
                return asyncPollResponse.cancelOperation().then(Mono.error((Throwable)new RuntimeException("Operation is cancelled!")));
            }
            return Mono.just((Object)asyncPollResponse);
        }).block();
    }

    public void initializeAndSubscribeWithPollingStrategy() {
        PollerFlux poller = PollerFlux.create((Duration)Duration.ofMillis(100L), () -> Mono.just((Object)new SimpleResponse(new HttpRequest(HttpMethod.POST, "http://httpbin.org"), 202, new HttpHeaders().set("Operation-Location", "http://httpbin.org"), null)), (PollingStrategy)new OperationResourcePollingStrategy(new HttpPipelineBuilder().build()), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(String.class));
        poller.subscribe(response -> System.out.printf("Got response. Status: %s, Value: %s%n", response.getStatus(), response.getValue()));
    }

    public void initializeAndSubscribeWithCustomPollingStrategy() {
        OperationResourcePollingStrategy<BinaryData, String> strategy = new OperationResourcePollingStrategy<BinaryData, String>(new HttpPipelineBuilder().build()){

            public Mono<PollResponse<BinaryData>> poll(PollingContext<BinaryData> context, TypeReference<BinaryData> pollResponseType) {
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)BinaryData.fromString((String)"")));
            }
        };
        PollerFlux poller = PollerFlux.create((Duration)Duration.ofMillis(100L), () -> Mono.just((Object)new SimpleResponse(new HttpRequest(HttpMethod.POST, "http://httpbin.org"), 202, new HttpHeaders().set("Operation-Location", "http://httpbin.org"), null)), (PollingStrategy)strategy, (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(String.class));
        poller.subscribe(response -> System.out.printf("Got response. Status: %s, Value: %s%n", response.getStatus(), response.getValue()));
    }
}

