/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.polling;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.MockHttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LocationPollingStrategy;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.OperationResourcePollingStrategy;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingStrategy;
import com.azure.core.util.polling.StatusCheckPollingStrategy;
import com.azure.core.util.serializer.TypeReference;
import java.time.Duration;
import java.util.function.Supplier;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public class PollingStrategyTests {
    @Mock
    private Supplier<Mono<Response<PollResult>>> activationOperation;
    @Mock
    private HttpClient httpClient;
    private AutoCloseable openMocks;

    @BeforeEach
    public void beforeTest() {
        this.openMocks = MockitoAnnotations.openMocks((Object)this);
    }

    @AfterEach
    public void afterTest() throws Exception {
        this.openMocks.close();
        Mockito.framework().clearInlineMocks();
    }

    @Test
    public void statusCheckPollingStrategySucceedsOnActivation() {
        int[] activationCallCount = new int[]{0};
        Mockito.when(this.activationOperation.get()).thenReturn((Object)Mono.defer(() -> {
            activationCallCount[0] = activationCallCount[0] + 1;
            SimpleResponse response = new SimpleResponse(new HttpRequest(HttpMethod.GET, "http://localhost"), 200, new HttpHeaders(), (Object)new PollResult("ActivationDone"));
            return Mono.just((Object)response);
        }));
        PollerFlux pollerFlux = PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.activationOperation.get(), (PollingStrategy)new StatusCheckPollingStrategy(), (TypeReference)new TypeReference<PollResult>(){}, (TypeReference)new TypeReference<PollResult>(){});
        StepVerifier.create((Publisher)pollerFlux).expectSubscription().expectNextMatches(asyncPollResponse -> asyncPollResponse.getStatus() == LongRunningOperationStatus.SUCCESSFULLY_COMPLETED).verifyComplete();
        Assertions.assertEquals((int)1, (int)activationCallCount[0]);
    }

    @Test
    public void operationLocationPollingStrategySucceedsOnPollWithResourceLocation() {
        int[] activationCallCount = new int[]{0};
        String mockPollUrl = "http://localhost/poll";
        String finalResultUrl = "http://localhost/final";
        Mockito.when(this.activationOperation.get()).thenReturn((Object)Mono.defer(() -> {
            activationCallCount[0] = activationCallCount[0] + 1;
            SimpleResponse response = new SimpleResponse(new HttpRequest(HttpMethod.POST, "http://localhost"), 200, new HttpHeaders().set("Operation-Location", mockPollUrl), (Object)new PollResult("InProgress"));
            return Mono.just((Object)response);
        }));
        HttpRequest pollRequest = new HttpRequest(HttpMethod.GET, mockPollUrl);
        Mockito.when((Object)this.httpClient.send((HttpRequest)ArgumentMatchers.any(), (Context)ArgumentMatchers.any())).thenAnswer(iom -> {
            HttpRequest req = (HttpRequest)iom.getArgument(0);
            if (mockPollUrl.equals(req.getUrl().toString())) {
                return Mono.just((Object)((Object)new MockHttpResponse(pollRequest, 200, new HttpHeaders(), new PollResult("Succeeded", finalResultUrl))));
            }
            if (finalResultUrl.equals(req.getUrl().toString())) {
                return Mono.just((Object)((Object)new MockHttpResponse(pollRequest, 200, new HttpHeaders(), new PollResult("final-state", finalResultUrl))));
            }
            return Mono.error((Throwable)new IllegalArgumentException("Unknown request URL " + req.getUrl()));
        });
        PollerFlux pollerFlux = PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.activationOperation.get(), (PollingStrategy)new OperationResourcePollingStrategy(new HttpPipelineBuilder().httpClient(this.httpClient).build()), (TypeReference)new TypeReference<PollResult>(){}, (TypeReference)new TypeReference<PollResult>(){});
        StepVerifier.create((Publisher)pollerFlux).expectSubscription().expectNextMatches(asyncPollResponse -> asyncPollResponse.getStatus() == LongRunningOperationStatus.IN_PROGRESS);
        StepVerifier.create((Publisher)pollerFlux.takeUntil(apr -> apr.getStatus().isComplete()).last().flatMap(AsyncPollResponse::getFinalResult)).expectNextMatches(pollResult -> "final-state".equals(pollResult.getStatus())).verifyComplete();
        Assertions.assertEquals((int)1, (int)activationCallCount[0]);
    }

    @Test
    public void operationLocationPollingStrategySucceedsOnPollWithPostLocationHeader() {
        int[] activationCallCount = new int[]{0};
        String mockPollUrl = "http://localhost/poll";
        String finalResultUrl = "http://localhost/final";
        Mockito.when(this.activationOperation.get()).thenReturn((Object)Mono.defer(() -> {
            activationCallCount[0] = activationCallCount[0] + 1;
            SimpleResponse response = new SimpleResponse(new HttpRequest(HttpMethod.POST, "http://localhost"), 200, new HttpHeaders().set("Operation-Location", mockPollUrl).set("Location", finalResultUrl), (Object)new PollResult("InProgress"));
            return Mono.just((Object)response);
        }));
        HttpRequest pollRequest = new HttpRequest(HttpMethod.GET, mockPollUrl);
        Mockito.when((Object)this.httpClient.send((HttpRequest)ArgumentMatchers.any(), (Context)ArgumentMatchers.any())).thenAnswer(iom -> {
            HttpRequest req = (HttpRequest)iom.getArgument(0);
            if (mockPollUrl.equals(req.getUrl().toString())) {
                return Mono.just((Object)((Object)new MockHttpResponse(pollRequest, 200, new HttpHeaders(), new PollResult("Succeeded"))));
            }
            if (finalResultUrl.equals(req.getUrl().toString())) {
                return Mono.just((Object)((Object)new MockHttpResponse(pollRequest, 200, new HttpHeaders(), new PollResult("final-state"))));
            }
            return Mono.error((Throwable)new IllegalArgumentException("Unknown request URL " + req.getUrl()));
        });
        PollerFlux pollerFlux = PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.activationOperation.get(), (PollingStrategy)new OperationResourcePollingStrategy(new HttpPipelineBuilder().httpClient(this.httpClient).build()), (TypeReference)new TypeReference<PollResult>(){}, (TypeReference)new TypeReference<PollResult>(){});
        StepVerifier.create((Publisher)pollerFlux).expectSubscription().expectNextMatches(asyncPollResponse -> asyncPollResponse.getStatus() == LongRunningOperationStatus.IN_PROGRESS);
        StepVerifier.create((Publisher)pollerFlux.takeUntil(apr -> apr.getStatus().isComplete()).last().flatMap(AsyncPollResponse::getFinalResult)).expectNextMatches(pollResult -> "final-state".equals(pollResult.getStatus())).verifyComplete();
        Assertions.assertEquals((int)1, (int)activationCallCount[0]);
    }

    @Test
    public void operationLocationPollingStrategySucceedsOnPollWithPut() {
        int[] activationCallCount = new int[]{0};
        String putUrl = "http://localhost";
        String mockPollUrl = "http://localhost/poll";
        Mockito.when(this.activationOperation.get()).thenReturn((Object)Mono.defer(() -> {
            activationCallCount[0] = activationCallCount[0] + 1;
            SimpleResponse response = new SimpleResponse(new HttpRequest(HttpMethod.PUT, putUrl), 200, new HttpHeaders().set("Operation-Location", mockPollUrl), (Object)new PollResult("InProgress"));
            return Mono.just((Object)response);
        }));
        HttpRequest pollRequest = new HttpRequest(HttpMethod.GET, mockPollUrl);
        Mockito.when((Object)this.httpClient.send((HttpRequest)ArgumentMatchers.any(), (Context)ArgumentMatchers.any())).thenAnswer(iom -> {
            HttpRequest req = (HttpRequest)iom.getArgument(0);
            if (mockPollUrl.equals(req.getUrl().toString())) {
                return Mono.just((Object)((Object)new MockHttpResponse(pollRequest, 200, new HttpHeaders(), new PollResult("Succeeded"))));
            }
            if (putUrl.equals(req.getUrl().toString())) {
                return Mono.just((Object)((Object)new MockHttpResponse(pollRequest, 200, new HttpHeaders(), new PollResult("final-state"))));
            }
            return Mono.error((Throwable)new IllegalArgumentException("Unknown request URL " + req.getUrl()));
        });
        PollerFlux pollerFlux = PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.activationOperation.get(), (PollingStrategy)new OperationResourcePollingStrategy(new HttpPipelineBuilder().httpClient(this.httpClient).build()), (TypeReference)new TypeReference<PollResult>(){}, (TypeReference)new TypeReference<PollResult>(){});
        StepVerifier.create((Publisher)pollerFlux).expectSubscription().expectNextMatches(asyncPollResponse -> asyncPollResponse.getStatus() == LongRunningOperationStatus.IN_PROGRESS);
        StepVerifier.create((Publisher)pollerFlux.takeUntil(apr -> apr.getStatus().isComplete()).last().flatMap(AsyncPollResponse::getFinalResult)).expectNextMatches(pollResult -> "final-state".equals(pollResult.getStatus())).verifyComplete();
        Assertions.assertEquals((int)1, (int)activationCallCount[0]);
    }

    @Test
    public void operationLocationPollingStrategyFailsOnPoll() {
        int[] activationCallCount = new int[]{0};
        String mockPollUrl = "http://localhost/poll";
        Mockito.when(this.activationOperation.get()).thenReturn((Object)Mono.defer(() -> {
            activationCallCount[0] = activationCallCount[0] + 1;
            SimpleResponse response = new SimpleResponse(new HttpRequest(HttpMethod.POST, "http://localhost"), 200, new HttpHeaders().set("Operation-Location", mockPollUrl), (Object)new PollResult("InProgress"));
            return Mono.just((Object)response);
        }));
        HttpRequest pollRequest = new HttpRequest(HttpMethod.GET, mockPollUrl);
        Mockito.when((Object)this.httpClient.send((HttpRequest)ArgumentMatchers.any(), (Context)ArgumentMatchers.any())).thenAnswer(iom -> {
            HttpRequest req = (HttpRequest)iom.getArgument(0);
            if (mockPollUrl.equals(req.getUrl().toString())) {
                return Mono.just((Object)((Object)new MockHttpResponse(pollRequest, 200, new HttpHeaders(), new PollResult("Failed"))));
            }
            return Mono.error((Throwable)new IllegalArgumentException("Unknown request URL " + req.getUrl()));
        });
        PollerFlux pollerFlux = PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.activationOperation.get(), (PollingStrategy)new OperationResourcePollingStrategy(new HttpPipelineBuilder().httpClient(this.httpClient).build()), (TypeReference)new TypeReference<PollResult>(){}, (TypeReference)new TypeReference<PollResult>(){});
        StepVerifier.create((Publisher)pollerFlux).expectSubscription().expectNextMatches(asyncPollResponse -> asyncPollResponse.getStatus() == LongRunningOperationStatus.IN_PROGRESS);
        StepVerifier.create((Publisher)pollerFlux.takeUntil(apr -> apr.getStatus().isComplete()).last().flatMap(AsyncPollResponse::getFinalResult)).expectErrorMessage("Long running operation failed.").verify();
        Assertions.assertEquals((int)1, (int)activationCallCount[0]);
    }

    @Test
    public void locationPollingStrategySucceedsOnPollWithPostLocationHeader() {
        int[] activationCallCount = new int[]{0};
        String mockPollUrl = "http://localhost/poll";
        String finalResultUrl = "http://localhost/final";
        Mockito.when(this.activationOperation.get()).thenReturn((Object)Mono.defer(() -> {
            activationCallCount[0] = activationCallCount[0] + 1;
            SimpleResponse response = new SimpleResponse(new HttpRequest(HttpMethod.POST, "http://localhost"), 200, new HttpHeaders().set("Location", mockPollUrl), (Object)new PollResult("InProgress"));
            return Mono.just((Object)response);
        }));
        HttpRequest pollRequest = new HttpRequest(HttpMethod.GET, mockPollUrl);
        Mockito.when((Object)this.httpClient.send((HttpRequest)ArgumentMatchers.any(), (Context)ArgumentMatchers.any())).thenAnswer(iom -> {
            HttpRequest req = (HttpRequest)iom.getArgument(0);
            if (mockPollUrl.equals(req.getUrl().toString())) {
                return Mono.just((Object)((Object)new MockHttpResponse(pollRequest, 200, new HttpHeaders().set("Location", finalResultUrl), new PollResult("Succeeded"))));
            }
            if (finalResultUrl.equals(req.getUrl().toString())) {
                return Mono.just((Object)((Object)new MockHttpResponse(pollRequest, 200, new HttpHeaders(), new PollResult("final-state"))));
            }
            return Mono.error((Throwable)new IllegalArgumentException("Unknown request URL " + req.getUrl()));
        });
        PollerFlux pollerFlux = PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.activationOperation.get(), (PollingStrategy)new LocationPollingStrategy(new HttpPipelineBuilder().httpClient(this.httpClient).build()), (TypeReference)new TypeReference<PollResult>(){}, (TypeReference)new TypeReference<PollResult>(){});
        StepVerifier.create((Publisher)pollerFlux).expectSubscription().expectNextMatches(asyncPollResponse -> asyncPollResponse.getStatus() == LongRunningOperationStatus.IN_PROGRESS);
        StepVerifier.create((Publisher)pollerFlux.takeUntil(apr -> apr.getStatus().isComplete()).last().flatMap(AsyncPollResponse::getFinalResult)).expectNextMatches(pollResult -> "final-state".equals(pollResult.getStatus())).verifyComplete();
        Assertions.assertEquals((int)1, (int)activationCallCount[0]);
    }

    public static class PollResult {
        private String status;
        private String resourceLocation;

        public PollResult() {
        }

        public PollResult(String status) {
            this.status = status;
            this.resourceLocation = null;
        }

        public PollResult(String status, String resourceLocation) {
            this.status = status;
            this.resourceLocation = resourceLocation;
        }

        public String getStatus() {
            return this.status;
        }

        public PollResult setStatus(String status) {
            this.status = status;
            return this;
        }

        public String getResourceLocation() {
            return this.resourceLocation;
        }

        public PollResult setResourceLocation(String resourceLocation) {
            this.resourceLocation = resourceLocation;
            return this;
        }

        public String toString() {
            return "Status: " + this.status;
        }
    }
}

