/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.NewFoo;
import com.azure.core.util.serializer.NewFooChild;
import com.azure.core.util.serializer.SerializerEncoding;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AdditionalPropertiesSerializerWithJacksonAnnotationTests {
    @Test
    public void canSerializeAdditionalProperties() throws Exception {
        NewFoo foo = new NewFoo();
        foo.bar("hello.world");
        foo.baz(new ArrayList<String>());
        foo.baz().add("hello");
        foo.baz().add("hello.world");
        foo.qux(new HashMap<String, String>());
        foo.qux().put("hello", "world");
        foo.qux().put("a.b", "c.d");
        foo.qux().put("bar.a", "ttyy");
        foo.qux().put("bar.b", "uuzz");
        foo.additionalProperties(new HashMap<String, Object>());
        foo.additionalProperties().put("bar", "baz");
        foo.additionalProperties().put("a.b", "c.d");
        foo.additionalProperties().put("properties.bar", "barbar");
        String serialized = new JacksonAdapter().serialize((Object)foo, SerializerEncoding.JSON);
        Assertions.assertEquals((Object)"{\"$type\":\"newfoo\",\"bar\":\"baz\",\"properties\":{\"bar\":\"hello.world\",\"props\":{\"baz\":[\"hello\",\"hello.world\"],\"q\":{\"qux\":{\"hello\":\"world\",\"a.b\":\"c.d\",\"bar.b\":\"uuzz\",\"bar.a\":\"ttyy\"}}}},\"a.b\":\"c.d\",\"properties.bar\":\"barbar\"}", (Object)serialized);
    }

    @Test
    public void canDeserializeAdditionalProperties() throws Exception {
        String wireValue = "{\"$type\":\"newfoo\",\"properties\":{\"bar\":\"hello.world\",\"props\":{\"baz\":[\"hello\",\"hello.world\"],\"q\":{\"qux\":{\"hello\":\"world\",\"a.b\":\"c.d\",\"bar.b\":\"uuzz\",\"bar.a\":\"ttyy\"}}}},\"bar\":\"baz\",\"a.b\":\"c.d\",\"properties.bar\":\"barbar\"}";
        NewFoo deserialized = (NewFoo)new JacksonAdapter().deserialize(wireValue, NewFoo.class, SerializerEncoding.JSON);
        Assertions.assertNotNull(deserialized.additionalProperties());
        Assertions.assertEquals((Object)"baz", (Object)deserialized.additionalProperties().get("bar"));
        Assertions.assertEquals((Object)"c.d", (Object)deserialized.additionalProperties().get("a.b"));
        Assertions.assertEquals((Object)"barbar", (Object)deserialized.additionalProperties().get("properties.bar"));
    }

    @Test
    public void canSerializeAdditionalPropertiesThroughInheritance() throws Exception {
        NewFooChild foo = new NewFooChild();
        foo.bar("hello.world");
        foo.baz(new ArrayList<String>());
        foo.baz().add("hello");
        foo.baz().add("hello.world");
        foo.qux(new HashMap<String, String>());
        foo.qux().put("hello", "world");
        foo.qux().put("a.b", "c.d");
        foo.qux().put("bar.a", "ttyy");
        foo.qux().put("bar.b", "uuzz");
        foo.additionalProperties(new HashMap<String, Object>());
        foo.additionalProperties().put("bar", "baz");
        foo.additionalProperties().put("a.b", "c.d");
        foo.additionalProperties().put("properties.bar", "barbar");
        String serialized = new JacksonAdapter().serialize((Object)foo, SerializerEncoding.JSON);
        Assertions.assertEquals((Object)"{\"$type\":\"newfoochild\",\"bar\":\"baz\",\"properties\":{\"bar\":\"hello.world\",\"props\":{\"baz\":[\"hello\",\"hello.world\"],\"q\":{\"qux\":{\"hello\":\"world\",\"a.b\":\"c.d\",\"bar.b\":\"uuzz\",\"bar.a\":\"ttyy\"}}}},\"a.b\":\"c.d\",\"properties.bar\":\"barbar\"}", (Object)serialized);
    }

    @Test
    public void canDeserializeAdditionalPropertiesThroughInheritance() throws Exception {
        String wireValue = "{\"$type\":\"newfoochild\",\"properties\":{\"bar\":\"hello.world\",\"props\":{\"baz\":[\"hello\",\"hello.world\"],\"q\":{\"qux\":{\"hello\":\"world\",\"a.b\":\"c.d\",\"bar.b\":\"uuzz\",\"bar.a\":\"ttyy\"}}}},\"bar\":\"baz\",\"a.b\":\"c.d\",\"properties.bar\":\"barbar\"}";
        NewFoo deserialized = (NewFoo)new JacksonAdapter().deserialize(wireValue, NewFoo.class, SerializerEncoding.JSON);
        Assertions.assertNotNull(deserialized.additionalProperties());
        Assertions.assertEquals((Object)"baz", (Object)deserialized.additionalProperties().get("bar"));
        Assertions.assertEquals((Object)"c.d", (Object)deserialized.additionalProperties().get("a.b"));
        Assertions.assertEquals((Object)"barbar", (Object)deserialized.additionalProperties().get("properties.bar"));
        Assertions.assertTrue((boolean)(deserialized instanceof NewFooChild));
    }

    @Test
    public void canSerializeAdditionalPropertiesWithNestedAdditionalProperties() throws Exception {
        NewFoo foo = new NewFoo();
        foo.bar("hello.world");
        foo.baz(new ArrayList<String>());
        foo.baz().add("hello");
        foo.baz().add("hello.world");
        foo.qux(new HashMap<String, String>());
        foo.qux().put("hello", "world");
        foo.qux().put("a.b", "c.d");
        foo.qux().put("bar.a", "ttyy");
        foo.qux().put("bar.b", "uuzz");
        foo.additionalProperties(new HashMap<String, Object>());
        foo.additionalProperties().put("bar", "baz");
        foo.additionalProperties().put("a.b", "c.d");
        foo.additionalProperties().put("properties.bar", "barbar");
        NewFoo nestedNewFoo = new NewFoo();
        nestedNewFoo.bar("bye.world");
        nestedNewFoo.additionalProperties(new HashMap<String, Object>());
        nestedNewFoo.additionalProperties().put("name", "Sushi");
        foo.additionalProperties().put("foo", nestedNewFoo);
        String serialized = new JacksonAdapter().serialize((Object)foo, SerializerEncoding.JSON);
        Assertions.assertEquals((Object)"{\"$type\":\"newfoo\",\"bar\":\"baz\",\"foo\":{\"name\":\"Sushi\",\"properties\":{\"bar\":\"bye.world\"}},\"properties\":{\"bar\":\"hello.world\",\"props\":{\"baz\":[\"hello\",\"hello.world\"],\"q\":{\"qux\":{\"hello\":\"world\",\"a.b\":\"c.d\",\"bar.b\":\"uuzz\",\"bar.a\":\"ttyy\"}}}},\"a.b\":\"c.d\",\"properties.bar\":\"barbar\"}", (Object)serialized);
    }

    @Test
    public void canSerializeAdditionalPropertiesWithConflictProperty() throws Exception {
        NewFoo foo = new NewFoo();
        foo.bar("hello.world");
        foo.baz(new ArrayList<String>());
        foo.baz().add("hello");
        foo.baz().add("hello.world");
        foo.qux(new HashMap<String, String>());
        foo.qux().put("hello", "world");
        foo.qux().put("a.b", "c.d");
        foo.qux().put("bar.a", "ttyy");
        foo.qux().put("bar.b", "uuzz");
        foo.additionalProperties(new HashMap<String, Object>());
        foo.additionalProperties().put("bar", "baz");
        foo.additionalProperties().put("a.b", "c.d");
        foo.additionalProperties().put("properties.bar", "barbar");
        foo.additionalPropertiesProperty(new HashMap<String, Object>());
        foo.additionalPropertiesProperty().put("age", 73);
        String serialized = new JacksonAdapter().serialize((Object)foo, SerializerEncoding.JSON);
        Assertions.assertEquals((Object)"{\"$type\":\"newfoo\",\"additionalProperties\":{\"age\":73},\"bar\":\"baz\",\"properties\":{\"bar\":\"hello.world\",\"props\":{\"baz\":[\"hello\",\"hello.world\"],\"q\":{\"qux\":{\"hello\":\"world\",\"a.b\":\"c.d\",\"bar.b\":\"uuzz\",\"bar.a\":\"ttyy\"}}}},\"a.b\":\"c.d\",\"properties.bar\":\"barbar\"}", (Object)serialized);
    }

    @Test
    public void canDeserializeAdditionalPropertiesWithConflictProperty() throws Exception {
        String wireValue = "{\"$type\":\"newfoo\",\"properties\":{\"bar\":\"hello.world\",\"props\":{\"baz\":[\"hello\",\"hello.world\"],\"q\":{\"qux\":{\"hello\":\"world\",\"a.b\":\"c.d\",\"bar.b\":\"uuzz\",\"bar.a\":\"ttyy\"}}}},\"bar\":\"baz\",\"a.b\":\"c.d\",\"properties.bar\":\"barbar\",\"additionalProperties\":{\"age\":73}}";
        NewFoo deserialized = (NewFoo)new JacksonAdapter().deserialize(wireValue, NewFoo.class, SerializerEncoding.JSON);
        Assertions.assertNotNull(deserialized.additionalProperties());
        Assertions.assertEquals((Object)"baz", (Object)deserialized.additionalProperties().get("bar"));
        Assertions.assertEquals((Object)"c.d", (Object)deserialized.additionalProperties().get("a.b"));
        Assertions.assertEquals((Object)"barbar", (Object)deserialized.additionalProperties().get("properties.bar"));
        Assertions.assertEquals((int)1, (int)deserialized.additionalPropertiesProperty().size());
        Assertions.assertEquals((Object)73, (Object)deserialized.additionalPropertiesProperty().get("age"));
    }
}

