/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.models.GeoBoundingBox;
import com.azure.core.models.GeoCollection;
import com.azure.core.models.GeoLineString;
import com.azure.core.models.GeoLineStringCollection;
import com.azure.core.models.GeoLinearRing;
import com.azure.core.models.GeoObject;
import com.azure.core.models.GeoPoint;
import com.azure.core.models.GeoPointCollection;
import com.azure.core.models.GeoPolygon;
import com.azure.core.models.GeoPolygonCollection;
import com.azure.core.models.GeoPosition;
import com.azure.core.util.serializer.GeoSerializationTestHelpers;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public class GeoJsonDeserializerTests {
    private static final JacksonAdapter ADAPTER = new JacksonAdapter();

    @Test
    public void jsonWithoutTypeThrows() {
        String missingType = "{\"coordinates\":[0,0]}";
        Assertions.assertThrows(IllegalStateException.class, () -> ADAPTER.deserialize(missingType, GeoObject.class, SerializerEncoding.JSON));
    }

    @Test
    public void jsonWithoutCoordinatesThrows() {
        String missingCoordinates = "{\"type\":\"Point\"}";
        Assertions.assertThrows(IllegalStateException.class, () -> ADAPTER.deserialize(missingCoordinates, GeoPoint.class, SerializerEncoding.JSON));
    }

    @Test
    public void unknownGeoTypeThrows() {
        String unknownType = "{\"type\":\"Custom\",\"coordinates\":[0,0]}";
        Assertions.assertThrows(IllegalStateException.class, () -> ADAPTER.deserialize(unknownType, GeoObject.class, SerializerEncoding.JSON));
    }

    @ParameterizedTest
    @ValueSource(strings={"{\"type\":\"Point\",\"coordinates\":[1]}", "{\"type\":\"Point\",\"coordinates\":[4,4,4,4]}"})
    public void invalidCoordinateCountThrows(String invalidCoordinateCount) {
        Assertions.assertThrows(IllegalStateException.class, () -> ADAPTER.deserialize(invalidCoordinateCount, GeoPoint.class, SerializerEncoding.JSON));
    }

    @ParameterizedTest
    @ValueSource(strings={"{\"type\":\"Point\",\"coordinates\":[0,0],\"bbox\":[2,2]}", "{\"type\":\"Point\",\"coordinates\":[0,0],\"bbox\":[8,8,8,8,8,8,8,8]}"})
    public void invalidBoundBoxThrows(String invalidBoundBox) {
        Assertions.assertThrows(IllegalStateException.class, () -> ADAPTER.deserialize(invalidBoundBox, GeoPoint.class, SerializerEncoding.JSON));
    }

    @Test
    public void collectionWithoutGeometriesThrows() {
        String invalidCollection = "{\"type\":\"GeometryCollection\"}";
        Assertions.assertThrows(IllegalStateException.class, () -> ADAPTER.deserialize(invalidCollection, GeoCollection.class, SerializerEncoding.JSON));
    }

    @ParameterizedTest
    @MethodSource(value={"deserializeSupplier"})
    public <T extends GeoObject> void deserialize(String json, Class<T> type, T expectedGeo) throws IOException {
        Assertions.assertEquals(expectedGeo, (Object)ADAPTER.deserialize(json, type, SerializerEncoding.JSON));
    }

    private static Stream<Arguments> deserializeSupplier() {
        GeoBoundingBox boundingBox = new GeoBoundingBox(0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        Map<String, Object> simpleProperties = Collections.singletonMap("key", "value");
        Map<String, Object> arrayProperties = Collections.singletonMap("text", Arrays.asList("hello", "world"));
        HashMap<String, Object> crs = new HashMap<String, Object>();
        crs.put("type", "name");
        crs.put("properties", Collections.singletonMap("name", "EPSG:432"));
        Map<String, Object> objectProperties = Collections.singletonMap("crs", crs);
        BiFunction<GeoBoundingBox, Map, GeoPoint> pointSupplier = (box, properties) -> new GeoPoint(new GeoPosition(0.0, 0.0, Double.valueOf(0.0)), box, properties);
        List<GeoPosition> positions = Arrays.asList(new GeoPosition(0.0, 0.0, Double.valueOf(1.0)), new GeoPosition(1.0, 1.0, Double.valueOf(1.0)));
        BiFunction<GeoBoundingBox, Map, GeoLineString> lineSupplier = (box, properties) -> new GeoLineString(positions, box, properties);
        List<GeoLinearRing> rings = Collections.singletonList(new GeoLinearRing(Arrays.asList(new GeoPosition(0.0, 0.0, Double.valueOf(1.0)), new GeoPosition(0.0, 1.0, Double.valueOf(1.0)), new GeoPosition(1.0, 1.0, Double.valueOf(1.0)), new GeoPosition(0.0, 0.0, Double.valueOf(1.0)))));
        BiFunction<GeoBoundingBox, Map, GeoPolygon> polygonSupplier = (box, properties) -> new GeoPolygon(rings, box, properties);
        BiFunction<GeoBoundingBox, Map, GeoPointCollection> multiPointSupplier = (box, properties) -> new GeoPointCollection(Arrays.asList((GeoPoint)pointSupplier.apply(null, null), (GeoPoint)pointSupplier.apply(null, null)), box, properties);
        BiFunction<GeoBoundingBox, Map, GeoLineStringCollection> multiLineSupplier = (box, properties) -> new GeoLineStringCollection(Arrays.asList((GeoLineString)lineSupplier.apply(null, null), (GeoLineString)lineSupplier.apply(null, null)), box, properties);
        BiFunction<GeoBoundingBox, Map, GeoPolygonCollection> multiPolygonSuppluer = (box, properties) -> new GeoPolygonCollection(Arrays.asList((GeoPolygon)polygonSupplier.apply(null, null), (GeoPolygon)polygonSupplier.apply(null, null)), box, properties);
        BiFunction<GeoBoundingBox, Map, GeoCollection> collectionSupplier = (box, properties) -> new GeoCollection(Arrays.asList((GeoObject)pointSupplier.apply(null, null), (GeoObject)multiLineSupplier.apply((GeoBoundingBox)box, (Map)properties), (GeoObject)polygonSupplier.apply((GeoBoundingBox)box, (Map)properties)), box, properties);
        return Stream.of(Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(null, null, pointSupplier)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(boundingBox, simpleProperties, pointSupplier)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(boundingBox, arrayProperties, pointSupplier)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(boundingBox, objectProperties, pointSupplier)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(null, null, lineSupplier)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(boundingBox, simpleProperties, lineSupplier)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(boundingBox, arrayProperties, lineSupplier)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(boundingBox, objectProperties, lineSupplier)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(null, null, polygonSupplier)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(boundingBox, simpleProperties, polygonSupplier)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(boundingBox, arrayProperties, polygonSupplier)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(boundingBox, objectProperties, polygonSupplier)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(null, null, multiPointSupplier)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(boundingBox, simpleProperties, multiPointSupplier)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(boundingBox, arrayProperties, multiPointSupplier)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(boundingBox, objectProperties, multiPointSupplier)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(null, null, multiLineSupplier)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(boundingBox, simpleProperties, multiLineSupplier)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(boundingBox, arrayProperties, multiLineSupplier)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(boundingBox, objectProperties, multiLineSupplier)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(null, null, multiPolygonSuppluer)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(boundingBox, simpleProperties, multiPolygonSuppluer)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(boundingBox, arrayProperties, multiPolygonSuppluer)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(boundingBox, objectProperties, multiPolygonSuppluer)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(null, null, collectionSupplier)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(boundingBox, simpleProperties, collectionSupplier)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(boundingBox, arrayProperties, collectionSupplier)), Arguments.of((Object[])GeoJsonDeserializerTests.deserializerArgumentSupplier(boundingBox, objectProperties, collectionSupplier)));
    }

    private static Object[] deserializerArgumentSupplier(GeoBoundingBox boundingBox, Map<String, Object> properties, BiFunction<GeoBoundingBox, Map<String, Object>, ? extends GeoObject> geoSupplier) {
        GeoObject geoObject = geoSupplier.apply(boundingBox, properties);
        return new Object[]{GeoSerializationTestHelpers.geoToJson(geoObject), geoObject.getClass(), geoObject};
    }
}

