/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.tracing;

import com.azure.core.util.Context;
import com.azure.core.util.tracing.ProcessKind;
import com.azure.core.util.tracing.SpanKind;
import com.azure.core.util.tracing.StartSpanOptions;
import com.azure.core.util.tracing.Tracer;

public class TracerJavaDocCodeSnippets {
    final Tracer tracer = new TracerImplementation();

    public void startTracingSpan() {
        Context traceContext = new Context((Object)"parent-span", (Object)"<user-current-span>");
        Context updatedContext = this.tracer.start("azure.keyvault.secrets/setsecret", traceContext);
        System.out.printf("Span returned in the context object: %s%n", updatedContext.getData((Object)"parent-span").get());
        StartSpanOptions options = new StartSpanOptions(SpanKind.CLIENT).setAttribute("key", (Object)"value");
        Context updatedClientSpanContext = this.tracer.start("azure.keyvault.secrets/setsecret", options, traceContext);
        System.out.printf("Span returned in the context object: %s%n", updatedClientSpanContext.getData((Object)"parent-span").get());
        Context sendContext = new Context((Object)"parent-span", (Object)"<user-current-span>").addData((Object)"entity-path", (Object)"entity-path").addData((Object)"hostname", (Object)"hostname");
        Context updatedSendContext = this.tracer.start("azure.eventhubs.send", sendContext, ProcessKind.SEND);
        System.out.printf("Span returned in the context object: %s%n", updatedSendContext.getData((Object)"parent-span").get());
        String diagnosticIdKey = "Diagnostic-Id";
        Context updatedReceiveContext = this.tracer.start("azure.eventhubs.receive", traceContext, ProcessKind.MESSAGE);
        System.out.printf("Diagnostic Id: %s%n", updatedReceiveContext.getData((Object)diagnosticIdKey).get().toString());
        String spanImplContext = "span-context";
        Context processContext = new Context((Object)"parent-span", (Object)"<user-current-span>").addData((Object)spanImplContext, (Object)"<user-current-span-context>");
        Context updatedProcessContext = this.tracer.start("azure.eventhubs.process", processContext, ProcessKind.PROCESS);
        System.out.printf("Scope: %s%n", updatedProcessContext.getData((Object)"scope").get());
    }

    public void endTracingSpan() {
        String openTelemetrySpanKey = "openTelemetry-span";
        Context traceContext = new Context((Object)"parent-span", (Object)"<user-current-span>");
        this.tracer.end(200, null, traceContext);
        this.tracer.end("success", null, traceContext);
    }

    public void setSpanName() {
        String openTelemetrySpanKey = "openTelemetry-span";
        Context context = this.tracer.setSpanName("test-span-method", Context.NONE);
        System.out.printf("Span name: %s%n", context.getData((Object)"parent-span").get().toString());
    }

    public void addLink() {
        Context parentContext = new Context((Object)"parent-span", (Object)"<user-current-span>");
        Context spanContext = this.tracer.start("test.method", parentContext, ProcessKind.MESSAGE);
        this.tracer.addLink(spanContext);
    }

    public void extractContext() {
        String spanImplContext = "span-context";
        Context spanContext = this.tracer.extractContext("valid-diagnostic-id", Context.NONE);
        System.out.printf("Span context of the current tracing span: %s%n", spanContext.getData((Object)spanImplContext).get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeSpanCurrent() {
        Context traceContext = this.tracer.start("EventHub.process", Context.NONE);
        try (AutoCloseable ignored = this.tracer.makeSpanCurrent(traceContext);){
            System.out.println("doing some work...");
        }
        catch (Throwable throwable) {
            this.tracer.end("Failure", throwable, traceContext);
        }
        finally {
            this.tracer.end("OK", null, traceContext);
        }
    }

    public void getSharedSpanBuilder() {
        String methodName = "message-span";
        Context spanContext = this.tracer.getSharedSpanBuilder(methodName, Context.NONE);
        System.out.printf("Span context of the current tracing span: %s%n", spanContext.getData((Object)"builder").get());
    }

    private static final class TracerImplementation
    implements Tracer {
        private TracerImplementation() {
        }

        public Context start(String methodName, Context context) {
            return null;
        }

        public Context start(String methodName, Context context, ProcessKind processKind) {
            return null;
        }

        public void end(int responseCode, Throwable error, Context context) {
        }

        public void end(String errorCondition, Throwable error, Context context) {
        }

        public void setAttribute(String key, String value, Context context) {
        }

        public Context setSpanName(String spanName, Context context) {
            return null;
        }

        public void addLink(Context context) {
        }

        public Context extractContext(String diagnosticId, Context context) {
            return null;
        }

        public Context getSharedSpanBuilder(String spanName, Context context) {
            return null;
        }
    }
}

