/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.polling;

import com.azure.core.exception.AzureException;
import com.azure.core.http.rest.Response;
import com.azure.core.implementation.serializer.DefaultJsonSerializer;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.PollingStrategy;
import com.azure.core.util.polling.implementation.PollingUtils;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import java.time.Duration;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class StatusCheckPollingStrategy<T, U>
implements PollingStrategy<T, U> {
    private final ObjectSerializer serializer;

    public StatusCheckPollingStrategy() {
        this(new DefaultJsonSerializer());
    }

    public StatusCheckPollingStrategy(ObjectSerializer serializer) {
        this.serializer = Objects.requireNonNull(serializer, "'serializer' cannot be null");
    }

    @Override
    public Mono<Boolean> canPoll(Response<?> initialResponse) {
        return Mono.just((Object)true);
    }

    @Override
    public Mono<PollResponse<T>> onInitialResponse(Response<?> response, PollingContext<T> pollingContext, TypeReference<T> pollResponseType) {
        if (response.getStatusCode() == 200 || response.getStatusCode() == 201 || response.getStatusCode() == 202 || response.getStatusCode() == 204) {
            String retryAfterValue = response.getHeaders().getValue("Retry-After");
            Duration retryAfter = retryAfterValue == null ? null : Duration.ofSeconds(Long.parseLong(retryAfterValue));
            return PollingUtils.convertResponse(response.getValue(), this.serializer, pollResponseType).map(value -> new PollResponse<Object>(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, value, retryAfter)).switchIfEmpty(Mono.defer(() -> Mono.just(new PollResponse<Object>(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, null, retryAfter))));
        }
        return Mono.error((Throwable)new AzureException("Operation failed or cancelled: " + response.getStatusCode()));
    }

    @Override
    public Mono<PollResponse<T>> poll(PollingContext<T> context, TypeReference<T> pollResponseType) {
        return Mono.error((Throwable)new IllegalStateException("StatusCheckPollingStrategy doesn't support polling"));
    }

    @Override
    public Mono<U> getResult(PollingContext<T> pollingContext, TypeReference<U> resultType) {
        T activationResponse = pollingContext.getActivationResponse().getValue();
        return PollingUtils.convertResponse(activationResponse, this.serializer, resultType);
    }
}

